/*
 * Decompiled with CFR 0.152.
 */
package jminhep.algorithms;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.cluster.Get;
import jminhep.gui.SetEnv;
import jminhep.utils.ArrayOps;
import jminhep.utils.VEC;
import org.apache.commons.math3.util.FastMath;

public class KMeansExchangeAlg {
    public final double MAXVAL = 1.0E12;
    public final double R = 0.999;
    private double[][] indat;
    private double[][] indatstd;
    private int nrow;
    private int ncol;
    private int numClusters;
    private double compactness;
    private double[] cardinality;
    private int epochmax = 15;
    private int Ierr = 0;
    private double[][] clusterCenters;
    private int[] assignment;
    private String description;
    private DataHolder cMeans;
    private DataHolder cSeeds;
    private DataHolder data;

    public KMeansExchangeAlg(DataHolder data) {
        this.data = data;
        this.nrow = data.getSize();
        this.ncol = data.getDimention();
        SetEnv.NRow = this.nrow;
        SetEnv.Dim = this.ncol;
        this.Ierr = 0;
        this.numClusters = 0;
        this.compactness = 9999.0;
        this.Ierr = 0;
        this.description = "K-means clustering using exchange method";
        this.indat = new double[this.nrow][this.ncol];
        this.assignment = new int[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = data.getRow(i);
            for (int i2 = 0; i2 < this.ncol; ++i2) {
                this.indat[i][i2] = dp.getAttribute(i2);
            }
        }
        this.indatstd = VEC.Standardize(this.nrow, this.ncol, this.indat);
    }

    public void setEpochMax(int N) {
        this.epochmax = N;
    }

    public int getError() {
        return this.Ierr;
    }

    public void setClusters(int Nclu) {
        this.numClusters = Nclu;
    }

    public int getClusters() {
        return this.numClusters;
    }

    public DataHolder getCenters() {
        return this.cMeans;
    }

    public DataHolder getSeedHolder() {
        return this.cSeeds;
    }

    public int[] getNumberPoints() {
        int[] size = new int[this.numClusters];
        for (int i = 0; i < this.numClusters; ++i) {
            size[i] = (int)this.cardinality[i];
        }
        return size;
    }

    public double getCompactness() {
        return this.compactness;
    }

    public void runBest() {
        int iter = 1 + this.nrow / 2;
        double[] selec = new double[iter];
        for (int j = 0; j < iter; ++j) {
            selec[j] = Double.MAX_VALUE;
        }
        int[] clus = new int[iter];
        int N = 0;
        for (int j = 0; j < iter; ++j) {
            int nclus = 2 + j;
            this.setClusters(nclus);
            this.run();
            selec[j] = this.compactness;
            clus[j] = nclus;
            ++N;
            if (j > 5 && selec[j - 1] < selec[j] && selec[j - 2] < selec[j - 1]) break;
        }
        int ibest = ArrayOps.findSmallest(selec, N);
        this.setClusters(clus[ibest]);
        this.run();
        this.description = "K-means clustering using exchange method for best estimate";
    }

    public void run() {
        int i;
        int j;
        int i2;
        this.Ierr = 0;
        Matrix X = new Matrix(this.indatstd);
        this.clusterCenters = new double[this.numClusters][this.ncol];
        Matrix Xprime = X.transpose();
        Matrix SSCP = Xprime.times(X);
        EigenvalueDecomposition evaldec = SSCP.eig();
        Matrix evecs = evaldec.getV();
        double[][] tempold = evecs.getArray();
        double[][] tempnew = new double[this.ncol][this.ncol];
        for (int j1 = 0; j1 < this.ncol; ++j1) {
            for (int j2 = 0; j2 < this.ncol; ++j2) {
                tempnew[j1][j2] = tempold[j1][this.ncol - j2 - 1];
            }
        }
        Matrix Evecs = new Matrix(tempnew);
        Matrix rowproj = X.times(Evecs);
        double[] tempvec = new double[this.nrow];
        double[] rproj = new double[this.nrow];
        tempold = rowproj.getArray();
        for (int i3 = 0; i3 < this.nrow; ++i3) {
            tempvec[i3] = tempold[i3][0];
            rproj[i3] = tempold[i3][0];
        }
        VEC.inSort(tempvec);
        int[] breakindexes = new int[this.numClusters + 1];
        double[] breakpoints = new double[this.numClusters + 1];
        breakpoints[0] = tempvec[0] - 0.1;
        breakpoints[this.numClusters] = tempvec[this.nrow - 1];
        for (int i4 = 1; i4 < this.numClusters; ++i4) {
            breakindexes[i4] = i4 * this.nrow / this.numClusters;
            breakpoints[i4] = tempvec[breakindexes[i4]];
        }
        double[][] gpmeans = new double[this.numClusters][this.ncol];
        this.cardinality = new double[this.numClusters];
        for (i2 = 0; i2 < this.numClusters - 1; ++i2) {
            this.cardinality[i2] = 0.0;
            for (j = 0; j < this.ncol - 1; ++j) {
                gpmeans[i2][j] = 0.0;
            }
        }
        for (int icl = 0; icl < this.numClusters; ++icl) {
            for (int i5 = 0; i5 < this.nrow; ++i5) {
                if (!(rproj[i5] > breakpoints[icl]) || !(rproj[i5] <= breakpoints[icl + 1])) continue;
                this.assignment[i5] = icl;
                int n = icl;
                this.cardinality[n] = this.cardinality[n] + 1.0;
                for (int j2 = 0; j2 < this.ncol; ++j2) {
                    double[] dArray = gpmeans[icl];
                    int n2 = j2;
                    dArray[n2] = dArray[n2] + this.indat[i5][j2];
                }
            }
            j = 0;
            while (j < this.ncol) {
                double[] dArray = gpmeans[icl];
                int n = j++;
                dArray[n] = dArray[n] / this.cardinality[icl];
            }
        }
        for (i2 = 0; i2 < this.numClusters; ++i2) {
            if (!(this.cardinality[i2] <= 1.0)) continue;
            this.Ierr = 1;
            break;
        }
        this.cSeeds = new DataHolder();
        for (i2 = 0; i2 < this.numClusters; ++i2) {
            double[] a = new double[this.ncol];
            for (int j3 = 0; j3 < this.ncol; ++j3) {
                a[j3] = gpmeans[i2][j3];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            this.cSeeds.add(c);
        }
        double compac = 0.0;
        for (int i6 = 0; i6 < this.nrow; ++i6) {
            for (int j4 = 0; j4 < this.ncol; ++j4) {
                compac += Math.pow(this.indat[i6][j4] - gpmeans[this.assignment[i6]][j4], 2.0);
            }
        }
        int epoch = 0;
        double oldcompactness = 1.0E12;
        double prevcontrib = 0.0;
        double newcontrib = 0.0;
        int oldclus = 0;
        double eps = 0.001;
        double dissim = 0.0;
        int nochange = 1;
        block15: while (nochange > 0 && compac < oldcompactness - eps && epoch <= this.epochmax) {
            nochange = 0;
            ++epoch;
            for (i = 0; i < this.nrow; ++i) {
                double bestnewcontrib = 1.0E12;
                int bestclus = 0;
                for (int c = 0; c < this.numClusters; ++c) {
                    dissim = 0.0;
                    for (int j5 = 0; j5 < this.ncol; ++j5) {
                        dissim += FastMath.pow((double)(this.indat[i][j5] - gpmeans[c][j5]), (double)2.0);
                    }
                    if (this.assignment[i] == c) {
                        prevcontrib = this.cardinality[c] / (this.cardinality[c] - 1.0) * dissim;
                        continue;
                    }
                    newcontrib = this.cardinality[c] / (this.cardinality[c] + 1.0) * dissim;
                    if (!(newcontrib < bestnewcontrib)) continue;
                    bestnewcontrib = newcontrib;
                    bestclus = c;
                }
                if (!(bestnewcontrib < 0.999 * prevcontrib)) continue;
                ++nochange;
                oldcompactness = compac;
                compac = compac + bestnewcontrib - prevcontrib;
                oldclus = this.assignment[i];
                for (int j6 = 0; j6 < this.ncol; ++j6) {
                    gpmeans[oldclus][j6] = 1.0 / (this.cardinality[oldclus] - 1.0) * (this.cardinality[oldclus] * gpmeans[oldclus][j6] - this.indat[i][j6]);
                    gpmeans[bestclus][j6] = 1.0 / (this.cardinality[bestclus] + 1.0) * (this.cardinality[bestclus] * gpmeans[bestclus][j6] + this.indat[i][j6]);
                }
                int n = oldclus;
                this.cardinality[n] = this.cardinality[n] - 1.0;
                if (this.cardinality[oldclus] <= 1.0) {
                    this.Ierr = 2;
                    continue block15;
                }
                int n3 = bestclus;
                this.cardinality[n3] = this.cardinality[n3] + 1.0;
                this.assignment[i] = bestclus;
            }
        }
        this.cMeans = new DataHolder();
        for (i = 0; i < this.numClusters; ++i) {
            double[] a = new double[this.ncol];
            for (int j7 = 0; j7 < this.ncol; ++j7) {
                this.clusterCenters[i][j7] = gpmeans[i][j7];
                a[j7] = gpmeans[i][j7];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            this.cMeans.add(c);
        }
        for (i = 0; i < this.nrow; ++i) {
            DataPoint dp = this.data.getRow(i);
            dp.assignToCluster(this.assignment[i]);
        }
        this.compactness = Get.compactness(this.indat, this.assignment, this.numClusters, this.clusterCenters);
    }

    public String getName() {
        return this.description;
    }
}

