/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexRenderer;
import org.jgraph.plaf.GraphUI;
import org.jgraph.plaf.basic.BasicGraphUI;

public class VertexView
extends AbstractCellView {
    public static transient VertexRenderer renderer;
    public static final Rectangle2D defaultBounds;
    protected Rectangle2D bounds;
    public static transient int[] defaultCursors;
    public static transient int[] xCursors;
    public static transient int[] yCursors;

    public VertexView() {
    }

    public VertexView(Object cell) {
        super(cell);
    }

    @Override
    public void update(GraphLayoutCache cache) {
        super.update(cache);
        this.bounds = GraphConstants.getBounds(this.allAttributes);
        if (this.bounds == null) {
            this.bounds = this.allAttributes.createRect(defaultBounds);
            GraphConstants.setBounds(this.allAttributes, this.bounds);
        }
        this.groupBounds = null;
    }

    public Rectangle2D getCachedBounds() {
        return this.bounds;
    }

    public void setCachedBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @Override
    public CellViewRenderer getRenderer() {
        return renderer;
    }

    @Override
    public CellHandle getHandle(GraphContext context) {
        if (GraphConstants.isSizeable(this.getAllAttributes()) && !GraphConstants.isAutoSize(this.getAllAttributes()) && context.getGraph().isSizeable()) {
            return new SizeHandle(this, context);
        }
        return null;
    }

    @Override
    public Rectangle2D getBounds() {
        Rectangle2D rect = super.getBounds();
        if (rect == null) {
            rect = this.bounds;
        }
        return rect;
    }

    public Point2D getCenterPoint() {
        return AbstractCellView.getCenterPoint(this);
    }

    public Point2D getPerimeterPoint(Point2D source, Point2D p) {
        return AbstractCellView.getCenterPoint(this);
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        if (this.getRenderer() instanceof VertexRenderer) {
            return ((VertexRenderer)this.getRenderer()).getPerimeterPoint(this, source, p);
        }
        return super.getPerimeterPoint(edge, source, p);
    }

    static {
        try {
            renderer = new VertexRenderer();
        }
        catch (Error error) {
            // empty catch block
        }
        defaultBounds = new Rectangle2D.Double(10.0, 10.0, 20.0, 20.0);
        defaultCursors = new int[]{6, 8, 7, 10, 11, 4, 9, 5};
        xCursors = new int[]{10, 0, 11, 10, 11, 10, 0, 11};
        yCursors = new int[]{8, 8, 8, 0, 0, 9, 9, 9};
    }

    public static class SizeHandle
    implements CellHandle,
    Serializable {
        protected transient Graphics offgraphics;
        protected transient boolean firstDrag = true;
        protected transient JGraph graph;
        protected transient VertexView vertex;
        protected transient CellView[] portViews;
        protected transient Rectangle2D cachedBounds;
        protected transient GraphContext context;
        protected transient Rectangle2D initialBounds;
        protected transient CellView[] contextViews;
        protected transient int index = -1;
        protected transient Rectangle2D[] r = new Rectangle2D[8];
        protected boolean firstOverlayInvocation = true;
        public transient int[] cursors = null;
        protected boolean editing = false;

        public SizeHandle(VertexView vertexview, GraphContext ctx) {
            this.graph = ctx.getGraph();
            this.vertex = vertexview;
            this.editing = this.graph.getEditingCell() == this.vertex.getCell();
            int sizeableAxis = GraphConstants.getSizeableAxis(this.vertex.getAllAttributes());
            this.cursors = sizeableAxis == 1 ? xCursors : (sizeableAxis == 2 ? yCursors : defaultCursors);
            this.portViews = ctx.createTemporaryPortViews();
            this.initialBounds = (Rectangle2D)this.vertex.getBounds().clone();
            this.context = ctx;
            for (int i = 0; i < this.r.length; ++i) {
                this.r[i] = new Rectangle2D.Double();
            }
            this.invalidate();
        }

        public boolean isConstrainedSizeEvent(MouseEvent e) {
            GraphUI ui = this.graph.getUI();
            if (ui instanceof BasicGraphUI) {
                return ((BasicGraphUI)ui).isConstrainedMoveEvent(e);
            }
            return false;
        }

        @Override
        public void paint(Graphics g) {
            this.invalidate();
            g.setColor(this.editing ? this.graph.getLockedHandleColor() : this.graph.getHandleColor());
            for (int i = 0; i < this.r.length; ++i) {
                if (this.cursors[i] == 0) continue;
                g.fill3DRect((int)this.r[i].getX(), (int)this.r[i].getY(), (int)this.r[i].getWidth(), (int)this.r[i].getHeight(), true);
            }
            if (!this.graph.isXorEnabled()) {
                this.firstOverlayInvocation = false;
                this.overlay(g);
            }
        }

        protected void initOffscreen() {
            if (!this.graph.isXorEnabled()) {
                return;
            }
            try {
                this.offgraphics = this.graph.getOffgraphics();
            }
            catch (Exception e) {
                this.offgraphics = null;
            }
            catch (Error e) {
                this.offgraphics = null;
            }
        }

        @Override
        public void overlay(Graphics g) {
            if (!this.firstOverlayInvocation) {
                if (this.cachedBounds != null) {
                    g.setColor(Color.black);
                    Rectangle2D tmp = this.graph.toScreen((Rectangle2D)this.cachedBounds.clone());
                    g.drawRect((int)tmp.getX(), (int)tmp.getY(), (int)tmp.getWidth() - 2, (int)tmp.getHeight() - 2);
                } else if (!this.initialBounds.equals(this.vertex.getBounds())) {
                    Graphics2D g2 = (Graphics2D)g;
                    AffineTransform oldTransform = g2.getTransform();
                    g2.scale(this.graph.getScale(), this.graph.getScale());
                    this.graph.getUI().paintCell(g, this.vertex, this.vertex.getBounds(), true);
                    if (this.contextViews != null) {
                        for (int i = 0; i < this.contextViews.length; ++i) {
                            this.graph.getUI().paintCell(g, this.contextViews[i], this.contextViews[i].getBounds(), true);
                        }
                    }
                    if (!this.graph.isPortsScaled()) {
                        g2.setTransform(oldTransform);
                    }
                    if (this.portViews != null && this.graph.isPortsVisible()) {
                        this.graph.getUI().paintPorts(g, this.portViews);
                    }
                    g2.setTransform(oldTransform);
                }
            }
            this.firstOverlayInvocation = false;
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (this.vertex != null) {
                for (int i = 0; i < this.r.length; ++i) {
                    if (!this.r[i].contains(event.getPoint())) continue;
                    this.graph.setCursor(new Cursor(this.cursors[i]));
                    event.consume();
                    return;
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (!this.graph.isSizeable()) {
                return;
            }
            for (int i = 0; i < this.r.length; ++i) {
                if (!this.r[i].contains(event.getPoint()) || this.cursors[i] == 0) continue;
                HashSet<Object> set = new HashSet<Object>();
                set.add(this.vertex.getCell());
                this.contextViews = this.context.createTemporaryContextViews(set);
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                if (all.length >= BasicGraphUI.MAXHANDLES) {
                    this.cachedBounds = (Rectangle2D)this.initialBounds.clone();
                }
                event.consume();
                this.index = i;
                return;
            }
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            Graphics g;
            if (this.firstDrag && this.graph.isDoubleBuffered() && this.cachedBounds == null) {
                this.initOffscreen();
                this.firstDrag = false;
            }
            Rectangle2D dirty = null;
            Graphics graphics = g = this.offgraphics != null ? this.offgraphics : this.graph.getGraphics();
            if (this.index == -1) {
                return;
            }
            if (this.offgraphics != null || !this.graph.isXorEnabled()) {
                dirty = this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone());
                Rectangle2D t = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
            }
            Rectangle2D newBounds = this.computeBounds(event);
            if (this.graph.isXorEnabled()) {
                g.setColor(this.graph.getForeground());
                g.setXORMode(this.graph.getBackground().darker());
                this.overlay(g);
            } else {
                this.firstOverlayInvocation = false;
            }
            if (this.cachedBounds != null) {
                this.cachedBounds = newBounds;
            } else {
                CellView[] all = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                for (int i = 0; i < all.length; ++i) {
                    CellView orig = this.graph.getGraphLayoutCache().getMapping(all[i].getCell(), false);
                    if (orig == null) continue;
                    AttributeMap origAttr = (AttributeMap)orig.getAllAttributes().clone();
                    all[i].changeAttributes(this.graph.getGraphLayoutCache(), origAttr);
                    all[i].refresh(this.graph.getGraphLayoutCache(), this.context, false);
                }
                this.vertex.setBounds(newBounds);
                if (this.vertex != null) {
                    this.graph.getGraphLayoutCache().update(this.vertex);
                }
                if (this.contextViews != null) {
                    this.graph.getGraphLayoutCache().update(this.contextViews);
                }
            }
            if (this.graph.isXorEnabled()) {
                this.overlay(g);
            }
            if (this.offgraphics != null || !this.graph.isXorEnabled()) {
                dirty.add(this.graph.toScreen((Rectangle2D)this.vertex.getBounds().clone()));
                Rectangle2D t = this.graph.toScreen(AbstractCellView.getBounds(this.contextViews));
                if (t != null) {
                    dirty.add(t);
                }
                int border = PortView.SIZE + 10;
                if (this.graph.isPortsScaled()) {
                    border = (int)(this.graph.getScale() * (double)border);
                }
                int border2 = border / 2;
                dirty.setFrame(dirty.getX() - (double)border2, dirty.getY() - (double)border2, dirty.getWidth() + (double)border, dirty.getHeight() + (double)border);
                double sx1 = Math.max(0.0, dirty.getX());
                double sy1 = Math.max(0.0, dirty.getY());
                double sx2 = sx1 + dirty.getWidth();
                double sy2 = sy1 + dirty.getHeight();
                if (this.offgraphics != null) {
                    this.graph.drawImage((int)sx1, (int)sy1, (int)sx2, (int)sy2, (int)sx1, (int)sy1, (int)sx2, (int)sy2);
                } else {
                    this.graph.repaint((int)dirty.getX(), (int)dirty.getY(), (int)dirty.getWidth(), (int)dirty.getHeight());
                }
            }
        }

        protected Rectangle2D computeBounds(MouseEvent event) {
            double left = this.initialBounds.getX();
            double right = this.initialBounds.getX() + this.initialBounds.getWidth() - 1.0;
            double top = this.initialBounds.getY();
            double bottom = this.initialBounds.getY() + this.initialBounds.getHeight() - 1.0;
            Point2D p = this.graph.fromScreen(this.graph.snap((Point2D)event.getPoint().clone()));
            p.setLocation(Math.max(0.0, p.getX()), Math.max(0.0, p.getY()));
            if (this.index > 4) {
                bottom = p.getY();
            } else if (this.index < 3) {
                top = p.getY();
            }
            if (this.index == 0 || this.index == 3 || this.index == 5) {
                left = p.getX();
            } else if (this.index == 2 || this.index == 4 || this.index == 7) {
                right = p.getX();
            }
            double width = right - left;
            double height = bottom - top;
            if (this.isConstrainedSizeEvent(event) || GraphConstants.isConstrained(this.vertex.getAllAttributes())) {
                if (this.index == 3 || this.index == 4 || this.index == 5) {
                    height = width;
                } else if (this.index == 1 || this.index == 6 || this.index == 2 || this.index == 7) {
                    width = height;
                } else {
                    height = width;
                    top = bottom - height;
                }
            }
            if (width < 0.0) {
                left += width;
                width = Math.abs(width);
            }
            if (height < 0.0) {
                top += height;
                height = Math.abs(height);
            }
            return new Rectangle2D.Double(left, top, width + 1.0, height + 1.0);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.index != -1) {
                this.cachedBounds = this.computeBounds(e);
                this.vertex.setBounds(this.cachedBounds);
                Object[] views = AbstractCellView.getDescendantViews(new CellView[]{this.vertex});
                Map attributes = GraphConstants.createAttributes(views, null);
                this.graph.getGraphLayoutCache().edit(attributes, null, null, null);
            }
            e.consume();
            this.cachedBounds = null;
            this.initialBounds = null;
            this.firstDrag = true;
        }

        protected void invalidate() {
            Rectangle2D tmp = this.graph.getCellBounds(this.vertex.getCell());
            if (tmp != null) {
                tmp = (Rectangle2D)tmp.clone();
                this.graph.toScreen(tmp);
                int handlesize = this.graph.getHandleSize();
                int s2 = 2 * handlesize;
                double left = tmp.getX() - (double)handlesize;
                double top = tmp.getY() - (double)handlesize;
                double w2 = tmp.getX() + tmp.getWidth() / 2.0 - (double)handlesize;
                double h2 = tmp.getY() + tmp.getHeight() / 2.0 - (double)handlesize;
                double right = tmp.getX() + tmp.getWidth() - (double)handlesize;
                double bottom = tmp.getY() + tmp.getHeight() - (double)handlesize;
                this.r[0].setFrame(left, top, s2, s2);
                this.r[1].setFrame(w2, top, s2, s2);
                this.r[2].setFrame(right, top, s2, s2);
                this.r[3].setFrame(left, h2, s2, s2);
                this.r[4].setFrame(right, h2, s2, s2);
                this.r[5].setFrame(left, bottom, s2, s2);
                this.r[6].setFrame(w2, bottom, s2, s2);
                this.r[7].setFrame(right, bottom, s2, s2);
            }
        }
    }
}

