/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.util.RectUtils;

public class GraphLayoutCache
implements CellMapper,
Serializable {
    protected boolean autoSizeOnValueChange = false;
    protected boolean showsExistingConnections = true;
    protected boolean showsChangedConnections = true;
    protected boolean showsInvisibleEditedCells = false;
    protected boolean showsInsertedCells = true;
    protected boolean showsInsertedConnections = true;
    protected boolean hidesExistingConnections = true;
    protected boolean hidesDanglingConnections = false;
    protected boolean remembersCellViews = true;
    protected boolean selectsAllInsertedCells = false;
    protected boolean selectsLocalInsertedCells = false;
    protected boolean movesChildrenOnExpand = true;
    protected boolean movesParentsOnCollapse = true;
    protected boolean resizesParentsOnCollapse = false;
    protected double collapseXScale = 1.0;
    protected double collapseYScale = 1.0;
    protected boolean reconnectsEdgesToVisibleParent = false;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected transient Map hiddenMapping = new WeakHashMap();
    protected CellViewFactory factory = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected boolean partial = false;
    protected boolean allAttributesLocal = false;
    protected Set localAttributes = new HashSet();

    public GraphLayoutCache() {
        this(new DefaultGraphModel(), new DefaultCellViewFactory());
    }

    public GraphLayoutCache(GraphModel model, CellViewFactory factory) {
        this(model, factory, false);
    }

    public GraphLayoutCache(GraphModel model, CellViewFactory factory, boolean partial) {
        this(model, factory, null, null, partial);
    }

    public GraphLayoutCache(GraphModel model, CellViewFactory factory, CellView[] cellViews, CellView[] hiddenCellViews, boolean partial) {
        int i;
        this.factory = factory;
        this.partial = partial;
        if (cellViews != null) {
            this.graphModel = model;
            for (i = 0; i < cellViews.length; ++i) {
                if (cellViews[i] == null) continue;
                this.putMapping(cellViews[i].getCell(), cellViews[i]);
                if (!partial) continue;
                this.visibleSet.add(cellViews[i].getCell());
            }
            this.insertViews(cellViews);
        } else {
            this.setModel(model);
        }
        if (hiddenCellViews != null) {
            for (i = 0; i < hiddenCellViews.length; ++i) {
                this.hiddenMapping.put(hiddenCellViews[i].getCell(), hiddenCellViews[i]);
            }
        }
    }

    public void addGraphLayoutCacheListener(GraphLayoutCacheListener l) {
        this.listenerList.add(GraphLayoutCacheListener.class, l);
    }

    public void removeGraphLayoutCacheListener(GraphLayoutCacheListener l) {
        this.listenerList.remove(GraphLayoutCacheListener.class, l);
    }

    public void cellViewsChanged(final CellView[] cellViews) {
        if (cellViews != null) {
            this.fireGraphLayoutCacheChanged(this, new GraphLayoutCacheEvent.GraphLayoutCacheChange(){

                @Override
                public Object[] getInserted() {
                    return null;
                }

                @Override
                public Object[] getRemoved() {
                    return null;
                }

                @Override
                public Map getPreviousAttributes() {
                    return null;
                }

                @Override
                public Object getSource() {
                    return this;
                }

                @Override
                public Object[] getChanged() {
                    return cellViews;
                }

                @Override
                public Map getAttributes() {
                    return null;
                }

                @Override
                public Object[] getContext() {
                    return null;
                }

                @Override
                public Rectangle2D getDirtyRegion() {
                    return null;
                }

                @Override
                public void setDirtyRegion(Rectangle2D dirty) {
                }
            });
        }
    }

    protected void fireGraphLayoutCacheChanged(Object source, GraphLayoutCacheEvent.GraphLayoutCacheChange edit) {
        Object[] listeners = this.listenerList.getListenerList();
        GraphLayoutCacheEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GraphLayoutCacheListener.class) continue;
            if (e == null) {
                e = new GraphLayoutCacheEvent(source, edit);
            }
            ((GraphLayoutCacheListener)listeners[i + 1]).graphLayoutCacheChanged(e);
        }
    }

    public GraphLayoutCacheListener[] getGraphLayoutCacheListeners() {
        return (GraphLayoutCacheListener[])this.listenerList.getListeners(GraphLayoutCacheListener.class);
    }

    public void setFactory(CellViewFactory factory) {
        this.factory = factory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel model) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenMapping.clear();
        this.visibleSet.clear();
        this.graphModel = model;
        if (!this.isPartial()) {
            Object[] cells = DefaultGraphModel.getRoots(this.getModel());
            CellView[] cellViews = this.getMapping(cells, true);
            this.insertViews(cellViews);
        }
        this.update();
    }

    public void update() {
        this.updatePorts();
        this.cellViewsChanged(this.getRoots());
    }

    public CellView[] getCellViews() {
        Collection coll = this.mapping.values();
        CellView[] result = new CellView[coll.size()];
        coll.toArray(result);
        return result;
    }

    public static Rectangle2D getBounds(CellView[] views) {
        if (views != null && views.length > 0) {
            Rectangle2D r = views[0] != null ? views[0].getBounds() : null;
            Rectangle2D ret = r != null ? (Rectangle2D)r.clone() : null;
            for (int i = 1; i < views.length; ++i) {
                Rectangle2D rectangle2D = r = views[i] != null ? views[i].getBounds() : null;
                if (r == null) continue;
                if (ret == null) {
                    ret = r != null ? (Rectangle2D)r.clone() : null;
                    continue;
                }
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public Object[] getCells(boolean groups, boolean vertices, boolean ports, boolean edges) {
        CellView[] views = this.getCellViews();
        ArrayList<Object> result = new ArrayList<Object>(views.length);
        GraphModel model = this.getModel();
        for (int i = 0; i < views.length; ++i) {
            Object cell = views[i].getCell();
            boolean isEdge = model.isEdge(cell);
            if (!ports && model.isPort(cell) || ((!ports && !vertices || isEdge) && (!edges || !isEdge) || !views[i].isLeaf()) && (!groups || views[i].isLeaf())) continue;
            result.add(views[i].getCell());
        }
        return result.toArray();
    }

    public Map createNestedMap() {
        CellView[] cellViews = this.getCellViews();
        Hashtable nested = new Hashtable();
        for (int i = 0; i < cellViews.length; ++i) {
            nested.put(cellViews[i].getCell(), new Hashtable((Map)cellViews[i].getAllAttributes().clone()));
        }
        return nested;
    }

    public CellView[] getHiddenCellViews() {
        Collection coll = this.hiddenMapping.values();
        CellView[] result = new CellView[coll.size()];
        coll.toArray(result);
        return result;
    }

    public synchronized void reload() {
        ArrayList<CellView> newRoots = new ArrayList<CellView>();
        Hashtable oldMapping = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator it = oldMapping.keySet().iterator();
        HashSet rootsSet = new HashSet(this.roots);
        while (it.hasNext()) {
            Object cell = it.next();
            CellView oldView = (CellView)oldMapping.get(cell);
            CellView newView = this.getMapping(cell, true);
            newView.changeAttributes(this, oldView.getAttributes());
            if (!rootsSet.contains(oldView)) continue;
            newRoots.add(newView);
        }
        this.hiddenMapping.clear();
        this.roots = newRoots;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] views = new CellView[this.roots.size()];
        this.roots.toArray(views);
        return views;
    }

    public CellView[] getRoots(Rectangle2D clip) {
        ArrayList<CellView> result = new ArrayList<CellView>();
        CellView[] views = this.getRoots();
        for (int i = 0; i < views.length; ++i) {
            if (!views[i].getBounds().intersects(clip)) continue;
            result.add(views[i]);
        }
        views = new CellView[result.size()];
        result.toArray(views);
        return views;
    }

    public Object[] getVisibleCells(Object[] cells) {
        if (cells != null) {
            ArrayList<Object> result = new ArrayList<Object>(cells.length);
            for (int i = 0; i < cells.length; ++i) {
                if (!this.isVisible(cells[i])) continue;
                result.add(cells[i]);
            }
            return result.toArray();
        }
        return null;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] roots = DefaultGraphModel.getRoots(this.graphModel);
        List list = DefaultGraphModel.getDescendants(this.graphModel, roots);
        if (list != null) {
            ArrayList<CellView> result = new ArrayList<CellView>();
            for (Object cell : list) {
                CellView portView;
                if (!this.graphModel.isPort(cell) || (portView = this.getMapping(cell, false)) == null) continue;
                result.add(portView);
                portView.refresh(this, this, false);
            }
            this.ports = new PortView[result.size()];
            result.toArray(this.ports);
        }
    }

    public void refresh(CellView[] views, boolean create) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                this.refresh(views[i], create);
            }
        }
    }

    public void refresh(CellView view, boolean create) {
        if (view != null) {
            view.refresh(this, this, create);
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                this.refresh(children[i], create);
            }
        }
    }

    public void update(CellView[] views) {
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                this.update(views[i]);
            }
        }
    }

    public void update(CellView view) {
        if (view != null) {
            view.update(this);
            CellView[] children = view.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                this.update(children[i]);
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange change) {
        CellView[] views = change.getViews(this);
        if (views != null) {
            for (int i = 0; i < views.length; ++i) {
                if (views[i] == null) continue;
                this.mapping.put(views[i].getCell(), views[i]);
            }
            this.setVisibleImpl(this.getCells(views), true);
        }
        Object[] changed = change.getChanged();
        this.getMapping(change.getInserted(), true);
        views = this.removeCells(change.getRemoved());
        change.putViews(this, views);
        if (this.isPartial()) {
            this.showCellsForChange(change);
            this.hideCellsForChange(change);
        }
        if (changed != null && changed.length > 0) {
            for (int i = 0; i < changed.length; ++i) {
                CellView view = this.getMapping(changed[i], false);
                if (view == null) continue;
                view.refresh(this, this, true);
                this.update(view);
            }
        }
        this.reloadRoots();
        this.refresh(this.getMapping(this.getContext(change), false), false);
        this.updatePorts();
    }

    protected void reloadRoots() {
        Object[] orderedCells = DefaultGraphModel.getAll(this.graphModel);
        ArrayList<CellView> newRoots = new ArrayList<CellView>();
        for (int i = 0; i < orderedCells.length; ++i) {
            CellView view = this.getMapping(orderedCells[i], false);
            if (view == null) continue;
            view.refresh(this, this, true);
            if (view.getParentView() != null) continue;
            newRoots.add(view);
        }
        this.roots = newRoots;
    }

    protected Object[] getContext(GraphModelEvent.GraphModelChange change) {
        return change.getContext();
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange change) {
        Object[] tmp = change.getRemoved();
        HashSet<Object> removed = new HashSet<Object>();
        if (tmp != null) {
            for (int i = 0; i < tmp.length; ++i) {
                removed.add(tmp[i]);
            }
        }
        if (this.hidesDanglingConnections || this.hidesExistingConnections) {
            Object[] changed = change.getChanged();
            for (int i = 0; i < changed.length; ++i) {
                boolean hideExisting;
                CellView view = this.getMapping(changed[i], false);
                if (!(view instanceof EdgeView)) continue;
                EdgeView edge = (EdgeView)view;
                Object oldSource = edge.getSource() == null ? null : edge.getSource().getCell();
                Object oldTarget = edge.getTarget() == null ? null : edge.getTarget().getCell();
                Object newSource = this.graphModel.getSource(changed[i]);
                Object newTarget = this.graphModel.getTarget(changed[i]);
                boolean bl = hideExisting = this.hidesExistingConnections && (newSource != null && !this.hasVisibleParent(newSource, null) || newTarget != null && !this.hasVisibleParent(newTarget, null));
                if ((!this.hidesDanglingConnections || !removed.contains(oldSource) && !removed.contains(oldTarget)) && !hideExisting) continue;
                this.setVisibleImpl(new Object[]{changed[i]}, false);
            }
        }
    }

    protected boolean hasVisibleParent(Object cell, Set invisible) {
        boolean isVisible = false;
        do {
            isVisible = invisible == null || !invisible.contains(cell) ? this.isVisible(cell) : false;
        } while ((cell = this.getModel().getParent(cell)) != null && !isVisible);
        return isVisible;
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange change) {
        Set changedSet;
        Object[] inserted = change.getInserted();
        if (inserted != null && this.showsInsertedConnections) {
            for (int i = 0; i < inserted.length; ++i) {
                if (this.isVisible(inserted[i])) continue;
                Object source = this.graphModel.getSource(inserted[i]);
                Object target = this.graphModel.getTarget(inserted[i]);
                if (source == null && target == null || !this.isVisible(source) || !this.isVisible(target)) continue;
                this.setVisibleImpl(new Object[]{inserted[i]}, true);
            }
        }
        if (change.getConnectionSet() != null && (changedSet = change.getConnectionSet().getChangedEdges()) != null && this.showsChangedConnections) {
            Object[] changed = changedSet.toArray();
            for (int i = 0; i < changed.length; ++i) {
                if (this.isVisible(changed[i])) continue;
                Object source = this.graphModel.getSource(changed[i]);
                Object target = this.graphModel.getTarget(changed[i]);
                if (source == null && target == null || !this.isVisible(source) || !this.isVisible(target) || this.isVisible(changed[i])) continue;
                this.setVisibleImpl(new Object[]{changed[i]}, true);
            }
        }
    }

    public void insertViews(CellView[] views) {
        if (views != null) {
            this.refresh(views, true);
            for (int i = 0; i < views.length; ++i) {
                Object parent;
                if (views[i] == null || this.getMapping(views[i].getCell(), false) == null) continue;
                CellView parentView = views[i].getParentView();
                Object object = parent = parentView != null ? parentView.getCell() : null;
                if (this.graphModel.isPort(views[i].getCell()) || parent != null) continue;
                this.roots.add(views[i]);
            }
        }
    }

    public CellView[] removeCells(Object[] cells) {
        if (cells != null && cells.length > 0) {
            CellView[] views = new CellView[cells.length];
            HashSet<CellView> removedRoots = null;
            for (int i = 0; i < cells.length; ++i) {
                views[i] = this.removeMapping(cells[i]);
                if (views[i] == null) continue;
                views[i].removeFromParent();
                if (removedRoots == null) {
                    removedRoots = new HashSet<CellView>();
                }
                removedRoots.add(views[i]);
                this.visibleSet.remove(views[i].getCell());
            }
            if (removedRoots != null && removedRoots.size() > 0) {
                int newRootsSize = this.roots.size() - removedRoots.size();
                if (newRootsSize < 8) {
                    newRootsSize = 8;
                }
                ArrayList newRoots = new ArrayList(newRootsSize);
                for (Object cell : this.roots) {
                    if (removedRoots.contains(cell)) continue;
                    newRoots.add(cell);
                }
                this.roots = newRoots;
            }
            return views;
        }
        return null;
    }

    public Object[] getCells(CellView[] views) {
        if (views != null) {
            Object[] cells = new Object[views.length];
            for (int i = 0; i < views.length; ++i) {
                if (views[i] == null) continue;
                cells[i] = views[i].getCell();
            }
            return cells;
        }
        return null;
    }

    @Override
    public CellView getMapping(Object cell, boolean create) {
        if (cell == null) {
            return null;
        }
        CellView view = (CellView)this.mapping.get(cell);
        if (view == null && create && this.isVisible(cell)) {
            view = (CellView)this.hiddenMapping.get(cell);
            if (view != null) {
                this.putMapping(cell, view);
                this.hiddenMapping.remove(cell);
            } else {
                view = this.factory.createView(this.graphModel, cell);
                this.putMapping(cell, view);
                view.refresh(this, this, true);
                view.update(this);
            }
        }
        return view;
    }

    public CellView[] getMapping(Object[] cells) {
        return this.getMapping(cells, false);
    }

    public CellView[] getMapping(Object[] cells, boolean create) {
        if (cells != null) {
            CellView[] result = new CellView[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                result[i] = this.getMapping(cells[i], create);
            }
            return result;
        }
        return null;
    }

    @Override
    public void putMapping(Object cell, CellView view) {
        if (cell != null && view != null) {
            this.mapping.put(cell, view);
        }
    }

    public CellView removeMapping(Object cell) {
        if (cell != null) {
            CellView view = (CellView)this.mapping.remove(cell);
            return view;
        }
        return null;
    }

    public boolean isVisible(Object cell) {
        return !this.isPartial() || this.visibleSet.contains(cell) || cell == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set visible) {
        this.visibleSet = visible;
    }

    public void setVisible(Object cell, boolean visible) {
        this.setVisible(new Object[]{cell}, visible);
    }

    public void setVisible(Object[] cells, boolean visible) {
        if (visible) {
            this.setVisible(cells, null);
        } else {
            this.setVisible(null, cells);
        }
    }

    public void setVisible(Object[] visible, Object[] invisible) {
        this.setVisible(visible, invisible, null);
    }

    public void setVisible(Object[] visible, Object[] invisible, ConnectionSet cs) {
        this.setVisible(visible, invisible, null, cs);
    }

    public void setVisible(Object[] visible, Object[] invisible, Map attributes, ConnectionSet cs) {
        GraphLayoutCacheEdit edit = new GraphLayoutCacheEdit(null, attributes, visible, invisible);
        edit.end();
        this.graphModel.edit(attributes, cs, null, new UndoableEdit[]{edit});
    }

    protected Object[] addVisibleDependencies(Object[] cells, boolean visible) {
        if (cells != null) {
            if (visible) {
                HashSet<Object> all = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    all.add(cells[i]);
                    all.addAll(this.getPorts(cells[i]));
                    Collection coll = this.getParentPorts(this.graphModel.getSource(cells[i]));
                    if (coll != null) {
                        all.addAll(coll);
                    }
                    if ((coll = this.getParentPorts(this.graphModel.getTarget(cells[i]))) == null) continue;
                    all.addAll(coll);
                }
                if (this.showsExistingConnections) {
                    Set tmp = DefaultGraphModel.getEdges(this.getModel(), cells);
                    for (Object obj : tmp) {
                        Object source = this.graphModel.getSource(obj);
                        Object target = this.graphModel.getTarget(obj);
                        if (!this.isVisible(source) && !all.contains(source) || !this.isVisible(target) && !all.contains(target)) continue;
                        all.add(obj);
                    }
                }
                all.removeAll(this.visibleSet);
                all.remove(null);
                return all.toArray();
            }
            if (this.hidesExistingConnections) {
                HashSet<Object> all = new HashSet<Object>();
                for (int i = 0; i < cells.length; ++i) {
                    all.addAll(this.getPorts(cells[i]));
                    all.add(cells[i]);
                }
                for (Object edge : DefaultGraphModel.getEdges(this.graphModel, cells)) {
                    Object newSource = this.graphModel.getSource(edge);
                    Object newTarget = this.graphModel.getTarget(edge);
                    if ((newSource == null || this.hasVisibleParent(newSource, all)) && (newTarget == null || this.hasVisibleParent(newTarget, all))) continue;
                    all.add(edge);
                }
                all.remove(null);
                return all.toArray();
            }
        }
        return cells;
    }

    public boolean setVisibleImpl(Object[] cells, boolean visible) {
        if ((cells = this.addVisibleDependencies(cells, visible)) != null && this.isPartial()) {
            boolean updatePorts = false;
            CellView[] views = new CellView[cells.length];
            if (!visible) {
                views = this.removeCells(cells);
            }
            HashSet modelRoots = null;
            for (int i = 0; i < cells.length; ++i) {
                if (cells[i] == null) continue;
                if (visible) {
                    this.visibleSet.add(cells[i]);
                    views[i] = this.getMapping(cells[i], true);
                    continue;
                }
                if (views[i] == null) continue;
                if (modelRoots == null) {
                    modelRoots = new HashSet(DefaultGraphModel.getRootsAsCollection(this.getModel()));
                }
                if (modelRoots.contains(views[i].getCell()) && this.remembersCellViews) {
                    this.hiddenMapping.put(views[i].getCell(), views[i]);
                }
                updatePorts = true;
            }
            if (visible) {
                HashSet<CellView> parentSet = new HashSet<CellView>();
                HashSet<CellView> removedRoots = null;
                for (int i = 0; i < views.length; ++i) {
                    if (views[i] == null) continue;
                    CellView view = views[i];
                    CellView[] children = AbstractCellView.getDescendantViews(new CellView[]{view});
                    for (int j = 0; j < children.length; ++j) {
                        if (removedRoots == null) {
                            removedRoots = new HashSet<CellView>();
                        }
                        removedRoots.add(children[j]);
                    }
                    view.refresh(this, this, false);
                    CellView parentView = view.getParentView();
                    if (parentView != null) {
                        parentSet.add(parentView);
                    }
                    updatePorts = true;
                }
                if (removedRoots != null && removedRoots.size() > 0) {
                    ArrayList newRoots = new ArrayList();
                    for (Object cell : this.roots) {
                        if (removedRoots.contains(cell)) continue;
                        newRoots.add(cell);
                    }
                    this.roots = newRoots;
                }
                CellView[] parentViews = new CellView[parentSet.size()];
                parentSet.toArray(parentViews);
                this.refresh(parentViews, true);
            }
            return updatePorts;
        }
        return false;
    }

    protected Collection getParentPorts(Object cell) {
        Object parent = this.graphModel.getParent(cell);
        while (parent != null) {
            if (this.isVisible(parent)) {
                return null;
            }
            parent = this.graphModel.getParent(parent);
        }
        parent = this.graphModel.getParent(cell);
        Collection collection = this.getPorts(parent);
        collection.add(parent);
        return collection;
    }

    protected Collection getPorts(Object cell) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (int i = 0; i < this.graphModel.getChildCount(cell); ++i) {
            Object child = this.graphModel.getChild(cell, i);
            if (!this.graphModel.isPort(child)) continue;
            list.add(child);
        }
        return list;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean getPartial() {
        return this.isPartial();
    }

    public void valueForCellChanged(Object cell, Object newValue) {
        Map nested = null;
        if (this.isAutoSizeOnValueChange()) {
            CellView view = this.getMapping(cell, false);
            if (view != null) {
                AttributeMap attrs = view.getAllAttributes();
                Rectangle2D bounds = GraphConstants.getBounds(attrs);
                Rectangle2D dummyBounds = null;
                dummyBounds = bounds != null ? attrs.createRect(bounds.getX(), bounds.getY(), 0.0, 0.0) : attrs.createRect(0.0, 0.0, 0.0, 0.0);
                nested = GraphConstants.createAttributes(new Object[]{cell}, new Object[]{"resize", "bounds"}, new Object[]{Boolean.TRUE, dummyBounds});
            }
        } else {
            nested = new Hashtable();
            nested.put(cell, new Hashtable());
        }
        this.augmentNestedMapForValueChange(nested, cell, newValue);
        this.edit(nested, null, null, null);
    }

    protected void augmentNestedMapForValueChange(Map nested, Object cell, Object newValue) {
        Map attrs = (Map)nested.get(cell);
        if (attrs != null) {
            GraphConstants.setValue(attrs, newValue);
        }
    }

    public void insert(Object[] roots, Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        GraphLayoutCacheEdit edit;
        Object[] visible = null;
        if (this.isPartial() && this.showsInsertedCells) {
            List tmp = DefaultGraphModel.getDescendants(this.graphModel, roots);
            tmp.removeAll(this.visibleSet);
            if (!tmp.isEmpty()) {
                visible = tmp.toArray();
            }
        }
        if ((edit = this.createLocalEdit(roots, attributes, visible, null)) != null) {
            e = this.augment(e, edit);
        }
        this.graphModel.insert(roots, attributes, cs, pm, e);
    }

    public Object[] insertClones(Object[] cells, Map clones, Map nested, ConnectionSet cs, ParentMap pm, double dx, double dy) {
        if (cells != null) {
            if (cs != null) {
                cs = cs.clone(clones);
            }
            if (pm != null) {
                pm = pm.clone(clones);
            }
            if (nested != null) {
                nested = GraphConstants.replaceKeys(clones, nested);
                AttributeMap.translate(nested.values(), dx, dy);
            }
            Object[] newCells = new Object[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                newCells[i] = clones.get(cells[i]);
            }
            this.insert(newCells, nested, cs, pm, null);
            return newCells;
        }
        return null;
    }

    public void insert(Object cell) {
        this.insert(new Object[]{cell});
    }

    public void insertEdge(Object edge, Object source, Object target) {
        this.insert(new Object[]{edge}, new Hashtable(), new ConnectionSet(edge, source, target), new ParentMap());
    }

    public void insert(Object[] cells) {
        this.insert(cells, new Hashtable(), new ConnectionSet(), new ParentMap());
    }

    public void insert(Object[] cells, Map nested, ConnectionSet cs, ParentMap pm) {
        if (cells != null) {
            if (nested == null) {
                nested = new Hashtable<Object, AttributeMap>();
            }
            if (cs == null) {
                cs = new ConnectionSet();
            }
            if (pm == null) {
                pm = new ParentMap();
            }
            for (int i = 0; i < cells.length; ++i) {
                Object targetPort;
                int childCount = this.getModel().getChildCount(cells[i]);
                for (int j = 0; j < childCount; ++j) {
                    Object child = this.getModel().getChild(cells[i], j);
                    pm.addEntry(child, cells[i]);
                    AttributeMap attrs = this.getModel().getAttributes(child);
                    if (attrs == null) continue;
                    nested.put(child, attrs);
                }
                Map attrsTmp = (Map)nested.get(cells[i]);
                AttributeMap attrs = this.getModel().getAttributes(cells[i]);
                if (attrsTmp != null) {
                    attrs.putAll(attrsTmp);
                }
                nested.put(cells[i], attrs);
                Object sourcePort = this.getModel().getSource(cells[i]);
                if (sourcePort != null) {
                    cs.connect(cells[i], sourcePort, true);
                }
                if ((targetPort = this.getModel().getTarget(cells[i])) == null) continue;
                cs.connect(cells[i], targetPort, false);
            }
            cells = DefaultGraphModel.getDescendants(this.getModel(), cells).toArray();
            this.insert(cells, nested, cs, pm, null);
        }
    }

    public void insertGroup(Object group, Object[] children) {
        if (group != null && children != null && children.length > 0) {
            Hashtable<Object, AttributeMap> nested = new Hashtable<Object, AttributeMap>();
            ArrayList<Object> newCells = new ArrayList<Object>(children.length + 1);
            if (!this.getModel().contains(group)) {
                newCells.add(group);
            }
            ParentMap pm = new ParentMap();
            for (int i = 0; i < children.length; ++i) {
                pm.addEntry(children[i], group);
                if (this.getModel().contains(children[i])) continue;
                newCells.add(children[i]);
                AttributeMap attrs = this.getModel().getAttributes(children[i]);
                if (attrs == null) continue;
                nested.put(children[i], attrs);
            }
            if (newCells.isEmpty()) {
                this.edit(nested, null, pm, null);
            } else {
                this.insert(newCells.toArray(), nested, null, pm);
            }
        }
    }

    public void remove(Object[] cells) {
        this.graphModel.remove(cells);
    }

    public void remove(Object[] cells, boolean descendants, boolean edges) {
        if (cells != null && cells.length > 0) {
            if (edges) {
                Object[] tmp = DefaultGraphModel.getEdges(this.getModel(), cells).toArray();
                Object[] newCells = new Object[cells.length + tmp.length];
                System.arraycopy(cells, 0, newCells, 0, cells.length);
                System.arraycopy(tmp, 0, newCells, cells.length, tmp.length);
                cells = newCells;
            }
            if (descendants) {
                cells = DefaultGraphModel.getDescendants(this.getModel(), cells).toArray();
            }
            this.remove(cells);
        }
    }

    public void hideCells(Object[] cells, boolean descandants) {
        if (cells != null && cells.length > 0) {
            if (descandants) {
                cells = DefaultGraphModel.getDescendants(this.getModel(), cells).toArray();
            }
            this.setVisible(cells, false);
        }
    }

    public void showCells(Object[] cells, boolean descandants) {
        if (cells != null && cells.length > 0) {
            if (descandants) {
                cells = DefaultGraphModel.getDescendants(this.getModel(), cells).toArray();
            }
            this.setVisible(cells, true);
        }
    }

    public Object[] ungroup(Object[] cells) {
        if (cells != null && cells.length > 0) {
            ArrayList<Object> toRemove = new ArrayList<Object>();
            ArrayList<Object> children = new ArrayList<Object>();
            boolean groupExists = false;
            for (int i = 0; i < cells.length; ++i) {
                boolean childExists = false;
                ArrayList<Object> tempPortList = new ArrayList<Object>();
                for (int j = 0; j < this.getModel().getChildCount(cells[i]); ++j) {
                    Object child = this.getModel().getChild(cells[i], j);
                    if (!this.getModel().isPort(child)) {
                        children.add(child);
                        childExists = true;
                        continue;
                    }
                    tempPortList.add(child);
                }
                if (!childExists) continue;
                toRemove.addAll(tempPortList);
                toRemove.add(cells[i]);
                groupExists = true;
            }
            if (groupExists) {
                this.remove(toRemove.toArray());
            }
            return children.toArray();
        }
        return null;
    }

    public void toggleCollapsedState(Object[] cells, boolean collapseOnly, boolean expandOnly) {
        ArrayList<Object> toExpand = new ArrayList<Object>();
        ArrayList<Object> toCollapse = new ArrayList<Object>();
        for (int i = 0; i < cells.length; ++i) {
            Object cell = cells[i];
            CellView view = this.getMapping(cell, false);
            if (view == null) continue;
            if (view.isLeaf() && !collapseOnly) {
                toExpand.add(view.getCell());
                continue;
            }
            if (view.isLeaf() || expandOnly) continue;
            toCollapse.add(view.getCell());
        }
        if (!toCollapse.isEmpty() || !toExpand.isEmpty()) {
            this.setCollapsedState(toCollapse.toArray(), toExpand.toArray());
        }
    }

    public void collapse(Object[] groups) {
        this.setCollapsedState(groups, null);
    }

    public void expand(Object[] cells) {
        this.setCollapsedState(null, cells);
    }

    public void setCollapsedState(Object[] collapse, Object[] expand) {
        ConnectionSet cs = new ConnectionSet();
        List toHide = DefaultGraphModel.getDescendants(this.getModel(), collapse);
        if (collapse != null) {
            int i;
            for (i = 0; i < collapse.length; ++i) {
                toHide.remove(collapse[i]);
                this.cellWillCollapse(collapse[i]);
            }
            for (i = 0; i < collapse.length; ++i) {
                int childCount = this.getModel().getChildCount(collapse[i]);
                if (childCount <= 0) continue;
                for (int j = 0; j < childCount; ++j) {
                    Object child = this.getModel().getChild(collapse[i], j);
                    if (!this.getModel().isPort(child)) continue;
                    toHide.remove(child);
                }
            }
        }
        HashSet<Object> toShow = new HashSet<Object>();
        if (expand != null) {
            for (int i = 0; i < expand.length; ++i) {
                int childCount = this.getModel().getChildCount(expand[i]);
                for (int j = 0; j < childCount; ++j) {
                    toShow.add(this.getModel().getChild(expand[i], j));
                }
            }
        }
        this.setVisible(toShow.toArray(), toHide != null ? toHide.toArray() : null, cs);
    }

    protected Object getParentPort(Object edge, boolean source) {
        int i;
        Object parent = this.getModel().getParent(source ? DefaultGraphModel.getSourceVertex(this.getModel(), edge) : DefaultGraphModel.getTargetVertex(this.getModel(), edge));
        int c = this.getModel().getChildCount(parent);
        int n = i = source ? c - 1 : 0;
        while (i < this.getModel().getChildCount(parent) && i >= 0) {
            Object child = this.getModel().getChild(parent, i);
            if (this.getModel().isPort(child)) {
                return child;
            }
            i += source ? -1 : 1;
        }
        return null;
    }

    protected Object getChildPort(Object edge, boolean source) {
        int i;
        GraphModel model = this.getModel();
        Object parent = source ? DefaultGraphModel.getSourceVertex(model, edge) : DefaultGraphModel.getTargetVertex(model, edge);
        int c = model.getChildCount(parent);
        int n = i = source ? c - 1 : 0;
        while (i < c && i >= 0) {
            Object child = model.getChild(parent, i);
            if (!model.isEdge(child) && !model.isPort(child)) {
                for (int j = 0; j < model.getChildCount(child); ++j) {
                    Object port = model.getChild(child, j);
                    if (!model.isPort(port)) continue;
                    return port;
                }
            }
            i += source ? -1 : 1;
        }
        return null;
    }

    public void edit(Map attributes, ConnectionSet cs, ParentMap pm, UndoableEdit[] e) {
        if (attributes != null || cs != null || pm != null || e != null) {
            GraphLayoutCacheEdit edit;
            Object[] visible = null;
            if (this.isPartial() && this.showsInvisibleEditedCells) {
                HashSet tmp = new HashSet();
                if (attributes != null) {
                    tmp.addAll(attributes.keySet());
                }
                if (cs != null) {
                    tmp.addAll(cs.getChangedEdges());
                }
                if (pm != null) {
                    tmp.addAll(pm.getChangedNodes());
                }
                tmp.removeAll(this.visibleSet);
                if (!tmp.isEmpty()) {
                    visible = tmp.toArray();
                }
            }
            if ((edit = this.createLocalEdit(null, attributes, visible, null)) != null) {
                e = this.augment(e, edit);
            }
            this.graphModel.edit(attributes, cs, pm, e);
        }
    }

    public void edit(Map attributes) {
        this.edit(attributes, null, null, null);
    }

    public void edit(Object[] cells, Map attributes) {
        if (attributes != null && cells != null && cells.length > 0) {
            Hashtable<Object, Map> nested = new Hashtable<Object, Map>();
            for (int i = 0; i < cells.length; ++i) {
                nested.put(cells[i], attributes);
            }
            this.edit(nested, null, null, null);
        }
    }

    public void editCell(Object cell, Map attributes) {
        if (attributes != null && cell != null) {
            this.edit(new Object[]{cell}, attributes);
        }
    }

    protected UndoableEdit[] augment(UndoableEdit[] e, UndoableEdit edit) {
        if (edit != null) {
            int size = e != null ? e.length + 1 : 1;
            UndoableEdit[] result = new UndoableEdit[size];
            if (e != null) {
                System.arraycopy(e, 0, result, 0, size - 2);
            }
            result[size - 1] = edit;
            return result;
        }
        return e;
    }

    public void toBack(Object[] cells) {
        if (cells != null && cells.length > 0) {
            this.graphModel.toBack(cells);
        }
    }

    public void toFront(Object[] cells) {
        if (cells != null && cells.length > 0) {
            this.graphModel.toFront(cells);
        }
    }

    protected GraphLayoutCacheEdit createLocalEdit(Object[] inserted, Map nested, Object[] visible, Object[] invisible) {
        if (!(nested == null || nested.isEmpty() || this.localAttributes.isEmpty() && !this.isAllAttributesLocal())) {
            Hashtable globalMap = new Hashtable();
            Hashtable localMap = new Hashtable();
            Iterator it = nested.entrySet().iterator();
            while (it.hasNext()) {
                Hashtable localAttr = new Hashtable();
                Map.Entry entry = it.next();
                Object cell = entry.getKey();
                Map attr = (Map)entry.getValue();
                CellView tmpView = this.getMapping(cell, false);
                if (tmpView != null) {
                    attr = tmpView.getAllAttributes().diff(attr);
                }
                Iterator it2 = attr.entrySet().iterator();
                while (it2.hasNext()) {
                    Map.Entry entry2 = it2.next();
                    Object key = entry2.getKey();
                    Object value = entry2.getValue();
                    boolean isControlAttribute = this.isControlAttribute(cell, key, value);
                    if (!this.isAllAttributesLocal() && !isControlAttribute && !this.isLocalAttribute(cell, key, value)) continue;
                    localAttr.put(key, value);
                    if (isControlAttribute) continue;
                    it2.remove();
                }
                if (!localAttr.isEmpty()) {
                    localMap.put(cell, localAttr);
                }
                if (attr.isEmpty()) continue;
                globalMap.put(cell, attr);
            }
            nested.clear();
            nested.putAll(globalMap);
            if (visible != null || invisible != null || !localMap.isEmpty()) {
                GraphLayoutCacheEdit edit = new GraphLayoutCacheEdit(inserted, new Hashtable(localMap), visible, invisible);
                edit.end();
                return edit;
            }
        } else if (visible != null || invisible != null) {
            GraphLayoutCacheEdit edit = new GraphLayoutCacheEdit(inserted, null, visible, invisible);
            edit.end();
            return edit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object cell, Object key, Object value) {
        return this.localAttributes.contains(key);
    }

    protected boolean isControlAttribute(Object cell, Object key, Object value) {
        return "removeAll".equals(key) || "removeAttributes".equals(key);
    }

    public boolean removeViewLocalAttribute(Object key, boolean addToModel, boolean override) {
        if (this.localAttributes.contains(key)) {
            if (addToModel) {
                this.copyRemovedViewValue(key, addToModel, override, this.mapping.values());
                this.copyRemovedViewValue(key, addToModel, override, this.hiddenMapping.values());
            }
            this.localAttributes.remove(key);
            return true;
        }
        return false;
    }

    private void copyRemovedViewValue(Object key, boolean addToModel, boolean override, Collection coll) {
        for (CellView cellView : coll) {
            Object cell;
            AttributeMap cellAttributes;
            AttributeMap attributes = cellView.getAttributes();
            if (!attributes.containsKey(key)) continue;
            if (addToModel && (cellAttributes = this.graphModel.getAttributes(cell = cellView.getCell())) != null) {
                boolean cellContainsKey = cellAttributes.containsKey(key);
                if (!override || !cellContainsKey) {
                    Object value = attributes.get(key);
                    cellAttributes.put(key, value);
                }
            }
            attributes.remove(key);
        }
    }

    protected void cellExpanded(Object cell) {
        CellView parent;
        CellView view;
        GraphModel model = this.getModel();
        if (this.movesChildrenOnExpand && !model.isPort(cell) && (view = this.getMapping(cell, false)) != null && (parent = this.getMapping(model.getParent(cell), false)) != null && DefaultGraphModel.isVertex(model, parent)) {
            Rectangle2D src = GraphConstants.getBounds(parent.getAllAttributes());
            Rectangle2D rect = parent.getBounds();
            if (rect != null && src != null) {
                double dx = src.getX() - rect.getX();
                double dy = src.getY() - rect.getY();
                AttributeMap attrs = view.getAttributes();
                if (!attrs.contains("bounds")) {
                    attrs = model.getAttributes(view.getCell());
                }
                attrs.translate(dx, dy);
            }
        }
    }

    protected void cellWillCollapse(Object cell) {
        CellView view;
        GraphModel model = this.getModel();
        if (this.movesParentsOnCollapse && (view = this.getMapping(cell, false)) != null && !view.isLeaf()) {
            AttributeMap attrs = view.getAttributes();
            if (!attrs.contains("bounds") && !this.localAttributes.contains("bounds")) {
                attrs = model.getAttributes(cell);
            }
            Rectangle2D src = GraphConstants.getBounds(attrs);
            Rectangle2D b = view.getBounds();
            if (this.resizesParentsOnCollapse || src == null || src.equals(VertexView.defaultBounds)) {
                src = attrs.createRect(b.getX(), b.getY(), b.getWidth() * this.collapseXScale, b.getHeight() * this.collapseYScale);
                attrs.applyValue("bounds", src);
            } else {
                src.setFrame(b.getX(), b.getY(), src.getWidth(), src.getHeight());
            }
        }
    }

    protected Map handleAttributes(Map attributes) {
        Hashtable<Object, AttributeMap> undo = new Hashtable<Object, AttributeMap>();
        CellView[] views = new CellView[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            CellView cv;
            Map.Entry entry = it.next();
            views[i] = cv = this.getMapping(entry.getKey(), false);
            ++i;
            if (cv == null || cv.getAttributes() == null) continue;
            Map deltaNew = (Map)entry.getValue();
            AttributeMap deltaOld = cv.getAttributes().applyMap(deltaNew);
            cv.refresh(this, this, false);
            undo.put(cv.getCell(), deltaOld);
        }
        this.update(views);
        return undo;
    }

    public static void translateViews(CellView[] views, double dx, double dy) {
        for (int i = 0; i < views.length; ++i) {
            if (!(views[i] instanceof AbstractCellView)) continue;
            ((AbstractCellView)views[i]).translate(dx, dy);
        }
    }

    public List getNeighbours(Object cell, Set exclude, boolean directed, boolean visibleCells) {
        GraphModel model = this.getModel();
        Object[] fanout = directed ? DefaultGraphModel.getOutgoingEdges(model, cell) : DefaultGraphModel.getEdges(model, new Object[]{cell}).toArray();
        ArrayList<Object> neighbours = new ArrayList<Object>(fanout.length);
        HashSet<Object> localExclude = new HashSet<Object>(fanout.length + 8, 0.75f);
        for (int i = 0; i < fanout.length; ++i) {
            Object neighbour;
            if (visibleCells && !this.isVisible(fanout[i]) || (neighbour = DefaultGraphModel.getOpposite(model, fanout[i], cell)) == null || exclude != null && exclude.contains(neighbour) || localExclude.contains(neighbour) || visibleCells && !this.isVisible(neighbour)) continue;
            localExclude.add(neighbour);
            neighbours.add(neighbour);
        }
        return neighbours;
    }

    public List getOutgoingEdges(Object cell, Set exclude, boolean visibleCells, boolean selfLoops) {
        return this.getEdges(cell, exclude, visibleCells, selfLoops, false);
    }

    public List getIncomingEdges(Object cell, Set exclude, boolean visibleCells, boolean selfLoops) {
        return this.getEdges(cell, exclude, visibleCells, selfLoops, true);
    }

    protected List getEdges(Object cell, Set exclude, boolean visibleCells, boolean selfLoops, boolean incoming) {
        GraphModel model = this.getModel();
        Object[] edges = DefaultGraphModel.getEdges(model, cell, incoming);
        ArrayList<Object> edgeList = new ArrayList<Object>(edges.length);
        HashSet<Object> localExclude = new HashSet<Object>(edges.length);
        for (int i = 0; i < edges.length; ++i) {
            if (exclude != null && exclude.contains(edges[i]) || localExclude.contains(edges[i]) || visibleCells && !this.isVisible(edges[i])) continue;
            if (selfLoops || model.getSource(edges[i]) != model.getTarget(edges[i])) {
                edgeList.add(edges[i]);
            }
            localExclude.add(edges[i]);
        }
        return edgeList;
    }

    public CellView[] getAllViews() {
        return this.getAllDescendants(this.getRoots());
    }

    public CellView[] getAllDescendants(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            if (views[i] == null) continue;
            stack.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            int i;
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            for (i = 0; i < children.length; ++i) {
                stack.add(children[i]);
            }
            result.add(tmp);
            for (i = 0; i < this.graphModel.getChildCount(tmp.getCell()); ++i) {
                CellView view;
                Object child = this.graphModel.getChild(tmp.getCell(), i);
                if (!this.graphModel.isPort(child) || (view = this.getMapping(child, false)) == null) continue;
                stack.add(view);
            }
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    public Map getHiddenMapping() {
        return this.hiddenMapping;
    }

    public void setShowsExistingConnections(boolean showsExistingConnections) {
        this.showsExistingConnections = showsExistingConnections;
    }

    public boolean isShowsExistingConnections() {
        return this.showsExistingConnections;
    }

    public void setShowsInsertedConnections(boolean showsInsertedConnections) {
        this.showsInsertedConnections = showsInsertedConnections;
    }

    public boolean isShowsInsertedConnections() {
        return this.showsInsertedConnections;
    }

    public void setHidesExistingConnections(boolean hidesExistingConnections) {
        this.hidesExistingConnections = hidesExistingConnections;
    }

    public boolean isHidesExistingConnections() {
        return this.hidesExistingConnections;
    }

    public void setHidesDanglingConnections(boolean hidesDanglingConnections) {
        this.hidesDanglingConnections = hidesDanglingConnections;
    }

    public boolean isHidesDanglingConnections() {
        return this.hidesDanglingConnections;
    }

    public void setRemembersCellViews(boolean rememberCellViews) {
        this.remembersCellViews = rememberCellViews;
    }

    public boolean isRemembersCellViews() {
        return this.remembersCellViews;
    }

    public void setHiddenSet(Map hiddenSet) {
        this.hiddenMapping = hiddenSet;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set localAttributes) {
        this.localAttributes = localAttributes;
    }

    public boolean isAllAttributesLocal() {
        return this.allAttributesLocal;
    }

    public void setAllAttributesLocal(boolean allAttributesLocal) {
        this.allAttributesLocal = allAttributesLocal;
    }

    public boolean isAutoSizeOnValueChange() {
        return this.autoSizeOnValueChange;
    }

    public void setAutoSizeOnValueChange(boolean flag) {
        this.autoSizeOnValueChange = flag;
    }

    public boolean isSelectsAllInsertedCells() {
        return this.selectsAllInsertedCells;
    }

    public void setSelectsAllInsertedCells(boolean selectsAllInsertedCells) {
        this.selectsAllInsertedCells = selectsAllInsertedCells;
    }

    public boolean isSelectsLocalInsertedCells() {
        return this.selectsLocalInsertedCells;
    }

    public void setSelectsLocalInsertedCells(boolean selectsLocalInsertedCells) {
        this.selectsLocalInsertedCells = selectsLocalInsertedCells;
    }

    public boolean isReconnectsEdgesToVisibleParent() {
        return this.reconnectsEdgesToVisibleParent;
    }

    public void setReconnectsEdgesToVisibleParent(boolean reconnectsEdgesToVisibleParent) {
        this.reconnectsEdgesToVisibleParent = reconnectsEdgesToVisibleParent;
    }

    public boolean isShowsChangedConnections() {
        return this.showsChangedConnections;
    }

    public void setShowsChangedConnections(boolean showsChangedConnections) {
        this.showsChangedConnections = showsChangedConnections;
    }

    public boolean isMovesChildrenOnExpand() {
        return this.movesChildrenOnExpand;
    }

    public void setMovesChildrenOnExpand(boolean moveChildrenOnExpand) {
        this.movesChildrenOnExpand = moveChildrenOnExpand;
    }

    public boolean isShowsInvisibleEditedCells() {
        return this.showsInvisibleEditedCells;
    }

    public void setShowsInvisibleEditedCells(boolean showsInvisibleEditedCells) {
        this.showsInvisibleEditedCells = showsInvisibleEditedCells;
    }

    public double getCollapseXScale() {
        return this.collapseXScale;
    }

    public void setCollapseXScale(double collapseXScale) {
        this.collapseXScale = collapseXScale;
    }

    public double getCollapseYScale() {
        return this.collapseYScale;
    }

    public void setCollapseYScale(double collapseYScale) {
        this.collapseYScale = collapseYScale;
    }

    public boolean isMovesParentsOnCollapse() {
        return this.movesParentsOnCollapse;
    }

    public void setMovesParentsOnCollapse(boolean movesParentsOnCollapse) {
        this.movesParentsOnCollapse = movesParentsOnCollapse;
    }

    public boolean isResizesParentsOnCollapse() {
        return this.resizesParentsOnCollapse;
    }

    public void setResizesParentsOnCollapse(boolean resizesParentsOnCollapse) {
        this.resizesParentsOnCollapse = resizesParentsOnCollapse;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable map = new Hashtable(this.hiddenMapping);
        s.writeObject(map);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Map map = (Map)s.readObject();
        this.hiddenMapping = new WeakHashMap(map);
    }

    public class GraphLayoutCacheEdit
    extends CompoundEdit
    implements GraphLayoutCacheEvent.GraphLayoutCacheChange {
        protected Object[] cells;
        protected Object[] previousCells = null;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Map previousAttributes;
        protected Object[] visible;
        protected Object[] invisible;
        protected Rectangle2D dirtyRegion = null;
        protected Set changedCells = new HashSet();

        public GraphLayoutCacheEdit(Map nested) {
            this(null, nested, null, null);
            this.attributes = nested;
        }

        public GraphLayoutCacheEdit(Object[] inserted, Map attributes, Object[] visible, Object[] invisible) {
            this.attributes = attributes;
            this.previousAttributes = attributes;
            this.cells = inserted;
            this.visible = visible;
            this.invisible = invisible;
        }

        @Override
        public Object getSource() {
            return GraphLayoutCache.this;
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public Object[] getChanged() {
            return this.changedCells.toArray();
        }

        @Override
        public Object[] getInserted() {
            return this.invisible;
        }

        @Override
        public Object[] getRemoved() {
            return this.visible;
        }

        @Override
        public Object[] getContext() {
            return this.context;
        }

        @Override
        public Map getAttributes() {
            return this.attributes;
        }

        @Override
        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        @Override
        public Rectangle2D getDirtyRegion() {
            return this.dirtyRegion;
        }

        @Override
        public void setDirtyRegion(Rectangle2D dirty) {
            this.dirtyRegion = dirty;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            GraphModel model = GraphLayoutCache.this.getModel();
            this.changedCells.clear();
            if (this.hidden != null) {
                for (int i = 0; i < this.hidden.length; ++i) {
                    if (this.hidden[i] == null) continue;
                    GraphLayoutCache.this.mapping.put(this.hidden[i].getCell(), this.hidden[i]);
                }
            }
            if (this.invisible != null && this.invisible.length > 0) {
                CellView[] invisibleViews = new CellView[this.invisible.length];
                invisibleViews = GraphLayoutCache.this.getMapping(this.invisible, true);
                Rectangle2D changedBounds = GraphLayoutCache.getBounds(invisibleViews);
                this.dirtyRegion = RectUtils.union(this.dirtyRegion, changedBounds);
            }
            if (!GraphLayoutCache.this.remembersCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            boolean updatePorts = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            if (this.visible != null) {
                for (int i = 0; i < this.visible.length; ++i) {
                    this.changedCells.add(this.visible[i]);
                    if (this.cells != null) continue;
                    GraphLayoutCache.this.cellExpanded(this.visible[i]);
                }
            }
            if (this.invisible != null) {
                for (int i = 0; i < this.invisible.length; ++i) {
                    this.changedCells.add(this.invisible[i]);
                }
            }
            Object[] tmp = this.visible;
            this.visible = this.invisible;
            this.invisible = tmp;
            if (this.attributes != null) {
                this.previousAttributes = this.attributes;
                this.changedCells.addAll(this.attributes.keySet());
            }
            if (updatePorts) {
                GraphLayoutCache.this.updatePorts();
            }
            HashSet<Object> parentSet = new HashSet<Object>();
            Iterator it = this.changedCells.iterator();
            while (it.hasNext()) {
                Object parent = model.getParent(it.next());
                while (parent != null) {
                    parentSet.add(parent);
                    parent = model.getParent(parent);
                }
            }
            this.changedCells.addAll(parentSet);
            Set ctx = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.changedCells.toArray());
            this.context = GraphLayoutCache.this.getMapping(ctx.toArray());
            HashSet allChangedCells = new HashSet(this.changedCells);
            allChangedCells.addAll(ctx);
            CellView[] allChangedCellViews = GraphLayoutCache.this.getMapping(allChangedCells.toArray());
            Rectangle2D changedBounds = GraphLayoutCache.getBounds(allChangedCellViews);
            this.dirtyRegion = RectUtils.union(this.dirtyRegion, changedBounds);
            if (this.attributes != null) {
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
            }
            GraphLayoutCache.this.refresh(GraphLayoutCache.this.getMapping(this.changedCells.toArray(), false), false);
            GraphLayoutCache.this.refresh(this.context, false);
            tmp = this.cells;
            this.cells = this.previousCells;
            this.previousCells = tmp;
            GraphLayoutCache.this.reloadRoots();
            GraphLayoutCache.this.fireGraphLayoutCacheChanged(GraphLayoutCache.this, this);
        }
    }
}

