/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellHandle;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.DefaultGraphCellEditor;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphCellEditor;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphContext;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.VertexView;

public abstract class AbstractCellView
implements CellView,
Serializable {
    public static transient GraphCellEditor cellEditor;
    protected Object cell = null;
    protected CellView parent = null;
    protected List childViews = new ArrayList(0);
    protected AttributeMap allAttributes;
    protected AttributeMap attributes = this.allAttributes = this.createAttributeMap();
    protected transient Rectangle2D groupBounds = VertexView.defaultBounds;

    public AbstractCellView() {
    }

    public AbstractCellView(Object cell) {
        this.setCell(cell);
    }

    protected AttributeMap createAttributeMap() {
        return new AttributeMap();
    }

    @Override
    public Object getCell() {
        return this.cell;
    }

    public void setCell(Object cell) {
        this.cell = cell;
    }

    @Override
    public void refresh(GraphLayoutCache cache, CellMapper mapper, boolean createDependentViews) {
        GraphModel model = cache.getModel();
        this.allAttributes = this.getCellAttributes(model);
        if (mapper != null && model != null) {
            Object par = model.getParent(this.cell);
            CellView tmp = mapper.getMapping(par, createDependentViews);
            if (tmp != this.parent) {
                this.removeFromParent();
            }
            this.parent = tmp;
        }
        this.update(cache);
        this.childViews.clear();
        for (int i = 0; i < model.getChildCount(this.cell); ++i) {
            Object child = model.getChild(this.cell, i);
            CellView view = mapper.getMapping(child, createDependentViews);
            if (model.isPort(child) || view == null) continue;
            this.childViews.add(view);
        }
    }

    protected AttributeMap getCellAttributes(GraphModel model) {
        return (AttributeMap)model.getAttributes(this.cell).clone();
    }

    @Override
    public void update(GraphLayoutCache cache) {
        this.mergeAttributes();
        this.groupBounds = null;
        this.childUpdated();
    }

    protected void mergeAttributes() {
        this.allAttributes.putAll(this.attributes);
    }

    @Override
    public void childUpdated() {
        if (this.parent != null) {
            this.parent.childUpdated();
        }
        this.groupBounds = null;
    }

    @Override
    public CellView getParentView() {
        return this.parent;
    }

    @Override
    public CellView[] getChildViews() {
        CellView[] array = new CellView[this.childViews.size()];
        this.childViews.toArray(array);
        return array;
    }

    public static CellView[] getDescendantViews(CellView[] views) {
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < views.length; ++i) {
            stack.add(views[i]);
        }
        ArrayList<CellView> result = new ArrayList<CellView>();
        while (!stack.isEmpty()) {
            CellView tmp = (CellView)stack.pop();
            CellView[] children = tmp.getChildViews();
            for (int i = 0; i < children.length; ++i) {
                stack.add(children[i]);
            }
            result.add(tmp);
        }
        CellView[] ret = new CellView[result.size()];
        result.toArray(ret);
        return ret;
    }

    @Override
    public void removeFromParent() {
        if (this.parent instanceof AbstractCellView) {
            List list = ((AbstractCellView)this.parent).childViews;
            list.remove(this);
        }
    }

    @Override
    public boolean isLeaf() {
        return this.childViews.isEmpty();
    }

    @Override
    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public void setAttributes(AttributeMap attributes) {
        this.attributes = attributes;
    }

    @Override
    public AttributeMap getAllAttributes() {
        return this.allAttributes;
    }

    @Override
    public Map changeAttributes(GraphLayoutCache cache, Map change) {
        if (change != null) {
            AttributeMap undo = this.attributes.applyMap(change);
            this.update(cache);
            return undo;
        }
        return null;
    }

    @Override
    public Rectangle2D getBounds() {
        if (!this.isLeaf()) {
            if (this.groupBounds == null) {
                this.updateGroupBounds();
            }
            return this.groupBounds;
        }
        return null;
    }

    public static Rectangle2D getBounds(CellView[] views) {
        if (views != null && views.length > 0) {
            Rectangle2D.Double ret = null;
            for (int i = 0; i < views.length; ++i) {
                Rectangle2D r;
                if (views[i] == null || (r = views[i].getBounds()) == null) continue;
                if (ret == null) {
                    ret = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
                    continue;
                }
                Rectangle2D.union(ret, r, ret);
            }
            return ret;
        }
        return null;
    }

    public void setBounds(Rectangle2D bounds) {
        Rectangle2D oldBounds = this.getBounds();
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        Point2D.Double p0 = new Point2D.Double(oldBounds.getX(), oldBounds.getY());
        Point2D.Double pe = new Point2D.Double(bounds.getX(), bounds.getY());
        Rectangle2D.Double localBounds = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        if (GraphConstants.isMoveable(this.getAllAttributes()) && !pe.equals(p0)) {
            this.translate(((Point2D)pe).getX() - ((Point2D)p0).getX(), ((Point2D)pe).getY() - ((Point2D)p0).getY());
        } else {
            localBounds.setFrame(((RectangularShape)localBounds).getX(), ((RectangularShape)localBounds).getY(), bounds.getWidth() - ((Point2D)pe).getX() + ((Point2D)p0).getX(), bounds.getHeight() - ((Point2D)pe).getY() + ((Point2D)p0).getY());
        }
        double lbw = ((RectangularShape)localBounds).getWidth();
        double lbh = ((RectangularShape)localBounds).getHeight();
        double obw = oldBounds.getWidth();
        double obh = oldBounds.getHeight();
        if ((lbw != obw || lbh != obh) && obw > 0.0 && obh > 0.0) {
            this.scale(lbw / obw, lbh / obh, pe);
        }
    }

    protected void updateGroupBounds() {
        CellView[] childViews = this.getChildViews();
        LinkedList<CellView> result = new LinkedList<CellView>();
        for (int i = 0; i < childViews.length; ++i) {
            if (!this.includeInGroupBounds(childViews[i])) continue;
            result.add(childViews[i]);
        }
        childViews = new CellView[result.size()];
        result.toArray(childViews);
        Rectangle2D r = AbstractCellView.getBounds(childViews);
        int groupBorder = GraphConstants.getInset(this.getAllAttributes());
        if (r != null) {
            r.setFrame(r.getX() - (double)groupBorder, r.getY() - (double)groupBorder, r.getWidth() + (double)(2 * groupBorder), r.getHeight() + (double)(2 * groupBorder));
        }
        this.groupBounds = r;
    }

    protected boolean includeInGroupBounds(CellView view) {
        EdgeView edgeView;
        if (view instanceof EdgeView && this.getCell() instanceof DefaultMutableTreeNode && (edgeView = (EdgeView)view).getCell() instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode target;
            DefaultMutableTreeNode source;
            DefaultMutableTreeNode edge = (DefaultMutableTreeNode)edgeView.getCell();
            Object src = null;
            if (edgeView.getSource() != null && edgeView.getSource().getParentView() != null) {
                src = edgeView.getSource().getParentView().getCell();
            } else if (edgeView.getSourceParentView() != null) {
                src = edgeView.getSourceParentView().getCell();
            }
            if (src instanceof DefaultMutableTreeNode && (source = (DefaultMutableTreeNode)src).isNodeDescendant(edge)) {
                return false;
            }
            Object tgt = null;
            if (edgeView.getTarget() != null && edgeView.getTarget().getParentView() != null) {
                tgt = edgeView.getTarget().getParentView().getCell();
            } else if (edgeView.getTargetParentView() != null) {
                tgt = edgeView.getTargetParentView().getCell();
            }
            if (tgt instanceof DefaultMutableTreeNode && (target = (DefaultMutableTreeNode)tgt).isNodeDescendant(edge)) {
                return false;
            }
        }
        return true;
    }

    public void translate(double dx, double dy) {
        if (this.isLeaf()) {
            this.getAllAttributes().translate(dx, dy);
        } else {
            int moveableAxis = GraphConstants.getMoveableAxis(this.getAllAttributes());
            if (moveableAxis == 1) {
                dy = 0.0;
            } else if (moveableAxis == 2) {
                dx = 0.0;
            }
            for (Object view : this.childViews) {
                if (!(view instanceof AbstractCellView)) continue;
                AbstractCellView child = (AbstractCellView)view;
                child.translate(dx, dy);
            }
        }
    }

    public void scale(double sx, double sy, Point2D origin) {
        if (this.isLeaf()) {
            this.getAttributes().scale(sx, sy, origin);
        } else {
            int sizeableAxis = GraphConstants.getSizeableAxis(this.getAllAttributes());
            if (sizeableAxis == 1) {
                sy = 1.0;
            } else if (sizeableAxis == 2) {
                sx = 1.0;
            }
            for (Object view : this.childViews) {
                AbstractCellView child;
                AttributeMap attrs;
                if (!(view instanceof AbstractCellView) || !GraphConstants.isSizeable(attrs = (child = (AbstractCellView)view).getAttributes()) && !GraphConstants.isAutoSize(attrs)) continue;
                child.scale(sx, sy, origin);
            }
        }
    }

    @Override
    public boolean intersects(JGraph graph, Rectangle2D rect) {
        if (this.isLeaf() || GraphConstants.isGroupOpaque(this.getAllAttributes())) {
            Rectangle2D bounds = this.getBounds();
            if (bounds != null) {
                return bounds.intersects(rect);
            }
        } else {
            Iterator it = this.childViews.iterator();
            while (it.hasNext()) {
                if (!((CellView)it.next()).intersects(graph, rect)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Component getRendererComponent(JGraph graph, boolean selected, boolean focus, boolean preview) {
        CellViewRenderer cvr = this.getRenderer();
        if (cvr != null) {
            return cvr.getRendererComponent(graph, this, selected, focus, preview);
        }
        return null;
    }

    public abstract CellViewRenderer getRenderer();

    @Override
    public abstract CellHandle getHandle(GraphContext var1);

    @Override
    public GraphCellEditor getEditor() {
        return cellEditor;
    }

    public static Point2D getCenterPoint(CellView vertex) {
        Rectangle2D r = vertex.getBounds();
        if (r != null) {
            return new Point2D.Double(r.getCenterX(), r.getCenterY());
        }
        return null;
    }

    @Override
    public Point2D getPerimeterPoint(EdgeView edge, Point2D source, Point2D p) {
        return AbstractCellView.getCenterPoint(this);
    }

    static {
        try {
            cellEditor = new DefaultGraphCellEditor();
        }
        catch (Error error) {
            // empty catch block
        }
    }
}

