/*
 * Decompiled with CFR 0.152.
 */
package tig.maths;

import tig.GeneralConstants;

public class Matrix3
implements GeneralConstants {
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3(double x00, double x01, double x02, double x10, double x11, double x12, double x20, double x21, double x22) {
        this.m00 = x00;
        this.m01 = x01;
        this.m02 = x02;
        this.m10 = x10;
        this.m11 = x11;
        this.m12 = x12;
        this.m20 = x20;
        this.m21 = x21;
        this.m22 = x22;
    }

    public String toString() {
        return this.m00 + "\t" + this.m01 + "\t" + this.m02 + LS + this.m10 + "\t" + this.m11 + "\t" + this.m12 + LS + this.m20 + "\t" + this.m21 + "\t" + this.m22 + LS;
    }

    public static Matrix3 getIdentityMatrix() {
        return new Matrix3(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 getRotX(double alpha) {
        double c = Math.cos(alpha);
        double s = Math.sin(alpha);
        return new Matrix3(1.0, 0.0, 0.0, 0.0, c, s, 0.0, -s, c);
    }

    public static Matrix3 getRotY(double alpha) {
        double c = Math.cos(alpha);
        double s = Math.sin(alpha);
        return new Matrix3(c, 0.0, -s, 0.0, 1.0, 0.0, s, 0.0, c);
    }

    public static Matrix3 getRotZ(double alpha) {
        double c = Math.cos(alpha);
        double s = Math.sin(alpha);
        return new Matrix3(c, s, 0.0, -s, c, 0.0, 0.0, 0.0, 1.0);
    }

    public static Matrix3 mul(Matrix3 M1, Matrix3 M2) {
        return new Matrix3(M1.m00 * M2.m00 + M1.m01 * M2.m10 + M1.m02 * M2.m20, M1.m00 * M2.m01 + M1.m01 * M2.m11 + M1.m02 * M2.m21, M1.m00 * M2.m02 + M1.m01 * M2.m12 + M1.m02 * M2.m22, M1.m10 * M2.m00 + M1.m11 * M2.m10 + M1.m12 * M2.m20, M1.m10 * M2.m01 + M1.m11 * M2.m11 + M1.m12 * M2.m21, M1.m10 * M2.m02 + M1.m11 * M2.m12 + M1.m12 * M2.m22, M1.m20 * M2.m00 + M1.m21 * M2.m10 + M1.m22 * M2.m20, M1.m20 * M2.m01 + M1.m21 * M2.m11 + M1.m22 * M2.m21, M1.m20 * M2.m02 + M1.m21 * M2.m12 + M1.m22 * M2.m22);
    }

    public static double det(Matrix3 M) {
        return M.m00 * (M.m11 * M.m22 - M.m21 * M.m12) - M.m10 * (M.m01 * M.m22 - M.m21 * M.m02) + M.m20 * (M.m01 * M.m12 - M.m11 * M.m02);
    }

    public static Matrix3 invert(Matrix3 M) {
        double del = Matrix3.det(M);
        return new Matrix3(M.minor(0, 0) / del, -M.minor(1, 0) / del, M.minor(2, 0) / del, -M.minor(0, 1) / del, M.minor(1, 1) / del, -M.minor(2, 1) / del, M.minor(0, 2) / del, -M.minor(1, 2) / del, M.minor(2, 2) / del);
    }

    private double minor(int row, int col) {
        switch (row) {
            case 0: {
                switch (col) {
                    case 0: {
                        return this.m11 * this.m22 - this.m21 * this.m12;
                    }
                    case 1: {
                        return this.m10 * this.m22 - this.m20 * this.m12;
                    }
                    case 2: {
                        return this.m10 * this.m21 - this.m20 * this.m11;
                    }
                }
                throw new IllegalArgumentException("'col' must be between 0 and 2");
            }
            case 1: {
                switch (col) {
                    case 0: {
                        return this.m01 * this.m22 - this.m21 * this.m02;
                    }
                    case 1: {
                        return this.m00 * this.m22 - this.m20 * this.m02;
                    }
                    case 2: {
                        return this.m00 * this.m21 - this.m20 * this.m01;
                    }
                }
                throw new IllegalArgumentException("'col' must be between 0 and 2");
            }
            case 2: {
                switch (col) {
                    case 0: {
                        return this.m01 * this.m12 - this.m11 * this.m02;
                    }
                    case 1: {
                        return this.m00 * this.m12 - this.m10 * this.m02;
                    }
                    case 2: {
                        return this.m00 * this.m11 - this.m10 * this.m01;
                    }
                }
                throw new IllegalArgumentException("'col' must be between 0 and 2");
            }
        }
        throw new IllegalArgumentException("'row' must be between 0 and 2");
    }

    public static void main(String[] args) {
        if (args[0].equalsIgnoreCase("testInvert")) {
            Matrix3.testInvert();
        } else {
            String possibleArgs = "'testInvert'";
            System.out.println("first argument must be " + possibleArgs);
        }
    }

    private static void testInvert() {
        Matrix3 M = new Matrix3(2.0, -1.0, 22.0, -1.0, 3.0, -34.0, 4.0, 3.0, 1.0);
        System.out.println("Matrix : " + LS + M.toString());
        Matrix3 tmp = new Matrix3(M.minor(0, 0), M.minor(0, 1), M.minor(0, 2), M.minor(1, 0), M.minor(1, 1), M.minor(1, 2), M.minor(2, 0), M.minor(2, 1), M.minor(2, 2));
        System.out.println("minors : " + LS + tmp.toString());
        double det = Matrix3.det(M);
        System.out.println("det : " + det);
        if (det == 0.0) {
            return;
        }
        Matrix3 inv = Matrix3.invert(M);
        System.out.println("invert : " + LS + inv.toString());
        Matrix3 id = Matrix3.mul(inv, M);
        System.out.println("identity M-1 x M: " + LS + id.toString());
        id = Matrix3.mul(M, inv);
        System.out.println("identity : M x M-1" + LS + id.toString());
    }
}

