/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.beans.PropertyChangeListener;
import sgtplot.Transform;
import sgtplot.util.Range2D;

public class LinearTransform
implements Transform {
    Range2D mPhysRange = null;
    Range2D mUserRange = null;
    double mPUSlope;
    double mPUYintercept;
    double mUPSlope;
    double mUPYintercept;

    public LinearTransform(double p1, double p2, double u1, double u2) {
        this.setRangeP(p1, p2);
        this.setRangeU(u1, u2);
        this.computeTransforms();
    }

    public LinearTransform(Range2D prange, Range2D urange) {
        this.setRangeP(prange);
        this.setRangeU(urange);
        this.computeTransforms();
    }

    public LinearTransform() {
    }

    @Override
    public void setRangeP(double p1, double p2) {
        this.mPhysRange = new Range2D(p1, p2);
    }

    @Override
    public void setRangeP(Range2D prange) {
        this.mPhysRange = null;
        this.mPhysRange = new Range2D();
        this.mPhysRange.add(prange);
    }

    @Override
    public Range2D getRangeP() {
        return this.mPhysRange;
    }

    @Override
    public void setRangeU(double u1, double u2) {
        this.mUserRange = new Range2D(u1, u2);
    }

    @Override
    public void setRangeU(Range2D urange) {
        this.mUserRange = null;
        this.mUserRange = new Range2D();
        this.mUserRange.add(urange);
        this.computeTransforms();
    }

    @Override
    public Range2D getRangeU() {
        return this.mUserRange;
    }

    @Override
    public double getTransP(double u) {
        return this.mUPSlope * u + this.mUPYintercept;
    }

    @Override
    public double getTransU(double p) {
        return this.mPUSlope * p + this.mPUYintercept;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    public void computeTransforms() {
        this.computePULine();
        this.computeUPLine();
    }

    private void computePULine() {
        double denom = this.mPhysRange.start - this.mPhysRange.end;
        double num = this.mUserRange.start - this.mUserRange.end;
        this.mPUSlope = num / denom;
        this.mPUYintercept = this.mUserRange.start - this.mPUSlope * this.mPhysRange.start;
    }

    private void computeUPLine() {
        double num = this.mPhysRange.start - this.mPhysRange.end;
        double denom = this.mUserRange.start - this.mUserRange.end;
        this.mUPSlope = num / denom;
        this.mUPYintercept = this.mPhysRange.start - this.mPUSlope * this.mUserRange.start;
    }
}

