/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.util;

import java.beans.PropertyChangeListener;
import sgtplot.Transform;
import sgtplot.util.Range2D;

public class ExponentialTransformDown
implements Transform {
    Range2D mPhysRange = null;
    Range2D mUserRange = null;
    double a = 0.82605;
    double b = -2.3006;
    double c = 2.4729;

    public ExponentialTransformDown(double p1, double p2, double u1, double u2) {
        this.setRangeP(p1, p2);
        this.setRangeU(u1, u2);
    }

    public ExponentialTransformDown(Range2D prange, Range2D urange) {
        this.setRangeP(prange);
        this.setRangeU(urange);
    }

    public ExponentialTransformDown() {
    }

    @Override
    public void setRangeP(double p1, double p2) {
        this.mPhysRange = new Range2D(p1, p2);
    }

    @Override
    public void setRangeP(Range2D prange) {
        this.mPhysRange = null;
        this.mPhysRange = new Range2D();
        this.mPhysRange.add(prange);
    }

    @Override
    public Range2D getRangeP() {
        return this.mPhysRange;
    }

    @Override
    public void setRangeU(double u1, double u2) {
        this.mUserRange = new Range2D(u1, u2);
    }

    @Override
    public void setRangeU(Range2D urange) {
        this.mUserRange = null;
        this.mUserRange = new Range2D();
        this.mUserRange.add(urange);
    }

    @Override
    public Range2D getRangeU() {
        return this.mUserRange;
    }

    @Override
    public double getTransP(double u) {
        double retVal = 0.0;
        double y = (u - this.mUserRange.start) / (this.mUserRange.end - this.mUserRange.start);
        double x = 0.5;
        double inc = 1.0E-4;
        double eps = 0.001;
        int cnt = 0;
        while (true) {
            double tstVal;
            if (Math.abs((tstVal = this.c * x + this.b * (x * x) + this.a * (x * x * x)) - y) < eps) break;
            x = tstVal > y ? (x -= inc) : (x += inc);
            ++cnt;
        }
        retVal = x;
        retVal = this.mPhysRange.start + x * (this.mPhysRange.end - this.mPhysRange.start);
        return retVal;
    }

    @Override
    public double getTransU(double p) {
        double retVal = 0.0;
        double x = (p - this.mPhysRange.start) / (this.mPhysRange.end - this.mPhysRange.start);
        double y = this.c * x + this.b * (x * x) + this.a * (x * x * x);
        retVal = this.mUserRange.start + y * (this.mUserRange.end - this.mUserRange.start);
        return retVal;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

