/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing.prop;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import sgtplot.pmel.swing.ThreeDotsButton;
import sgtplot.swing.prop.ColorDialog;

public class ColorEntryPanel
extends JComponent {
    private JLabel redLabel = new JLabel();
    private JLabel greenLabel = new JLabel();
    private JLabel blueLabel = new JLabel();
    private JLabel alphaLabel = new JLabel();
    private JTextField redTF = new JTextField();
    private JTextField greenTF = new JTextField();
    private JTextField blueTF = new JTextField();
    private JTextField alphaTF = new JTextField();
    private ThreeDotsButton button = new ThreeDotsButton();
    private FlowLayout fLayout = new FlowLayout();
    private Color color_ = Color.black;
    private String title_ = "Set Color";

    public ColorEntryPanel(String title, Color color) {
        this.setColor(color);
        this.setTitle(title);
    }

    public ColorEntryPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.fLayout);
        this.redLabel.setText("red");
        this.greenLabel.setText("green");
        this.blueLabel.setText("blue");
        this.alphaLabel.setText("alpha");
        this.redTF.setText("0");
        this.redTF.setColumns(3);
        this.greenTF.setText("0");
        this.greenTF.setColumns(3);
        this.blueTF.setText("0");
        this.blueTF.setColumns(3);
        this.alphaTF.setText("0");
        this.alphaTF.setColumns(3);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEntryPanel.this.button_actionPerformed(e);
            }
        });
        this.button.setToolTipText("Edit color.");
        this.button.setActionCommand("...");
        this.add(this.redLabel);
        this.add(this.redTF);
        this.add(this.greenLabel);
        this.add(this.greenTF);
        this.add(this.blueLabel);
        this.add(this.blueTF);
        this.add(this.alphaLabel);
        this.add(this.alphaTF);
        this.add(this.button);
        boolean enabled = this.isEnabled();
        this.redTF.setEnabled(enabled);
        this.greenTF.setEnabled(enabled);
        this.blueTF.setEnabled(enabled);
        this.alphaTF.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redTF.setEnabled(enabled);
        this.greenTF.setEnabled(enabled);
        this.blueTF.setEnabled(enabled);
        this.alphaTF.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    void button_actionPerformed(ActionEvent e) {
        Window win = SwingUtilities.getWindowAncestor(this);
        ColorDialog cd = null;
        cd = win instanceof Frame ? new ColorDialog((Frame)win, this.title_, true) : (win instanceof Dialog ? new ColorDialog((Dialog)win, this.title_, true) : new ColorDialog((Frame)null, this.title_, true));
        cd.setColor(this.getColorFromTF());
        cd.setVisible(true);
        this.setColor(cd.getColor());
    }

    public void setColor(Color color) {
        this.color_ = color;
        this.redTF.setText(Integer.toString(this.color_.getRed()));
        this.greenTF.setText(Integer.toString(this.color_.getGreen()));
        this.blueTF.setText(Integer.toString(this.color_.getBlue()));
        this.alphaTF.setText(Integer.toString(this.color_.getAlpha()));
    }

    public Color getColor() {
        return this.getColorFromTF();
    }

    private Color getColorFromTF() {
        int red = Integer.parseInt(this.redTF.getText());
        int green = Integer.parseInt(this.greenTF.getText());
        int blue = Integer.parseInt(this.blueTF.getText());
        int alpha = Integer.parseInt(this.alphaTF.getText());
        return new Color(red, green, blue, alpha);
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public String getTitle() {
        return this.title_;
    }
}

