/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing;

import java.text.DecimalFormat;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTValue;

public class ValueIconFormat {
    protected DecimalFormat xfrm_;
    protected DecimalFormat yfrm_;
    protected String tfrm_ = "yyyy-MM-dd HH:mm:ss z";

    public ValueIconFormat(String xfrmt, String yfrmt) {
        this.xfrm_ = new DecimalFormat(xfrmt);
        this.yfrm_ = new DecimalFormat(yfrmt);
    }

    public String format(double x, double y) {
        return "(" + this.xfrm_.format(x) + ", " + this.yfrm_.format(y) + ")";
    }

    public void setTimeFormat(String tfrmt) {
        this.tfrm_ = tfrmt;
    }

    public String format(SoTPoint pt) {
        StringBuffer sbuf = new StringBuffer("(");
        if (pt.isXTime()) {
            sbuf.append(pt.getX().getGeoDate().toString(this.tfrm_));
        } else {
            sbuf.append(this.xfrm_.format(((SoTValue.Double)pt.getX()).getValue()));
        }
        sbuf.append(", ");
        if (pt.isYTime()) {
            sbuf.append(pt.getY().getGeoDate().toString(this.tfrm_));
        } else {
            sbuf.append(this.yfrm_.format(((SoTValue.Double)pt.getY()).getValue()));
        }
        sbuf.append(")");
        return sbuf.toString();
    }
}

