/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Date;
import java.util.Enumeration;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.Attribute;
import sgtplot.AttributeChangeEvent;
import sgtplot.Axis;
import sgtplot.AxisNotFoundException;
import sgtplot.CartesianGraph;
import sgtplot.CartesianRenderer;
import sgtplot.ColorKey;
import sgtplot.ColorMap;
import sgtplot.DataNotFoundException;
import sgtplot.Graph;
import sgtplot.GridAttribute;
import sgtplot.GridCartesianRenderer;
import sgtplot.IndexedColorMap;
import sgtplot.JPane;
import sgtplot.Layer;
import sgtplot.LayerNotFoundException;
import sgtplot.LineAttribute;
import sgtplot.LineCartesianRenderer;
import sgtplot.LineKey;
import sgtplot.LinearTransform;
import sgtplot.Logo;
import sgtplot.PlainAxis;
import sgtplot.PointAttribute;
import sgtplot.PointCartesianRenderer;
import sgtplot.PointCollectionKey;
import sgtplot.SGLabel;
import sgtplot.StackedLayout;
import sgtplot.TimeAxis;
import sgtplot.TransformAccess;
import sgtplot.VectorAttribute;
import sgtplot.VectorCartesianRenderer;
import sgtplot.VectorKey;
import sgtplot.dm.Collection;
import sgtplot.dm.PointCollection;
import sgtplot.dm.SGTData;
import sgtplot.dm.SGTGrid;
import sgtplot.dm.SGTLine;
import sgtplot.dm.SGTMetaData;
import sgtplot.dm.SGTVector;
import sgtplot.dm.SimpleLine;
import sgtplot.swing.JGraphicLayout;
import sgtplot.util.Dimension2D;
import sgtplot.util.Domain;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;
import sgtplot.util.Rectangle2D;
import sgtplot.util.SoTDomain;
import sgtplot.util.SoTPoint;
import sgtplot.util.SoTRange;
import sgtplot.util.TimeRange;

public class JPlotLayout
extends JGraphicLayout
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    CartesianGraph coastLine_ = null;
    Layer coastLayer_ = null;
    Logo logo_;
    LineKey lineKey_;
    ColorKey colorKey_;
    PointCollectionKey pointKey_;
    VectorKey vectorKey_;
    private boolean computeScroll_ = false;
    int layerCount_;
    boolean revXAxis_ = false;
    boolean revYAxis_ = false;
    Layer firstLayer_;
    boolean inZoom_ = false;
    GridAttribute gAttr_ = null;
    private boolean isXTime_ = false;
    private boolean isYTime_ = false;
    double xSize_ = XSIZE_;
    double xMin_ = XMIN_;
    double xMax_ = XMAX_;
    double ySize_ = YSIZE_;
    double yMin_ = YMIN_;
    double yMax_ = YSIZE_ - 1.0 * MAIN_TITLE_HEIGHT_ - 2.0 * WARN_HEIGHT_ - 0.5 * WARN_HEIGHT_;
    double mainTitleHeight_ = MAIN_TITLE_HEIGHT_;
    double titleHeight_ = TITLE_HEIGHT_;
    double labelHeight_ = LABEL_HEIGHT_;
    double warnHeight_ = WARN_HEIGHT_;
    double keyHeight_ = KEY_HEIGHT_;
    double xKeySize_ = XKEYSIZE_;
    double yKeySize_ = YKEYSIZE_;
    Color paneColor_ = PANE_COLOR;
    Color keyPaneColor_ = KEYPANE_COLOR;
    boolean autoRangeX_ = false;
    boolean autoRangeY_ = false;
    int autoXIntervals_ = 10;
    int autoYIntervals_ = 10;
    public static final int POINTS = 0;
    public static final int LINE = 1;
    public static final int GRID = 2;
    public static final int VECTOR = 3;
    private int plotType_ = -1;
    private static final Color[] colorList_ = new Color[]{Color.blue, Color.cyan.darker(), Color.green, Color.orange.darker(), Color.red, Color.magenta, Color.black, Color.gray};
    private static final int[] markList_ = new int[]{1, 2, 9, 15, 10, 24, 11, 44};
    private static String LEFT_AXIS = "Left Axis";
    private static String BOTTOM_AXIS = "Bottom Axis";
    private Layer layer;
    private Layer key_layer;
    private CartesianGraph graph;
    private LinearTransform xt;
    private LinearTransform yt;
    private PlainAxis xbot = null;
    private PlainAxis yleft = null;
    private TimeAxis tbot = null;
    private TimeAxis tleft = null;
    private double xpos;
    private double ypos;
    private int halign;
    private ColorMap cmap;

    public JPlotLayout(SGTData dataset) {
        this(dataset, "", null, false);
    }

    public JPlotLayout(SGTData dataset, String id, Image img, boolean is_key_pane) {
        this(dataset instanceof SGTGrid ? 2 : (dataset instanceof PointCollection ? 0 : (dataset instanceof SGTVector ? 3 : 1)), dataset.isXTime(), dataset.isYTime(), id, img, is_key_pane);
    }

    public JPlotLayout(boolean isGrid, boolean isXTime, boolean isYTime, String id, Image img, boolean is_key_pane) {
        this(isGrid ? 2 : 1, isXTime, isYTime, id, img, is_key_pane);
    }

    public JPlotLayout(boolean isGrid, boolean isPoints, boolean isXTime, boolean isYTime, String id, Image img, boolean is_key_pane) {
        this(isGrid ? 2 : (isPoints ? 0 : 1), isXTime, isYTime, id, img, is_key_pane);
    }

    public JPlotLayout(int type, boolean isXTime, boolean isYTime, String id, Image img, boolean is_key_pane) {
        super(id, img, new Dimension(400, 300));
        int ydim;
        int xdim;
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.isXTime_ = isXTime;
        this.isYTime_ = isYTime;
        this.plotType_ = type;
        this.setOpaque(true);
        this.setLayout(new StackedLayout());
        this.setBackground(this.paneColor_);
        this.firstLayer_ = this.layer = new Layer("Layer 1", new Dimension2D(this.xSize_, this.ySize_));
        if (this.coastLine_ == null) {
            this.add((Component)this.layer, 0);
        } else {
            this.add((Component)this.layer, 1);
        }
        if (this.plotType_ == 2) {
            this.colorKey_ = new ColorKey(new Rectangle2D.Double(0.01, 0.01, this.xKeySize_ - 0.01, 1.0), 2, 2);
            this.colorKey_.setId("Color Key");
            this.colorKey_.setVisible(true);
            if (is_key_pane) {
                System.out.println("Key true");
                this.colorKey_.setVAlign(0);
                this.colorKey_.setBorderStyle(2);
                this.colorKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                xdim = 500;
                ydim = (int)((double)xdim / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(xdim, ydim));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                this.key_layer = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(this.key_layer);
                this.key_layer.addChild(this.colorKey_);
            } else {
                this.colorKey_.setBorderStyle(2);
                this.colorKey_.setOrientation(2);
                this.colorKey_.setVAlign(2);
                this.colorKey_.setHAlign(2);
                double cWidth = 0.1;
                this.colorKey_.setBoundsP(new Rectangle2D.Double(this.xMax_ + 1.5 * cWidth, 0.5, cWidth, this.yMax_ - this.yMin_));
                this.colorKey_.setScaleP(this.yMin_, this.yMax_);
                this.colorKey_.setLocationP(new Point2D.Double(this.xMax_ + 1.5 * cWidth, this.yMin_));
                this.colorKey_.setSelectable(true);
                this.layer.addChild(this.colorKey_);
            }
        } else if (this.plotType_ == 0) {
            this.pointKey_ = new PointCollectionKey();
            this.pointKey_.setSelectable(false);
            this.pointKey_.setId("Point Key");
            this.pointKey_.setVAlign(0);
            if (is_key_pane) {
                this.pointKey_.setHAlign(0);
                this.pointKey_.setBorderStyle(2);
                this.pointKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                xdim = 500;
                ydim = (int)((double)xdim / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(xdim, ydim));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                this.key_layer = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(this.key_layer);
                this.key_layer.addChild(this.pointKey_);
            } else {
                this.pointKey_.setVAlign(0);
                this.pointKey_.setHAlign(2);
                this.pointKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                this.layer.addChild(this.pointKey_);
            }
        } else if (this.plotType_ == 1) {
            this.lineKey_ = new LineKey();
            this.lineKey_.setSelectable(false);
            this.lineKey_.setId("Line Key");
            this.lineKey_.setVAlign(0);
            if (is_key_pane) {
                this.lineKey_.setHAlign(0);
                this.lineKey_.setBorderStyle(2);
                this.lineKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                xdim = 500;
                ydim = (int)((double)xdim / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(xdim, ydim));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                this.key_layer = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(this.key_layer);
                this.key_layer.addChild(this.lineKey_);
            } else {
                this.lineKey_.setVAlign(0);
                this.lineKey_.setHAlign(2);
                this.lineKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                this.layer.addChild(this.lineKey_);
            }
        } else if (this.plotType_ == 3) {
            this.vectorKey_ = new VectorKey();
            this.vectorKey_.setSelectable(false);
            this.vectorKey_.setId("Vector Key");
            this.vectorKey_.setVAlign(0);
            if (is_key_pane) {
                this.vectorKey_.setHAlign(0);
                this.vectorKey_.setBorderStyle(2);
                this.vectorKey_.setLocationP(new Point2D.Double(0.0, this.yKeySize_));
                xdim = 500;
                ydim = (int)((double)xdim / this.xKeySize_ * this.yKeySize_);
                this.keyPane_ = new JPane("KeyPane", new Dimension(xdim, ydim));
                this.keyPane_.setOpaque(true);
                this.keyPane_.setLayout(new StackedLayout());
                this.keyPane_.setBackground(this.keyPaneColor_);
                this.key_layer = new Layer("Key Layer", new Dimension2D(this.xKeySize_, this.yKeySize_));
                this.keyPane_.add(this.key_layer);
                this.key_layer.addChild(this.vectorKey_);
            } else {
                this.vectorKey_.setVAlign(0);
                this.vectorKey_.setHAlign(2);
                this.vectorKey_.setLocationP(new Point2D.Double(this.xSize_ - 0.02, this.ySize_ - 0.1));
                this.vectorKey_.setSelectable(true);
                this.layer.addChild(this.vectorKey_);
            }
        }
        if (this.iconImage_ != null) {
            this.logo_ = new Logo(new Point2D.Double(0.0, this.ySize_), 0, 0);
            this.logo_.setImage(this.iconImage_);
            this.layer.addChild(this.logo_);
            Rectangle bnds = this.logo_.getBounds();
            this.xpos = this.layer.getXDtoP(bnds.x + bnds.width) + 0.05;
            this.halign = 0;
        } else {
            this.xpos = (this.xMin_ + this.xMax_) * 0.5;
            this.halign = 1;
        }
        this.ypos = this.ySize_ - 1.0 * this.mainTitleHeight_;
        Font titleFont = new Font("Arial", 1, 14);
        this.mainTitle_ = new SGLabel("Line Profile Title", "Profile Plot", this.mainTitleHeight_, new Point2D.Double(this.xpos, this.ypos), 2, this.halign);
        this.mainTitle_.setFont(titleFont);
        this.layer.addChild(this.mainTitle_);
        this.ypos -= 1.0 * this.warnHeight_;
        Font title2Font = new Font("Arial", 0, 10);
        this.title2_ = new SGLabel("Second Title", "Warning: Browse image only", this.warnHeight_, new Point2D.Double(this.xpos, this.ypos), 2, this.halign);
        this.title2_.setFont(title2Font);
        this.layer.addChild(this.title2_);
        this.ypos -= 1.0 * this.warnHeight_;
        this.title3_ = new SGLabel("Warning 2", "Verify accuracy of plot before research use", this.warnHeight_, new Point2D.Double(this.xpos, this.ypos), 2, this.halign);
        this.title3_.setFont(title2Font);
        this.layer.addChild(this.title3_);
        this.layerCount_ = 0;
        this.graph = new CartesianGraph("Profile Graph 1");
        GeoDate start = null;
        Date end = null;
        try {
            start = new GeoDate("1992-11-01", "yyyy-MM-dd");
            end = new GeoDate("1993-02-20", "yyyy-MM-dd");
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        SoTRange xRange = this.isXTime_ ? new SoTRange.Time(start.getTime(), end.getTime()) : new SoTRange.Double(10.0, 20.0, 2.0);
        SoTRange yRange = this.isYTime_ ? new SoTRange.Time(start.getTime(), end.getTime()) : new SoTRange.Double(400.0, 0.0, -50.0);
        this.xt = new LinearTransform(new Range2D(this.xMin_, this.xMax_), xRange);
        this.yt = new LinearTransform(new Range2D(this.yMin_, this.yMax_), yRange);
        SoTPoint origin = new SoTPoint(xRange.getStart(), yRange.getStart());
        this.graph.setXTransform(this.xt);
        this.graph.setYTransform(this.yt);
        Font axfont = new Font("Arial", 1, 14);
        if (this.isXTime_) {
            this.tbot = new TimeAxis(BOTTOM_AXIS, 0);
            this.tbot.setRangeU(xRange);
            this.tbot.setLabelHeightP(this.labelHeight_);
            this.tbot.setLocationU(origin);
            this.tbot.setLabelFont(axfont);
            this.graph.addXAxis(this.tbot);
        } else {
            this.xbot = new PlainAxis(BOTTOM_AXIS);
            this.xbot.setRangeU(xRange);
            this.xbot.setNumberSmallTics(0);
            this.xbot.setLocationU(origin);
            this.xbot.setLabelHeightP(this.labelHeight_);
            this.xbot.setLabelFont(axfont);
            this.graph.addXAxis(this.xbot);
        }
        if (this.isYTime_) {
            this.tleft = new TimeAxis(LEFT_AXIS, 0);
            this.tleft.setRangeU(yRange);
            this.tleft.setLabelHeightP(this.labelHeight_);
            this.tleft.setLocationU(origin);
            this.tleft.setLabelFont(axfont);
            this.graph.addYAxis(this.tleft);
        } else {
            this.yleft = new PlainAxis(LEFT_AXIS);
            this.yleft.setRangeU(yRange);
            this.yleft.setNumberSmallTics(0);
            this.yleft.setLabelHeightP(this.labelHeight_);
            this.yleft.setLocationU(origin);
            this.yleft.setLabelFont(axfont);
            this.graph.addYAxis(this.yleft);
        }
        if (this.plotType_ == 2) {
            this.cmap = new IndexedColorMap(red, green, blue);
            LinearTransform ctrans = new LinearTransform(0.0, (double)red.length, 0.0, 1.0);
            ((IndexedColorMap)this.cmap).setTransform(ctrans);
            this.gAttr_ = new GridAttribute(0, this.cmap);
            this.gAttr_.addPropertyChangeListener(this);
            this.colorKey_.setColorMap(this.cmap);
        }
        this.layer.setGraph(this.graph);
    }

    @Override
    public String getLocationSummary(SGTData grid) {
        return "";
    }

    public void addData(Collection lines) {
        this.addData(lines, null, null);
    }

    public void addData(Collection lines, Attribute attr) {
        this.addData(lines, attr, null);
    }

    public void addData(PointCollection points, String descrip) {
        this.addData((SGTData)points, descrip);
    }

    public void addData(Collection lines, String descrip) {
        this.addData(lines, null, descrip);
    }

    public void addData(Collection lines, Attribute attr, String descrip) {
        for (int i = 0; i < lines.size(); ++i) {
            SGTLine line = (SGTLine)lines.elementAt(i);
            this.addData(line, attr, line.getTitle());
        }
    }

    @Override
    public void addData(SGTData datum) {
        this.addData(datum, null, null);
    }

    public void addData(SGTData datum, Attribute attr) {
        this.addData(datum, attr, null);
    }

    @Override
    public void addData(SGTData datum, String descrip) {
        this.addData(datum, null, descrip);
    }

    public void addData(SGTData datum, Attribute attr, String descrip) {
        Axis bottom = null;
        Axis left = null;
        SGTGrid grid = null;
        SGTLine line = null;
        SGTVector vector = null;
        PointCollection points = null;
        LineAttribute lineAttr = null;
        GridAttribute gridAttr = null;
        PointAttribute pointAttr = null;
        VectorAttribute vectorAttr = null;
        SoTRange xRange = null;
        SoTRange yRange = null;
        SoTRange xnRange = null;
        SoTRange ynRange = null;
        SoTPoint origin = null;
        Range2D vRange = null;
        boolean data_good = true;
        boolean flipX = false;
        boolean flipY = false;
        boolean showColorKey = false;
        if (this.data_.size() == 0) {
            SGLabel lineTitle;
            Layer layer;
            super.addData(datum);
            SGTData data = (SGTData)this.data_.firstElement();
            if (this.plotType_ == 2) {
                grid = (SGTGrid)data;
            } else if (this.plotType_ == 0) {
                points = (PointCollection)data;
            } else if (this.plotType_ == 1) {
                line = (SGTLine)data;
            } else if (this.plotType_ == 3) {
                vector = (SGTVector)data;
            }
            if (this.plotType_ == 2) {
                ColorMap cmap;
                if (attr != null && attr instanceof GridAttribute) {
                    gridAttr = (GridAttribute)attr;
                    gridAttr.addPropertyChangeListener(this);
                } else {
                    gridAttr = this.gAttr_;
                }
                this.addAttribute(datum, gridAttr);
                showColorKey = gridAttr.isRaster();
                vRange = this.findRange(grid, gridAttr, 3);
                if (gridAttr.isRaster() && (cmap = gridAttr.getColorMap()) instanceof TransformAccess) {
                    ((TransformAccess)((Object)cmap)).setRange(vRange);
                }
                xRange = this.findSoTRange(grid, gridAttr, 1);
                yRange = this.findSoTRange(grid, gridAttr, 2);
            } else if (this.plotType_ == 1 || this.plotType_ == 0) {
                xRange = data.getXRange();
                yRange = data.getYRange();
            } else if (this.plotType_ == 3) {
                xRange = this.findSoTRange(vector, 1);
                yRange = this.findSoTRange(vector, 2);
            }
            flipX = data.getXMetaData().isReversed();
            flipY = data.getYMetaData().isReversed();
            data_good = !xRange.isStartOrEndMissing() && !yRange.isStartOrEndMissing();
            this.revXAxis_ = flipX;
            this.revYAxis_ = flipY;
            if (data_good) {
                if (flipX) {
                    xRange.flipStartAndEnd();
                }
                if (flipY) {
                    yRange.flipStartAndEnd();
                }
                if (this.isXTime_) {
                    xnRange = xRange;
                } else if (this.autoRangeX_) {
                    xnRange = Graph.computeRange(xRange, this.autoXIntervals_);
                } else {
                    xnRange = xRange;
                    ((SoTRange.Double)xnRange).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)xRange, (int)this.autoXIntervals_)).delta;
                }
                if (this.isYTime_) {
                    ynRange = yRange;
                } else if (this.autoRangeY_) {
                    ynRange = Graph.computeRange(yRange, this.autoYIntervals_);
                } else {
                    ynRange = yRange;
                    ((SoTRange.Double)ynRange).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)yRange, (int)this.autoYIntervals_)).delta;
                }
                this.adjustRange(xnRange);
                this.adjustRange(ynRange);
                origin = new SoTPoint(xnRange.getStart(), ynRange.getStart());
            }
            String xLabel = data.getXMetaData().getName();
            String yLabel = data.getYMetaData().getName();
            try {
                layer = this.getLayer("Layer 1");
            }
            catch (LayerNotFoundException e) {
                return;
            }
            CartesianGraph graph = (CartesianGraph)layer.getGraph();
            try {
                Font tfont = new Font("Arial", 1, 16);
                SGLabel xtitle = new SGLabel("xaxis title", xLabel, new Point2D.Double(0.0, 0.0));
                xtitle.setFont(tfont);
                xtitle.setHeightP(this.titleHeight_);
                bottom = graph.getXAxis(BOTTOM_AXIS);
                bottom.setRangeU(xRange);
                bottom.setLocationU(origin);
                bottom.setTitle(xtitle);
                bottom.getTitle().setSelectable(true);
                SGLabel ytitle = new SGLabel("yaxis title", yLabel, new Point2D.Double(0.0, 0.0));
                ytitle.setFont(tfont);
                ytitle.setHeightP(this.titleHeight_);
                ytitle.setSelectable(true);
                left = graph.getYAxis(LEFT_AXIS);
                left.setRangeU(ynRange);
                left.setLocationU(origin);
                left.setTitle(ytitle);
                left.getTitle().setSelectable(true);
            }
            catch (AxisNotFoundException tfont) {
                // empty catch block
            }
            if (data_good) {
                LinearTransform xt = (LinearTransform)graph.getXTransform();
                xt.setRangeU(xnRange);
                LinearTransform yt = (LinearTransform)graph.getYTransform();
                yt.setRangeU(ynRange);
            }
            if (this.plotType_ == 2) {
                graph.setData(grid, gridAttr);
            } else if (this.plotType_ == 0) {
                if (attr != null && attr instanceof PointAttribute) {
                    pointAttr = (PointAttribute)attr;
                } else {
                    pointAttr = new PointAttribute(markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                    pointAttr.setMarkHeightP(0.05);
                    pointAttr.setLabelHeightP(0.05);
                    pointAttr.setDrawLabel(false);
                    pointAttr.setLabelColor(Color.red);
                    pointAttr.setLabelPosition(2);
                }
                pointAttr.addPropertyChangeListener(this);
                this.addAttribute(datum, pointAttr);
                graph.setData(points, pointAttr);
            } else if (this.plotType_ == 1) {
                int len = this.isYTime_ ? line.getXArray().length : line.getYArray().length;
                lineAttr = attr != null && attr instanceof LineAttribute ? (LineAttribute)attr : (len >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]));
                lineAttr.addPropertyChangeListener(this);
                this.addAttribute(datum, lineAttr);
                graph.setData(line, lineAttr);
            } else if (this.plotType_ == 3) {
                vectorAttr = attr != null && attr instanceof VectorAttribute ? (VectorAttribute)attr : new VectorAttribute(2, 0.1, Color.black, 0.1);
                vectorAttr.addPropertyChangeListener(this);
                this.addAttribute(datum, vectorAttr);
                graph.setData(vector, vectorAttr);
            }
            if (descrip == null) {
                lineTitle = datum.getKeyTitle();
                if (lineTitle == null) {
                    lineTitle = new SGLabel("line title", xLabel, new Point2D.Double(0.0, 0.0));
                }
            } else {
                lineTitle = new SGLabel("line title", descrip, new Point2D.Double(0.0, 0.0));
            }
            lineTitle.setHeightP(this.keyHeight_);
            int rowHeight = 1;
            if (!this.isShowing()) {
                this.computeScroll_ = true;
            }
            if (this.plotType_ == 2) {
                this.colorKey_.setColorMap(gridAttr.getColorMap());
                this.colorKey_.setVisible(showColorKey);
            } else if (this.plotType_ == 0) {
                this.pointKey_.addPointGraph((PointCartesianRenderer)graph.getRenderer(), lineTitle);
                if (this.keyPane_ != null) {
                    Rectangle vRect = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        rowHeight = this.pointKey_.getRowHeight();
                    }
                    int nrow = vRect.height / rowHeight;
                    this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                    this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                }
            } else if (this.plotType_ == 1) {
                this.lineKey_.addLineGraph((LineCartesianRenderer)graph.getRenderer(), lineTitle);
                if (this.keyPane_ != null) {
                    Rectangle vRect = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        rowHeight = this.lineKey_.getRowHeight();
                    }
                    int nrow = vRect.height / rowHeight;
                    this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                    this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                }
            } else if (this.plotType_ == 3) {
                this.vectorKey_.addVectorGraph((VectorCartesianRenderer)graph.getRenderer(), lineTitle);
                if (this.keyPane_ != null) {
                    Rectangle vRect = this.keyPane_.getVisibleRect();
                    if (this.isShowing()) {
                        rowHeight = this.vectorKey_.getRowHeight();
                    }
                    int nrow = vRect.height / rowHeight;
                    this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                    this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                }
            }
            this.updateCoastLine();
        } else {
            if (this.plotType_ == 2) {
                return;
            }
            if (datum instanceof SGTLine && datum.getYMetaData().isReversed() != this.revYAxis_) {
                SGTData modified;
                datum = modified = this.flipY(datum);
            }
            super.addData(datum);
            data_good = false;
            ++this.layerCount_;
            if (this.isOverlayed()) {
                Rectangle vRect;
                SGLabel lineTitle;
                String xLabel;
                Layer layer;
                try {
                    layer = this.getLayer("Layer 1");
                }
                catch (LayerNotFoundException e) {
                    return;
                }
                CartesianGraph graph = (CartesianGraph)layer.getGraph();
                LinearTransform xt = (LinearTransform)graph.getXTransform();
                LinearTransform yt = (LinearTransform)graph.getYTransform();
                try {
                    bottom = graph.getXAxis(BOTTOM_AXIS);
                    left = graph.getYAxis(LEFT_AXIS);
                }
                catch (AxisNotFoundException e) {
                    // empty catch block
                }
                if (!this.inZoom_) {
                    SoTRange xTotalRange = null;
                    SoTRange yTotalRange = null;
                    boolean first = true;
                    Enumeration e = this.data_.elements();
                    while (e.hasMoreElements()) {
                        SGTData data = (SGTData)e.nextElement();
                        xRange = data.getXRange();
                        yRange = data.getYRange();
                        flipX = data.getXMetaData().isReversed();
                        flipY = data.getYMetaData().isReversed();
                        this.revXAxis_ = flipX;
                        this.revYAxis_ = flipY;
                        if (flipX) {
                            xRange.flipStartAndEnd();
                        }
                        if (flipY) {
                            yRange.flipStartAndEnd();
                        }
                        if (first) {
                            boolean bl = data_good = !xRange.isStartOrEndMissing() && !yRange.isStartOrEndMissing();
                            if (!data_good) {
                                first = true;
                                continue;
                            }
                            first = false;
                            data_good = true;
                            xTotalRange = xRange;
                            yTotalRange = yRange;
                            continue;
                        }
                        data_good = !xRange.isStartOrEndMissing() && !yRange.isStartOrEndMissing();
                        if (!data_good) continue;
                        xTotalRange.add(xRange);
                        yTotalRange.add(yRange);
                    }
                    if (data_good) {
                        if (this.isXTime_) {
                            xnRange = xTotalRange;
                        } else if (this.autoRangeX_) {
                            xnRange = Graph.computeRange(xTotalRange, this.autoXIntervals_);
                        } else {
                            xnRange = xTotalRange;
                            ((SoTRange.Double)xnRange).delta = ((SoTRange.Double)Graph.computeRange(xTotalRange, (int)this.autoXIntervals_)).delta;
                        }
                        if (this.isYTime_) {
                            ynRange = yTotalRange;
                        } else if (this.autoRangeY_) {
                            ynRange = Graph.computeRange(yTotalRange, this.autoYIntervals_);
                        } else {
                            ynRange = yTotalRange;
                            ((SoTRange.Double)ynRange).delta = ((SoTRange.Double)Graph.computeRange(yTotalRange, (int)this.autoYIntervals_)).delta;
                        }
                        this.adjustRange(xnRange);
                        this.adjustRange(ynRange);
                        origin = new SoTPoint(xnRange.getStart(), ynRange.getStart());
                        bottom.setRangeU(xnRange);
                        bottom.setLocationU(origin);
                        left.setRangeU(ynRange);
                        left.setLocationU(origin);
                        xt.setRangeU(xnRange);
                        yt.setRangeU(ynRange);
                        this.updateCoastLine();
                    }
                }
                Layer newLayer = new Layer("Layer " + (this.layerCount_ + 1), new Dimension2D(this.xSize_, this.ySize_));
                CartesianGraph newGraph = new CartesianGraph("Graph " + (this.layerCount_ + 1), xt, yt);
                if (this.inZoom_) {
                    SoTRange xr = null;
                    SoTRange yr = null;
                    xr = bottom.getSoTRangeU();
                    yr = left.getSoTRangeU();
                    newGraph.setClip(xr, yr);
                    newGraph.setClipping(true);
                }
                if (this.coastLine_ == null) {
                    this.add((Component)newLayer, 0);
                } else {
                    this.add((Component)newLayer, 1);
                }
                newLayer.setGraph(newGraph);
                newLayer.invalidate();
                this.validate();
                if (this.plotType_ == 0) {
                    if (attr != null && attr instanceof PointAttribute) {
                        pointAttr = (PointAttribute)attr;
                    } else {
                        pointAttr = new PointAttribute(markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]);
                        pointAttr.setMarkHeightP(0.15);
                        pointAttr.setLabelHeightP(0.15);
                        pointAttr.setDrawLabel(false);
                        pointAttr.setLabelColor(Color.red);
                        pointAttr.setLabelPosition(2);
                    }
                    pointAttr.addPropertyChangeListener(this);
                    this.addAttribute(datum, pointAttr);
                    newGraph.setData(datum, pointAttr);
                } else if (this.plotType_ == 1) {
                    int len = this.isYTime_ ? ((SGTLine)datum).getXArray().length : ((SGTLine)datum).getYArray().length;
                    lineAttr = attr != null && attr instanceof LineAttribute ? (LineAttribute)attr : (len >= 2 ? new LineAttribute(0, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]) : new LineAttribute(4, markList_[this.layerCount_ % 8], colorList_[this.layerCount_ % 8]));
                    lineAttr.addPropertyChangeListener(this);
                    this.addAttribute(datum, lineAttr);
                    newGraph.setData(datum, lineAttr);
                } else if (this.plotType_ == 3) {
                    // empty if block
                }
                if (this.pointKey_ != null) {
                    if (descrip == null) {
                        xLabel = datum.getXMetaData().getName();
                        lineTitle = new SGLabel("line title", xLabel, new Point2D.Double(0.0, 0.0));
                    } else {
                        lineTitle = new SGLabel("line title", descrip, new Point2D.Double(0.0, 0.0));
                    }
                    lineTitle.setHeightP(this.keyHeight_);
                    this.pointKey_.addPointGraph((PointCartesianRenderer)newGraph.getRenderer(), lineTitle);
                    if (this.keyPane_ != null) {
                        vRect = this.keyPane_.getVisibleRect();
                        int nrow = vRect.height / this.pointKey_.getRowHeight();
                        this.keyPane_.setScrollableUnitIncrement(1, this.pointKey_.getRowHeight());
                        this.keyPane_.setScrollableBlockIncrement(vRect.width, this.pointKey_.getRowHeight() * nrow);
                    }
                }
                if (this.lineKey_ != null) {
                    if (descrip == null) {
                        xLabel = datum.getXMetaData().getName();
                        lineTitle = new SGLabel("line title", xLabel, new Point2D.Double(0.0, 0.0));
                    } else {
                        lineTitle = new SGLabel("line title", descrip, new Point2D.Double(0.0, 0.0));
                    }
                    lineTitle.setHeightP(this.keyHeight_);
                    this.lineKey_.addLineGraph((LineCartesianRenderer)newGraph.getRenderer(), lineTitle);
                    if (this.keyPane_ != null) {
                        vRect = this.keyPane_.getVisibleRect();
                        int nrow = vRect.height / this.lineKey_.getRowHeight();
                        this.keyPane_.setScrollableUnitIncrement(1, this.lineKey_.getRowHeight());
                        this.keyPane_.setScrollableBlockIncrement(vRect.width, this.lineKey_.getRowHeight() * nrow);
                    }
                }
            }
        }
    }

    private void adjustRange(SoTRange range) {
        if (range.isTime()) {
            long st;
            long end = range.getEnd().getLongTime();
            if (end == (st = range.getStart().getLongTime())) {
                end += -1702967296L;
                st -= -1702967296L;
                if (range instanceof SoTRange.Time) {
                    ((SoTRange.Time)range).end = end;
                    ((SoTRange.Time)range).start = st;
                } else {
                    ((SoTRange.GeoDate)range).end = new GeoDate(end);
                    ((SoTRange.GeoDate)range).start = new GeoDate(st);
                }
            }
        } else {
            double end = ((SoTRange.Double)range).end;
            double st = ((SoTRange.Double)range).start;
            double dlt = ((SoTRange.Double)range).delta;
            if (dlt == 0.0) {
                end = st;
            }
            if (end == st) {
                if (end == 0.0) {
                    st = -1.0;
                    end = 1.0;
                } else {
                    end = end > 0.0 ? 1.1 * end : 0.9 * end;
                    st = st > 0.0 ? 0.9 * st : 1.1 * st;
                }
                ((SoTRange.Double)range).end = end;
                ((SoTRange.Double)range).start = st;
                ((SoTRange.Double)range).delta = ((SoTRange.Double)Graph.computeRange((SoTRange)range, (int)10)).delta;
            }
        }
    }

    private SGTData flipY(SGTData in) {
        SimpleLine out = null;
        SGTLine line = (SGTLine)in;
        double[] values = line.getYArray();
        double[] newValues = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            newValues[i] = -values[i];
        }
        out = new SimpleLine(line.getXArray(), newValues, line.getTitle());
        SGTMetaData zmetain = line.getYMetaData();
        SGTMetaData zmetaout = new SGTMetaData(zmetain.getName(), zmetain.getUnits(), zmetain.isReversed(), zmetain.isModulo());
        zmetaout.setModuloValue(zmetain.getModuloValue());
        zmetaout.setModuloTime(zmetain.getModuloTime());
        out.setXMetaData(line.getXMetaData());
        out.setYMetaData(zmetaout);
        return out;
    }

    @Override
    public void resetZoom() {
        GridAttribute gridAttr = null;
        SoTRange xRange = null;
        SoTRange yRange = null;
        SoTRange xTotalRange = null;
        SoTRange yTotalRange = null;
        boolean data_good = false;
        boolean flipY = false;
        boolean flipX = false;
        boolean batch = this.isBatch();
        this.setBatch(true, "JPlotLayout: resetZoom");
        this.inZoom_ = false;
        this.setAllClipping(false);
        this.setClipping(false);
        boolean first = true;
        Enumeration e = this.data_.elements();
        while (e.hasMoreElements()) {
            Attribute attr;
            SGTData data = (SGTData)e.nextElement();
            try {
                attr = this.getAttribute(data);
            }
            catch (DataNotFoundException except) {
                System.out.println(except);
                attr = null;
            }
            if (this.plotType_ == 2) {
                gridAttr = attr != null && attr instanceof GridAttribute ? (GridAttribute)attr : this.gAttr_;
                xRange = this.findSoTRange((SGTGrid)data, gridAttr, 1);
                yRange = this.findSoTRange((SGTGrid)data, gridAttr, 2);
            } else if (this.plotType_ == 0 || this.plotType_ == 1) {
                xRange = data.getXRange();
                yRange = data.getYRange();
            } else if (this.plotType_ == 3) {
                xRange = this.findSoTRange((SGTVector)data, 1);
                yRange = this.findSoTRange((SGTVector)data, 2);
            }
            flipX = data.getXMetaData().isReversed();
            flipY = data.getYMetaData().isReversed();
            this.revXAxis_ = flipX;
            this.revYAxis_ = flipY;
            if (flipX) {
                xRange.flipStartAndEnd();
            }
            if (flipY) {
                yRange.flipStartAndEnd();
            }
            if (first) {
                boolean bl = data_good = !xRange.isStartOrEndMissing() && !yRange.isStartOrEndMissing();
                if (!data_good) {
                    first = true;
                    continue;
                }
                first = false;
                data_good = true;
                xTotalRange = xRange;
                yTotalRange = yRange;
                continue;
            }
            data_good = !xRange.isStartOrEndMissing() && !yRange.isStartOrEndMissing();
            if (!data_good) continue;
            xTotalRange.add(xRange);
            yTotalRange.add(yRange);
        }
        if (xTotalRange != null && yTotalRange != null) {
            this.adjustRange(xTotalRange);
            this.adjustRange(yTotalRange);
            if (data_good) {
                try {
                    this.setRange(new SoTDomain(xTotalRange, yTotalRange, flipX, flipY));
                }
                catch (PropertyVetoException ve) {
                    System.out.println("zoom reset denied! " + ve);
                }
            }
        }
        this.inZoom_ = false;
        this.updateCoastLine();
        if (!batch) {
            this.setBatch(false, "JPlotLayout: resetZoom");
        }
    }

    @Override
    public Domain getRange() {
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        Range2D xr = null;
        Range2D yr = null;
        TimeRange tr = null;
        if (xt.isTime()) {
            tr = xt.getTimeRangeU();
        } else {
            xr = xt.getRangeU();
        }
        if (yt.isTime()) {
            tr = yt.getTimeRangeU();
        } else {
            yr = yt.getRangeU();
        }
        if (xt.isTime()) {
            return new Domain(tr, yr);
        }
        if (yt.isTime()) {
            return new Domain(xr, tr);
        }
        return new Domain(xr, yr);
    }

    public void setRange(SoTDomain std) throws PropertyVetoException {
        SoTRange.Double dbl;
        SoTRange.GeoDate geo;
        SoTRange.Time tgeo;
        SoTRange range;
        Domain domain = new Domain();
        if (std.isXTime()) {
            range = std.getXRange();
            if (range instanceof SoTRange.Time) {
                tgeo = (SoTRange.Time)range;
                domain.setXRange(new TimeRange(tgeo.start, tgeo.end));
            } else {
                geo = (SoTRange.GeoDate)range;
                domain.setXRange(new TimeRange(geo.start, geo.end));
            }
        } else {
            dbl = (SoTRange.Double)std.getXRange();
            domain.setXRange(new Range2D(dbl.start, dbl.end, dbl.delta));
        }
        if (std.isYTime()) {
            range = std.getYRange();
            if (range instanceof SoTRange.Time) {
                tgeo = (SoTRange.Time)range;
                domain.setYRange(new TimeRange(tgeo.start, tgeo.end));
            } else {
                geo = (SoTRange.GeoDate)range;
                domain.setYRange(new TimeRange(geo.start, geo.end));
            }
        } else {
            dbl = (SoTRange.Double)std.getYRange();
            domain.setYRange(new Range2D(dbl.start, dbl.end, dbl.delta));
        }
        domain.setXReversed(std.isXReversed());
        domain.setYReversed(std.isYReversed());
        this.setRange(domain);
    }

    @Override
    public void setRange(Domain domain) throws PropertyVetoException {
        Domain oldRange = this.getRange();
        if (!domain.equals(oldRange)) {
            boolean batch = this.isBatch();
            this.setBatch(true, "JPlotLayout: setRange");
            this.vetos_.fireVetoableChange("domainRange", oldRange, domain);
            this.inZoom_ = true;
            if (!domain.isXTime()) {
                this.setXRange(domain.getXRange());
            } else {
                this.setXRange(domain.getTimeRange());
            }
            if (!domain.isYTime()) {
                this.setYRange(domain.getYRange(), domain.isYReversed());
            } else {
                this.setYRange(domain.getTimeRange());
            }
            this.changes_.firePropertyChange("domainRange", oldRange, domain);
            if (!batch) {
                this.setBatch(false, "JPlotLayout: setRange");
            }
            this.updateCoastLine();
        }
    }

    public void setRangeNoVeto(Domain domain) {
        boolean batch = this.isBatch();
        this.setBatch(true, "JPlotLayout: setRangeNoVeto");
        this.inZoom_ = true;
        this.setClipping(true);
        if (!domain.isXTime()) {
            this.setXRange(domain.getXRange());
        } else {
            this.setXRange(domain.getTimeRange());
        }
        if (!domain.isYTime()) {
            this.setYRange(domain.getYRange(), domain.isYReversed());
        } else {
            this.setYRange(domain.getTimeRange());
        }
        if (!batch) {
            this.setBatch(false, "JPlotLayout: setRangeNoVeto");
        }
        this.updateCoastLine();
    }

    void setXRange(TimeRange trnge) {
        SoTRange.Time xr = new SoTRange.Time(trnge);
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        xt.setRangeU(xr);
        try {
            Axis bottom = graph.getXAxis(BOTTOM_AXIS);
            Axis left = graph.getYAxis(LEFT_AXIS);
            bottom.setRangeU(xr);
            SoTRange yr = left.getSoTRangeU();
            SoTPoint origin = new SoTPoint(((SoTRange)xr).getStart(), yr.getStart());
            bottom.setLocationU(origin);
            left.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr, yr);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    public void setXRange(Range2D rnge) {
        SoTRange xnRange;
        SoTRange xr = new SoTRange.Double(rnge);
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        if (this.autoRangeX_) {
            xnRange = Graph.computeRange(xr, this.autoXIntervals_);
        } else {
            xnRange = xr;
            xnRange.delta = ((SoTRange.Double)Graph.computeRange((SoTRange)xr, (int)this.autoXIntervals_)).delta;
        }
        xt.setRangeU(xnRange);
        try {
            Axis bottom = graph.getXAxis(BOTTOM_AXIS);
            Axis left = graph.getYAxis(LEFT_AXIS);
            SoTRange yr = left.getSoTRangeU();
            bottom.setRangeU(xnRange);
            xr = bottom.getSoTRangeU();
            SoTPoint origin = new SoTPoint(xr.getStart(), yr.getStart());
            bottom.setLocationU(origin);
            left.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr, yr);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    void setYRange(TimeRange trnge) {
        SoTRange.Time yr = new SoTRange.Time(trnge);
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        yt.setRangeU(yr);
        try {
            Axis bottom = graph.getXAxis(BOTTOM_AXIS);
            Axis left = graph.getYAxis(LEFT_AXIS);
            left.setRangeU(yr);
            SoTRange xr = bottom.getSoTRangeU();
            SoTPoint origin = new SoTPoint(xr.getStart(), ((SoTRange)yr).getStart());
            left.setLocationU(origin);
            bottom.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr, yr);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    public void setYRange(Range2D rnge) {
        this.setYRange(rnge, true);
    }

    void setYRange(Range2D rnge, boolean reversed) {
        SoTRange ynRange;
        SoTRange yr = new SoTRange.Double(rnge);
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        if (!this.data_.isEmpty()) {
            SGTData grid = (SGTData)this.data_.elements().nextElement();
            if (this.data_.size() > 0 && reversed != grid.getYMetaData().isReversed()) {
                yr.flipStartAndEnd();
            }
        }
        if (this.autoRangeY_) {
            ynRange = Graph.computeRange(yr, this.autoYIntervals_);
        } else {
            ynRange = yr;
            ynRange.delta = ((SoTRange.Double)Graph.computeRange((SoTRange)yr, (int)this.autoYIntervals_)).delta;
        }
        yt.setRangeU(ynRange);
        try {
            Axis bottom = graph.getXAxis(BOTTOM_AXIS);
            Axis left = graph.getYAxis(LEFT_AXIS);
            SoTRange xr = bottom.getSoTRangeU();
            left.setRangeU(ynRange);
            yr = left.getSoTRangeU();
            SoTPoint origin = new SoTPoint(xr.getStart(), yr.getStart());
            left.setLocationU(origin);
            bottom.setLocationU(origin);
            if (this.clipping_) {
                this.setAllClip(xr, yr);
            } else {
                this.setAllClipping(false);
            }
        }
        catch (AxisNotFoundException axisNotFoundException) {
            // empty catch block
        }
    }

    public SGTData getData(String data_id) {
        try {
            CartesianRenderer rend;
            Layer ly = this.getLayerFromDataId(data_id);
            if (ly != null && (rend = ((CartesianGraph)ly.getGraph()).getRenderer()) != null) {
                if (rend instanceof LineCartesianRenderer) {
                    return ((LineCartesianRenderer)rend).getLine();
                }
                if (rend instanceof GridCartesianRenderer) {
                    return ((GridCartesianRenderer)rend).getGrid();
                }
            }
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public SGTData getData(CartesianRenderer rend) {
        if (rend instanceof LineCartesianRenderer) {
            return ((LineCartesianRenderer)rend).getLine();
        }
        if (rend instanceof GridCartesianRenderer) {
            return ((GridCartesianRenderer)rend).getGrid();
        }
        return null;
    }

    public void clear() {
        this.data_.removeAllElements();
        ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
        this.removeAll();
        this.add((Component)this.firstLayer_, 0);
        if (this.coastLine_ != null) {
            this.add((Component)this.coastLayer_, 0);
        }
        if (this.lineKey_ != null) {
            this.lineKey_.clearAll();
        }
        if (this.pointKey_ != null) {
            this.pointKey_.clearAll();
        }
        this.inZoom_ = false;
    }

    public void clear(String data_id) {
        Layer ly = null;
        try {
            ly = this.getLayerFromDataId(data_id);
            this.remove(ly);
        }
        catch (LayerNotFoundException layerNotFoundException) {
            // empty catch block
        }
        Enumeration it = this.data_.elements();
        while (it.hasMoreElements()) {
            SGTData dat = (SGTData)it.nextElement();
            if (!dat.getId().equals(data_id)) continue;
            this.data_.removeElement(dat);
        }
        if (this.lineKey_ != null) {
            this.lineKey_.clear(data_id);
        }
        if (this.pointKey_ != null) {
            this.pointKey_.clear(data_id);
        }
        if (this.getComponentCount() <= 0 || ly.equals(this.firstLayer_)) {
            ((CartesianGraph)this.firstLayer_.getGraph()).setRenderer(null);
            this.add((Component)this.firstLayer_, 0);
        }
    }

    public Dimension2D getLayerSizeP() {
        return new Dimension2D(this.xSize_, this.ySize_);
    }

    @Override
    public Layer getFirstLayer() {
        return this.firstLayer_;
    }

    public void setAxesOriginP(Point2D.Double pt) {
        this.xMin_ = pt.x;
        this.yMin_ = pt.y;
    }

    public SoTDomain getGraphDomain() {
        SoTRange xRange = null;
        SoTRange yRange = null;
        CartesianGraph graph = null;
        try {
            Layer layer = this.getLayer("Layer 1");
            graph = (CartesianGraph)layer.getGraph();
        }
        catch (LayerNotFoundException e) {
            return null;
        }
        try {
            Axis bottom = graph.getXAxis(BOTTOM_AXIS);
            Axis left = graph.getYAxis(LEFT_AXIS);
            xRange = bottom.getSoTRangeU();
            yRange = left.getSoTRangeU();
        }
        catch (AxisNotFoundException e) {
            return null;
        }
        return new SoTDomain(xRange, yRange);
    }

    public void setLayerSizeP(Dimension2D d) {
        double xpos;
        Component[] comps = this.getComponents();
        CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
        LinearTransform yt = (LinearTransform)graph.getYTransform();
        LinearTransform xt = (LinearTransform)graph.getXTransform();
        this.xMax_ = d.width - (this.xSize_ - this.xMax_);
        this.yMax_ = d.height - (this.ySize_ - this.yMax_);
        this.xSize_ = d.width;
        this.ySize_ = d.height;
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            ((Layer)comps[i]).setSizeP(d);
        }
        yt.setRangeP(new Range2D(this.yMin_, this.yMax_));
        xt.setRangeP(new Range2D(this.xMin_, this.xMax_));
        if (this.iconImage_ != null) {
            Rectangle bnds = this.logo_.getBounds();
            xpos = this.firstLayer_.getXDtoP(bnds.x + bnds.width) + 0.05;
        } else {
            xpos = (this.xMin_ + this.xMax_) * 0.5;
        }
        double ypos = this.ySize_ - 1.0 * this.mainTitleHeight_;
        this.mainTitle_.setLocationP(new Point2D.Double(xpos, ypos));
        this.title2_.setLocationP(new Point2D.Double(xpos, ypos -= 1.0 * this.warnHeight_));
        this.title3_.setLocationP(new Point2D.Double(xpos, ypos -= 1.0 * this.warnHeight_));
    }

    public void setTitleHeightP(double main, double second) {
        double ypos = this.ySize_ - 1.0 * main;
        double xpos = this.mainTitle_.getLocationP().x;
        boolean batch = this.isBatch();
        this.setBatch(true, "JPlotLayout: setTitleHeightP");
        if (main != this.mainTitleHeight_) {
            this.mainTitleHeight_ = main;
            this.mainTitle_.setHeightP(main);
            this.mainTitle_.setLocationP(new Point2D.Double(xpos, ypos));
        }
        if (second != this.warnHeight_) {
            this.warnHeight_ = second;
            this.title2_.setHeightP(second);
            this.title2_.setLocationP(new Point2D.Double(xpos, ypos -= 1.0 * second));
            this.title3_.setHeightP(second);
            this.title3_.setLocationP(new Point2D.Double(xpos, ypos -= 1.0 * this.warnHeight_));
        }
        if (!batch) {
            this.setBatch(false, "JPlotLayout: setTitleHeightP");
        }
    }

    public double getMainTitleHeightP() {
        return this.mainTitleHeight_;
    }

    public double getSecondaryTitleHeightP() {
        return this.warnHeight_;
    }

    @Override
    public void setKeyBoundsP(Rectangle2D.Double bounds) {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            this.colorKey_.setBoundsP(bounds);
        } else if (this.plotType_ == 0 && this.pointKey_ != null) {
            this.pointKey_.setBoundsP(bounds);
        } else if (this.plotType_ == 1 && this.lineKey_ != null) {
            this.lineKey_.setBoundsP(bounds);
        } else if (this.plotType_ == 3 && this.vectorKey_ != null) {
            this.vectorKey_.setBoundsP(bounds);
        }
    }

    @Override
    public Rectangle2D.Double getKeyBoundsP() {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            return this.colorKey_.getBoundsP();
        }
        if (this.plotType_ == 0 && this.pointKey_ != null) {
            return this.pointKey_.getBoundsP();
        }
        if (this.plotType_ == 1 && this.lineKey_ != null) {
            return this.lineKey_.getBoundsP();
        }
        if (this.plotType_ == 3 && this.vectorKey_ != null) {
            return this.vectorKey_.getBoundsP();
        }
        return null;
    }

    public void setKeyAlignment(int vert, int horz) {
        if (this.plotType_ == 2 && this.colorKey_ != null) {
            this.colorKey_.setAlign(vert, horz);
        } else if (this.plotType_ == 0 && this.pointKey_ != null) {
            this.pointKey_.setAlign(vert, horz);
        } else if (this.plotType_ == 1 && this.lineKey_ != null) {
            this.lineKey_.setAlign(vert, horz);
        } else if (this.plotType_ == 3 && this.vectorKey_ != null) {
            this.vectorKey_.setAlign(vert, horz);
        }
    }

    public ColorKey getColorBar() {
        return this.colorKey_;
    }

    public void setColorBar(ColorKey colorKey_) {
        this.colorKey_ = colorKey_;
    }

    public Point2D.Double getKeyPositionP() {
        Rectangle2D.Double bnds = this.getKeyBoundsP();
        double xp = bnds.x;
        double yp = bnds.y;
        return new Point2D.Double(xp, yp);
    }

    public void setKeyLocationP(Point2D.Double loc) {
        if (this.keyPane_ == null) {
            if (this.plotType_ == 2) {
                this.colorKey_.setLocationP(loc);
            } else if (this.plotType_ == 0) {
                this.pointKey_.setLocationP(loc);
            } else if (this.plotType_ == 1) {
                this.lineKey_.setLocationP(loc);
            } else if (this.plotType_ == 3) {
                this.vectorKey_.setLocationP(loc);
            }
        }
    }

    private void resetAxes() {
        Domain domain = this.getRange();
        if (domain.isXTime()) {
            this.setXRange(domain.getTimeRange());
        } else {
            this.setXRange(domain.getXRange());
        }
        if (domain.isYTime()) {
            this.setYRange(domain.getTimeRange());
        } else {
            this.setYRange(domain.getYRange());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof GridAttribute && evt.getPropertyName() == "style" && this.plotType_ == 2) {
            SGTGrid grid = (SGTGrid)this.data_.firstElement();
            try {
                GridAttribute gridAttr = (GridAttribute)this.getAttribute(grid);
                Range2D vRange = this.findRange(grid, gridAttr, 3);
                if (gridAttr.isRaster()) {
                    ColorMap cmap = gridAttr.getColorMap();
                    if (cmap instanceof TransformAccess) {
                        ((TransformAccess)((Object)cmap)).setRange(vRange);
                    }
                    this.colorKey_.setColorMap(cmap);
                    this.colorKey_.setVisible(true);
                } else {
                    this.colorKey_.setVisible(false);
                }
            }
            catch (DataNotFoundException e) {
                System.out.println(e);
            }
            if (this.keyPane_ != null) {
                this.keyPane_.setModified(true, "JPlotLayout: forced setModified");
                this.keyPane_.setBatch(false, "JPlotLayout: propertyChange");
            }
        }
        if (evt.getSource() instanceof Attribute) {
            boolean local = true;
            if (evt instanceof AttributeChangeEvent) {
                local = ((AttributeChangeEvent)evt).isLocal();
            }
            this.changes_.firePropertyChange(new AttributeChangeEvent(this, "attribute", null, evt.getSource(), local));
        }
    }

    public void setCoastLine(SGTLine coast) {
        if (this.coastLine_ == null) {
            CartesianGraph graph = (CartesianGraph)this.firstLayer_.getGraph();
            LinearTransform xt = (LinearTransform)graph.getXTransform();
            LinearTransform yt = (LinearTransform)graph.getYTransform();
            Range2D xrange = xt.getRangeU();
            Range2D yrange = yt.getRangeU();
            this.coastLayer_ = new Layer("CoastLine", new Dimension2D(this.xSize_, this.ySize_));
            this.add((Component)this.coastLayer_, 0);
            this.coastLine_ = new CartesianGraph("CoastLine Graph");
            this.coastLayer_.setGraph(this.coastLine_);
            this.coastLine_.setXTransform(xt);
            this.coastLine_.setYTransform(yt);
            LineAttribute lattr = new LineAttribute();
            lattr.setColor(new Color(244, 164, 96));
            lattr.addPropertyChangeListener(this);
            this.coastLine_.setData(coast, lattr);
            this.coastLine_.setClip(xrange.start, xrange.end, yrange.start, yrange.end);
            this.coastLine_.setClipping(true);
            this.coastLayer_.invalidate();
            this.validate();
        }
    }

    void updateCoastLine() {
        if (this.coastLine_ != null) {
            CartesianGraph graph = (CartesianGraph)this.coastLayer_.getGraph();
            LinearTransform xt = (LinearTransform)graph.getXTransform();
            LinearTransform yt = (LinearTransform)graph.getYTransform();
            Range2D xrange = xt.getRangeU();
            Range2D yrange = yt.getRangeU();
            this.coastLine_.setClip(xrange.start, xrange.end, yrange.start, yrange.end);
            this.coastLine_.setClipping(true);
            this.coastLayer_.invalidate();
            this.validate();
        }
    }

    public int print(VectorGraphics g2, PageFormat pf, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        this.drawPage(g2, pf);
        if (this.keyPane_ != null) {
            g2.setTransform(new AffineTransform());
            Point pt = this.keyPane_.getLocation();
            double scale = 72.0;
            double margin = 0.5;
            int layoutHeight = (int)((this.getLayerSizeP().getHeight() + margin) * scale) - pt.y;
            int xoff = -pt.x;
            Point offset = new Point(xoff, layoutHeight);
            this.keyPane_.setPageOrigin(offset);
            this.keyPane_.setPageVAlign(-1);
            this.keyPane_.setPageHAlign(1);
            g2.setClip(-1000, -1000, 5000, 5000);
            this.keyPane_.drawPage(g2, pf, true);
        }
        return 0;
    }

    public void setXAutoRange(boolean xauto) {
        this.autoRangeX_ = xauto;
    }

    public void setYAutoRange(boolean yauto) {
        this.autoRangeY_ = yauto;
    }

    public void setAutoRange(boolean xauto, boolean yauto) {
        this.autoRangeX_ = xauto;
        this.autoRangeY_ = yauto;
    }

    public Axis getAxis(int i) {
        if (this.isXTime_) {
            if (i == 0) {
                return this.tbot;
            }
        } else if (i == 0) {
            return this.xbot;
        }
        if (this.isYTime_) {
            if (i == 1) {
                return this.tleft;
            }
        } else if (i == 1) {
            return this.yleft;
        }
        return this.xbot;
    }

    public void setAxis(int i, Axis axis) {
        if (this.isXTime_) {
            if (i == 0) {
                this.xbot = (PlainAxis)axis;
            }
        } else if (i == 0) {
            this.tbot = (TimeAxis)axis;
        }
        if (this.isYTime_) {
            if (i == 1) {
                this.yleft = (PlainAxis)axis;
            }
        } else if (i == 1) {
            this.tleft = (TimeAxis)axis;
        }
    }

    public boolean isXAutoRange() {
        return this.autoRangeX_;
    }

    public boolean isYAutoRange() {
        return this.autoRangeY_;
    }

    public void setXAutoIntervals(int xint) {
        this.autoXIntervals_ = xint;
    }

    public void setYAutoIntervals(int yint) {
        this.autoYIntervals_ = yint;
    }

    public void setAutoIntervals(int xint, int yint) {
        this.autoXIntervals_ = xint;
        this.autoYIntervals_ = yint;
    }

    public int getXAutoIntervals() {
        return this.autoXIntervals_;
    }

    public int getYAutoIntervals() {
        return this.autoYIntervals_;
    }

    @Override
    public void init() {
        if (this.computeScroll_) {
            this.computeScroll_ = false;
            int rowHeight = 1;
            if (this.plotType_ != 2) {
                if (this.plotType_ == 0) {
                    if (this.keyPane_ != null) {
                        Rectangle vRect = this.keyPane_.getVisibleRect();
                        rowHeight = this.pointKey_.getRowHeight();
                        int nrow = vRect.height / rowHeight;
                        this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                        this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                    }
                } else if (this.plotType_ == 1) {
                    if (this.keyPane_ != null) {
                        Rectangle vRect = this.keyPane_.getVisibleRect();
                        rowHeight = this.lineKey_.getRowHeight();
                        int nrow = vRect.height / rowHeight;
                        this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                        this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                    }
                } else if (this.plotType_ == 3 && this.keyPane_ != null) {
                    Rectangle vRect = this.keyPane_.getVisibleRect();
                    rowHeight = this.vectorKey_.getRowHeight();
                    int nrow = vRect.height / rowHeight;
                    this.keyPane_.setScrollableUnitIncrement(1, rowHeight);
                    this.keyPane_.setScrollableBlockIncrement(vRect.width, rowHeight * nrow);
                }
            }
        }
    }
}

