/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.contour;

import sgtplot.dm.SGTGrid;

class GridFlag {
    public static final int LESS_THAN_ZC = -1;
    public static final int MISSING = 10;
    public static final int GREATER_THAN_ZC = 1;
    private double[] array_;
    private double[] mask_ = null;
    private byte[] value_;
    private int nx_;
    private int ny_;

    public GridFlag(SGTGrid grid, double zc) {
        this(grid, null, zc);
    }

    public GridFlag(SGTGrid grid, SGTGrid mask, double zc) {
        this.nx_ = grid.isXTime() ? grid.getTSize() : grid.getXSize();
        this.ny_ = grid.isYTime() ? grid.getTSize() : grid.getYSize();
        this.value_ = new byte[this.nx_ * this.ny_];
        this.array_ = grid.getZArray();
        this.setLevel(zc);
        if (mask != null) {
            this.setMask(mask);
        }
    }

    public void setMask(SGTGrid mask) {
        this.mask_ = mask.getZArray();
        this.applyMask();
    }

    void applyMask() {
        if (this.mask_ == null) {
            return;
        }
        for (int i = 0; i < this.nx_ * this.ny_; ++i) {
            if (!Double.isNaN(this.mask_[i]) && this.mask_[i] == 0.0) continue;
            this.value_[i] = 10;
        }
    }

    public void setLevel(double zc) {
        for (int i = 0; i < this.nx_ * this.ny_; ++i) {
            if (!Double.isNaN(this.array_[i])) {
                if (this.array_[i] <= zc) {
                    this.value_[i] = -1;
                    continue;
                }
                this.value_[i] = 1;
                continue;
            }
            this.value_[i] = 10;
        }
        this.applyMask();
    }

    int index(int i, int j) {
        return j + this.ny_ * i;
    }

    public boolean isMissing(int i, int j) {
        int ind = this.index(i, j);
        return this.value_[ind] == 10;
    }

    public boolean isGreater(int i, int j) {
        int ind = this.index(i, j);
        return this.value_[ind] == 1;
    }

    public int getValue(int i, int j) {
        int ind = this.index(i, j);
        return this.value_[ind];
    }
}

