/*
 * Decompiled with CFR 0.152.
 */
package sgtplot.beans;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.beans.AxisHolderDragBox;
import sgtplot.beans.DataGroup;
import sgtplot.beans.DataGroupDragBox;
import sgtplot.beans.DragBox;
import sgtplot.beans.Label;
import sgtplot.beans.LabelDragBox;
import sgtplot.beans.Legend;
import sgtplot.beans.LegendDragBox;
import sgtplot.beans.PanelHolder;

class PanelHolderDragBox
extends DragBox
implements ChangeListener {
    private List dragBox_ = new Vector();
    private boolean ignoreStateChange_ = true;

    public PanelHolderDragBox(PanelHolder ph) {
        super(ph);
        this.pHolder_.addChangeListener(this);
        Iterator iter = this.pHolder_.dataGroupIterator();
        while (iter.hasNext()) {
            DataGroup dg = (DataGroup)iter.next();
            DataGroupDragBox agdb = new DataGroupDragBox(dg, this.pHolder_);
            AxisHolderDragBox xAxdb = new AxisHolderDragBox(dg.getXAxisHolder(), dg, this.pHolder_);
            AxisHolderDragBox yAxdb = new AxisHolderDragBox(dg.getYAxisHolder(), dg, this.pHolder_);
            this.dragBox_.add(xAxdb);
            this.dragBox_.add(yAxdb);
            this.dragBox_.add(agdb);
        }
        iter = this.pHolder_.labelIterator();
        while (iter.hasNext()) {
            LabelDragBox ldb = new LabelDragBox((Label)iter.next(), this.pHolder_);
            this.dragBox_.add(ldb);
        }
        iter = this.pHolder_.legendIterator();
        while (iter.hasNext()) {
            LegendDragBox lgdb = new LegendDragBox((Legend)iter.next(), this.pHolder_);
            this.dragBox_.add(lgdb);
        }
        for (int i = 0; i < this.handles_.length; ++i) {
            this.handles_[i] = new Rectangle(0, 0, 0, 0);
        }
        this.ignoreStateChange_ = false;
        this.computeHandles();
    }

    public PanelHolder getPanelHolder() {
        return this.pHolder_;
    }

    public DragBox[] getDragBoxArray() {
        DragBox[] dba = new DragBox[1];
        return this.dragBox_.toArray(dba);
    }

    public Iterator getDragBoxIterator() {
        return this.dragBox_.iterator();
    }

    @Override
    public void setSelected(boolean sel) {
        super.setSelected(sel);
        if (!this.selected_) {
            Iterator iter = this.dragBox_.iterator();
            while (iter.hasNext()) {
                ((DragBox)iter.next()).setSelected(sel);
            }
        }
    }

    @Override
    public void update(String message) {
        this.computeHandles();
        Iterator iter = this.dragBox_.iterator();
        while (iter.hasNext()) {
            ((DragBox)iter.next()).update(message);
        }
    }

    @Override
    public void draw(Graphics g) {
        VectorGraphics g2 = VectorGraphics.create((Graphics)g);
        Color saved = g2.getColor();
        Rectangle bounds = this.pHolder_.getBounds();
        if (!this.pHolder_.isUsePageBackground()) {
            g2.setColor(this.pHolder_.getBackground());
            g2.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        g2.setColor(Color.darkGray);
        g2.drawString(this.pHolder_.getId(), bounds.x + 10, bounds.y + 12);
        g2.drawString("[" + bounds.width + "x" + bounds.height + "]", bounds.x + 10, bounds.y + 22);
        g2.setColor(this.color_);
        if (this.pHolder_.isVisible()) {
            g2.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        }
        if (this.selected_) {
            for (int i = 0; i < this.handles_.length; ++i) {
                Rectangle r = this.handles_[i];
                g2.fillRect(r.x, r.y, r.width - 1, r.height - 1);
            }
        }
        if (this.pHolder_.isVisible()) {
            Iterator iter = this.dragBox_.iterator();
            while (iter.hasNext()) {
                ((DragBox)iter.next()).draw(g);
            }
        }
        g.setColor(saved);
    }

    @Override
    public String getId() {
        return this.pHolder_.getId();
    }

    @Override
    public void setId(String id) {
        this.pHolder_.setId(id);
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this.ignoreStateChange_ = true;
        this.pHolder_.setBounds(bounds);
        this.update("PanelDragBox.setBounds()");
        this.ignoreStateChange_ = false;
    }

    @Override
    public Rectangle getBounds() {
        return this.pHolder_.getBounds();
    }

    @Override
    public void setLocation(Point pt) {
        this.setLocation(pt.x, pt.y);
    }

    public void setLocation(int x, int y) {
        Rectangle bounds = this.pHolder_.getBounds();
        bounds.x = x;
        bounds.y = y;
        this.ignoreStateChange_ = true;
        this.pHolder_.setBounds(bounds);
        this.update("PanelDragBox.setLocation()");
        this.ignoreStateChange_ = false;
    }

    @Override
    public Point getLocation() {
        Rectangle bounds = this.pHolder_.getBounds();
        return new Point(bounds.x, bounds.y);
    }

    public void addDragBox(DataGroup ag) {
        DataGroupDragBox agdb = new DataGroupDragBox(ag, this.pHolder_);
        AxisHolderDragBox xAxdb = new AxisHolderDragBox(ag.getXAxisHolder(), ag, this.pHolder_);
        AxisHolderDragBox yAxdb = new AxisHolderDragBox(ag.getYAxisHolder(), ag, this.pHolder_);
        agdb.setAxisHolderDB(xAxdb, yAxdb);
        this.dragBox_.add(xAxdb);
        this.dragBox_.add(yAxdb);
        this.dragBox_.add(agdb);
    }

    public void addDragBox(Legend legend) {
        LegendDragBox ldb = new LegendDragBox(legend, this.pHolder_);
        this.dragBox_.add(ldb);
    }

    public void addDragBox(Label label) {
        LabelDragBox lbdb = new LabelDragBox(label, this.pHolder_);
        this.dragBox_.add(lbdb);
    }

    public void removeDragBox(DataGroupDragBox ag) {
        this.dragBox_.remove(ag.getXAxisHolderDB());
        this.dragBox_.remove(ag.getYAxisHolderDB());
        this.dragBox_.remove(ag);
        this.update("PanelDragBox.removeDragBox(DataGroupDragBox)");
    }

    public void removeDragBox(LegendDragBox legend) {
        this.dragBox_.remove(legend);
        this.update("PanelDragBox.removeDragBox(LegendDragBox)");
    }

    public void removeDragBox(LabelDragBox label) {
        this.dragBox_.remove(label);
        this.update("PanelDragBox.removeDragBox(LabelDragBox)");
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.ignoreStateChange_) {
            return;
        }
        this.update("PanelDragBox.stateChanged");
    }
}

