/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.CartesianRenderer;
import sgtplot.DataKey;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.MethodNotImplementedError;
import sgtplot.Moveable;
import sgtplot.SGException;
import sgtplot.SGLabel;
import sgtplot.VectorAttribute;
import sgtplot.VectorCartesianRenderer;
import sgtplot.util.Point2D;
import sgtplot.util.Rectangle2D;

public class VectorKey
implements Cloneable,
DataKey,
Moveable,
PropertyChangeListener {
    private String ident_;
    private Layer layer_;
    private Vector vectors_;
    private Vector label_;
    private Vector scaleLabel_;
    private int columns_;
    private int style_;
    private int valign_;
    private int halign_;
    private Point2D.Double porigin_;
    private double vectorLengthP_;
    private int maxLabelLength_;
    private int maxLabelHeight_;
    private int maxScaleLength_;
    private String floatScaleFormat_ = "###.##";
    private String expScaleFormat_ = "0.####E0";
    private DecimalFormat floatFormat_;
    private DecimalFormat expFormat_;
    private float xoff_;
    private float yoff_;
    private float slope_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final int VERTICAL_BORDER_ = 3;
    private static final int HORIZONTAL_BORDER_ = 15;
    private static final int COLUMN_SPACE_ = 10;
    private static final int ROW_SPACE_ = 3;
    private static final int LABEL_SPACE_ = 10;
    private static final int SCALE_SPACE_ = 7;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public VectorKey() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public VectorKey(Point2D.Double loc, int valign, int halign) {
        this.porigin_ = loc;
        this.valign_ = valign;
        this.halign_ = halign;
        this.vectors_ = new Vector(2, 2);
        this.label_ = new Vector(2, 2);
        this.scaleLabel_ = new Vector(2, 2);
        this.style_ = 0;
        this.columns_ = 1;
        this.ident_ = "";
        this.vectorLengthP_ = 0.3f;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
        this.floatFormat_ = new DecimalFormat(this.floatScaleFormat_);
        this.expFormat_ = new DecimalFormat(this.expScaleFormat_);
    }

    @Override
    public LayerChild copy() {
        VectorKey newKey;
        try {
            newKey = (VectorKey)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newKey = new VectorKey();
        }
        newKey.vectors_ = new Vector(2, 2);
        newKey.label_ = new Vector(2, 2);
        return newKey;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public boolean isMoveable() {
        return this.moveable_;
    }

    @Override
    public void setMoveable(boolean moveable) {
        this.moveable_ = moveable;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    public void setVectorLengthP(double len) {
        if (this.vectorLengthP_ != len) {
            this.vectorLengthP_ = len;
            this.modified("VectorKey: setVectorLengthP()");
        }
    }

    @Override
    public void setLineLengthP(double len) {
        this.setVectorLengthP(len);
    }

    public double getVectorLengthP() {
        return this.vectorLengthP_;
    }

    @Override
    public void setColumns(int col) {
        if (this.columns_ != col) {
            this.columns_ = col;
            this.modified("VectorKey: setColumms()");
        }
    }

    public int getColumns() {
        return this.columns_;
    }

    @Override
    public void setBorderStyle(int style) {
        if (this.style_ != style) {
            this.style_ = style;
            this.modified("VectorKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    @Override
    public void setAlign(int vert, int horz) {
        if (this.valign_ != vert || this.halign_ != horz) {
            this.valign_ = vert;
            this.halign_ = horz;
            this.modified("VectorKey: setAlign()");
        }
    }

    @Override
    public void setVAlign(int vert) {
        if (this.valign_ != vert) {
            this.valign_ = vert;
            this.modified("VectorKey: setVAlign()");
        }
    }

    @Override
    public void setHAlign(int horz) {
        if (this.halign_ != horz) {
            this.halign_ = horz;
            this.modified("VectorKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    @Override
    public void setLocationP(Point2D.Double loc) {
        if (this.porigin_ == null || !this.porigin_.equals(loc)) {
            Point2D.Double temp = this.porigin_;
            this.porigin_ = loc;
            this.changes_.firePropertyChange("location", temp, this.porigin_);
            this.modified("VectorKey: setLocationP()");
        }
    }

    @Override
    public void setBoundsP(Rectangle2D.Double r) {
        this.setLocationP(new Point2D.Double(r.x, r.y));
    }

    public Rectangle2D.Double getBoundsP() {
        throw new MethodNotImplementedError();
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public void addVectorGraph(VectorCartesianRenderer vector, SGLabel label) {
        this.vectors_.addElement(vector);
        label.setLayer(this.layer_);
        label.setMoveable(false);
        label.setSelectable(false);
        this.label_.addElement(label);
        SGLabel scale = new SGLabel("scale label", " ", label.getHeightP(), label.getLocationP(), label.getVAlign(), label.getHAlign());
        scale.setFont(label.getFont());
        scale.setLayer(label.getLayer());
        scale.setMoveable(false);
        scale.setSelectable(false);
        this.scaleLabel_.addElement(scale);
        ((VectorAttribute)vector.getAttribute()).addPropertyChangeListener(this);
        this.modified("VectorKey: addVectorGraph()");
    }

    @Override
    public void addGraph(CartesianRenderer rend, SGLabel label) throws IllegalArgumentException {
        if (!(rend instanceof VectorCartesianRenderer)) {
            throw new IllegalArgumentException("Renderer is not a VectorCartesianRenderer");
        }
        this.addVectorGraph((VectorCartesianRenderer)rend, label);
    }

    public void removeVectorGraph(SGLabel label) {
    }

    public void removeVectorRenderer(VectorCartesianRenderer line) {
    }

    public void removeVectorGraph(String ident) {
    }

    public void clearAll() {
        Enumeration e = this.vectors_.elements();
        while (e.hasMoreElements()) {
            VectorAttribute attr = (VectorAttribute)((VectorCartesianRenderer)e.nextElement()).getAttribute();
            attr.removePropertyChangeListener(this);
        }
        this.vectors_.removeAllElements();
        this.label_.removeAllElements();
        this.modified("VectorKey: clearAll()");
    }

    public void clear(String data_id) {
        int indx = -1;
        Enumeration it = this.vectors_.elements();
        while (it.hasMoreElements()) {
            ++indx;
            VectorCartesianRenderer vcr = (VectorCartesianRenderer)it.nextElement();
        }
    }

    public int getRowHeight() {
        Rectangle bounds = this.getBounds();
        return 3 + this.maxLabelHeight_;
    }

    @Override
    public void draw(VectorGraphics g) {
        int i;
        VectorCartesianRenderer render = null;
        VectorAttribute attr = null;
        VectorGraphics g2 = VectorGraphics.create((Graphics)g);
        Stroke savedStroke = g2.getStroke();
        this.slope_ = (float)this.layer_.getXSlope();
        this.xoff_ = (float)this.layer_.getXOffset();
        this.yoff_ = (float)this.layer_.getYOffset();
        int numLines = this.vectors_.size();
        if (numLines <= 0 || !this.visible_) {
            return;
        }
        int numRows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++numRows;
        }
        double[] xp = new double[this.columns_];
        int[] xd = new int[this.columns_];
        double[] yp = new double[numRows];
        int[] yd = new int[numRows];
        int[] xout = new int[2];
        int[] yout = new int[2];
        g.setColor(this.layer_.getPane().getComponent().getForeground());
        Rectangle bounds = this.getBounds();
        float vectorLength = this.xPtoD((float)this.vectorLengthP_) - this.xPtoD(0.0f);
        double labelSpace = this.layer_.getXDtoP(10) - this.layer_.getXDtoP(0);
        double scaleLength = this.layer_.getXDtoP(this.maxScaleLength_) - this.layer_.getXDtoP(0);
        double scaleSpace = this.layer_.getXDtoP(7) - this.layer_.getXDtoP(0);
        yd[0] = bounds.y + 3 + this.maxLabelHeight_;
        yp[0] = this.layer_.getYDtoP(yd[0]);
        for (i = 1; i < numRows; ++i) {
            yd[i] = yd[i - 1] + 3 + this.maxLabelHeight_;
            yp[i] = this.layer_.getYDtoP(yd[i]);
        }
        xd[0] = bounds.x + 15;
        xp[0] = this.layer_.getXDtoP(xd[0]);
        for (i = 1; i < this.columns_; ++i) {
            xd[i] = xd[i - 1] + 10 + (int)vectorLength + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_;
            xp[i] = this.layer_.getXDtoP(xd[i]);
        }
        int row = 0;
        int col = 0;
        Enumeration labelIt = this.label_.elements();
        Enumeration scaleIt = this.scaleLabel_.elements();
        Enumeration lineIt = this.vectors_.elements();
        while (lineIt.hasMoreElements()) {
            Object obj = lineIt.nextElement();
            render = (VectorCartesianRenderer)obj;
            attr = (VectorAttribute)render.getAttribute();
            SGLabel label = (SGLabel)labelIt.nextElement();
            SGLabel scaleLabel = (SGLabel)scaleIt.nextElement();
            g2.setColor(attr.getVectorColor());
            BasicStroke stroke = new BasicStroke(attr.getWidth(), attr.getCapStyle(), attr.getMiterStyle(), attr.getMiterLimit());
            float scale = (float)attr.getVectorScale();
            float headScale = (float)attr.getHeadScale() * 0.94386f;
            float fixedScale = (float)((double)headScale * attr.getHeadFixedSize());
            float minSize = (float)attr.getHeadMinSize();
            float maxSize = (float)attr.getHeadMaxSize();
            float vectorLengthU = (float)(this.vectorLengthP_ / (double)scale);
            g2.setStroke((Stroke)stroke);
            GeneralPath gp = new GeneralPath();
            float orgX = xd[col];
            float orgY = yd[row] - this.maxLabelHeight_ / 2;
            float headX = orgX + vectorLength;
            float headY = orgY;
            float xphead = this.xDtoP(headX);
            float yphead = this.yDtoP(headY);
            gp.moveTo(orgX, orgY);
            gp.lineTo(headX, headY);
            if ((double)vectorLength == 0.0) {
                g.drawLine((int)headX, (int)headY, (int)headX, (int)headY);
            } else if (attr.getVectorStyle() != 0) {
                float hy2;
                float hx2;
                float hy1;
                float hx1;
                float tScale;
                if (attr.getVectorStyle() == 1) {
                    tScale = fixedScale;
                    hx1 = this.xPtoD(xphead - tScale);
                    hy1 = this.yPtoD(yphead + 0.35f * tScale);
                    hx2 = this.xPtoD(xphead - tScale);
                    hy2 = this.yPtoD(yphead - 0.35f * tScale);
                    gp.moveTo(hx1, hy1);
                    gp.lineTo(headX, headY);
                    gp.lineTo(hx2, hy2);
                } else {
                    tScale = this.vectorLengthP_ >= (double)maxSize ? maxSize * headScale : (this.vectorLengthP_ <= (double)minSize ? minSize * headScale : (float)(this.vectorLengthP_ * (double)headScale));
                    hx1 = this.xPtoD(xphead - tScale);
                    hy1 = this.yPtoD(yphead + 0.35f * tScale);
                    hx2 = this.xPtoD(xphead - tScale);
                    hy2 = this.yPtoD(yphead - 0.35f * tScale);
                    gp.moveTo(hx1, hy1);
                    gp.lineTo(headX, headY);
                    gp.lineTo(hx2, hy2);
                }
            }
            g2.draw((Shape)gp);
            g2.setStroke(savedStroke);
            xout[0] = (int)orgX;
            yout[0] = (int)orgY;
            if (attr.getOriginStyle() == 1) {
                g.setColor(attr.getMarkColor());
                render.drawMark(g, xout, yout, 1, attr);
            }
            double xloc = xp[col] + this.vectorLengthP_ + scaleSpace;
            String scaleStr = (double)vectorLengthU > 1000.0 || (double)vectorLengthU < 0.01 ? this.expFormat_.format(vectorLengthU) : this.floatFormat_.format(vectorLengthU);
            scaleLabel.setText(scaleStr);
            scaleLabel.setLocationP(new Point2D.Double(xloc, yp[row]));
            xloc = xloc + scaleLength + labelSpace;
            label.setLocationP(new Point2D.Double(xloc, yp[row]));
            try {
                scaleLabel.draw(g);
                label.draw(g);
            }
            catch (SGException e) {
                System.out.println(e);
            }
            if (++col < this.columns_) continue;
            col = 0;
            ++row;
        }
        switch (this.style_) {
            case 0: {
                g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private float xPtoD(float xp) {
        return this.slope_ * xp + this.xoff_;
    }

    private float yPtoD(float yp) {
        return this.yoff_ - this.slope_ * yp;
    }

    private float xDtoP(float xd) {
        return (xd - this.xoff_) / this.slope_;
    }

    private float yDtoP(float yd) {
        return (this.yoff_ - yd) / this.slope_;
    }

    @Override
    public Rectangle getBounds() {
        int numLines = this.vectors_.size();
        if (numLines <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.maxLabelLength_ = 0;
        this.maxLabelHeight_ = 0;
        this.maxScaleLength_ = 0;
        Enumeration lineIt = this.vectors_.elements();
        Enumeration scaleIt = this.scaleLabel_.elements();
        Enumeration it = this.label_.elements();
        while (it.hasMoreElements()) {
            SGLabel label = (SGLabel)it.nextElement();
            Rectangle sz = label.getBounds();
            this.maxLabelLength_ = Math.max(this.maxLabelLength_, sz.width);
            this.maxLabelHeight_ = Math.max(this.maxLabelHeight_, sz.height);
            Object obj = lineIt.nextElement();
            VectorCartesianRenderer render = (VectorCartesianRenderer)obj;
            VectorAttribute attr = (VectorAttribute)render.getAttribute();
            double vectorLengthU = this.vectorLengthP_ / attr.getVectorScale();
            String scaleStr = vectorLengthU > 1000.0 || vectorLengthU < 0.01 ? this.expFormat_.format(vectorLengthU) : this.floatFormat_.format(vectorLengthU);
            SGLabel scaleLabel = (SGLabel)scaleIt.nextElement();
            scaleLabel.setText(scaleStr);
            sz = scaleLabel.getBounds();
            this.maxScaleLength_ = Math.max(this.maxScaleLength_, sz.width);
        }
        int rows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++rows;
        }
        int vectorLength = this.layer_.getXPtoD(this.vectorLengthP_) - this.layer_.getXPtoD(0.0);
        int width = 30 + this.columns_ * (vectorLength + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_) + (this.columns_ - 1) * 10;
        int height = 6 + rows * this.maxLabelHeight_ + (rows - 1) * 3;
        height += 5;
        int x = this.layer_.getXPtoD(this.porigin_.x);
        int y = this.layer_.getYPtoD(this.porigin_.y);
        switch (this.halign_) {
            case 2: {
                x -= width;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y -= height;
                break;
            }
            case 1: {
                y -= height / 2;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Point getLocation() {
        Rectangle bnds = this.getBounds();
        return new Point(bnds.x, bnds.y);
    }

    @Override
    public void setLocation(Point loc) {
        Rectangle bnds = this.getBounds();
        this.setBounds(loc.x, loc.y, bnds.width, bnds.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        switch (this.halign_) {
            case 2: {
                x += width;
                break;
            }
            case 1: {
                x += width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y += height;
                break;
            }
            case 1: {
                y += height / 2;
            }
        }
        double xp = this.layer_.getXDtoP(x);
        double yp = this.layer_.getYDtoP(y);
        if (this.porigin_.x != xp || this.porigin_.y != yp) {
            Point2D.Double temp = this.porigin_;
            this.porigin_.x = xp;
            this.porigin_.y = yp;
            this.changes_.firePropertyChange("location", temp, new Point2D.Double(xp, yp));
            this.modified("VectorKey: setBounds()");
        }
    }

    Object getObjectAt(Point pt) {
        int i;
        int numLines = this.vectors_.size();
        if (numLines <= 0) {
            return null;
        }
        int numRows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++numRows;
        }
        int[] xd = new int[this.columns_];
        int[] yd = new int[numRows];
        int[] xout = new int[2];
        int[] yout = new int[2];
        Rectangle bounds = this.getBounds();
        int vectorLength = this.layer_.getXPtoD(this.vectorLengthP_) - this.layer_.getXPtoD(0.0);
        double labelSpace = this.layer_.getXDtoP(10) - this.layer_.getXDtoP(0);
        double scaleSpace = this.layer_.getXDtoP(7) - this.layer_.getXDtoP(0);
        yd[0] = bounds.y + 3 + this.maxLabelHeight_;
        for (i = 1; i < numRows; ++i) {
            yd[i] = yd[i - 1] + 3 + this.maxLabelHeight_;
        }
        xd[0] = bounds.x + 15;
        for (i = 1; i < this.columns_; ++i) {
            xd[i] = xd[i - 1] + 10 + vectorLength + 7 + this.maxScaleLength_ + 10 + this.maxLabelLength_;
        }
        int row = 0;
        int col = 0;
        Enumeration lineIt = this.vectors_.elements();
        while (lineIt.hasMoreElements()) {
            VectorCartesianRenderer vector = (VectorCartesianRenderer)lineIt.nextElement();
            xout[0] = xd[col];
            xout[1] = xout[0] + vectorLength + 7;
            yout[0] = yd[row] - this.maxLabelHeight_;
            yout[1] = yd[row];
            Rectangle lbnds = new Rectangle(xout[0], yout[0], xout[1] - xout[0], yout[1] - yout[0]);
            if (lbnds.contains(pt)) {
                return vector;
            }
            if (++col < this.columns_) continue;
            col = 0;
            ++row;
        }
        if (bounds.contains(pt)) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("VectorKey: setVisible()");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("VectorKey: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }
}

