/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.Format;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.LayerNotFoundException;
import sgtplot.LinearTransform;
import sgtplot.SGLabel;
import sgtplot.util.Point2D;
import sgtplot.util.Range2D;
import sgtplot.util.Rectangle2D;

public class Ruler
implements Cloneable,
LayerChild {
    private String ident_;
    private Layer layer_;
    private int orient_;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private SGLabel title_ = null;
    private String labelFormat_ = "";
    protected Range2D uRange_;
    protected Rectangle2D.Double pBounds_;
    protected int numSmallTics_ = 0;
    protected double largeTicHeight_ = 0.02;
    protected double smallTicHeight_ = 0.01;
    protected int ticPosition_ = 1;
    protected int labelPosition_ = 1;
    protected int labelInterval_ = 2;
    protected Font labelFont_ = new Font("SansSerif", 1, 10);
    protected Color labelColor_ = Color.black;
    protected Color lineColor_ = Color.black;
    protected double labelHeight_ = 0.04;
    protected int sigDigits_ = 2;
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int POSITIVE_SIDE = 0;
    public static final int NEGATIVE_SIDE = 1;
    public static final int NO_LABEL = 2;
    public static final int BOTH_SIDES = 2;
    static final double TIC_GAP = 0.05;
    static final double TIC_RATIO = 1.3;
    static final double LABEL_RATIO = 1.3;

    protected void drawXTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double yp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + ticHeight : yp;
        double yp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - ticHeight : yp;
        int x0 = this.layer_.getXPtoD(xp);
        int y0 = this.layer_.getYPtoD(yp0);
        int y1 = this.layer_.getYPtoD(yp1);
        g.drawLine(x0, y0, x0, y1);
    }

    protected void drawYTic(VectorGraphics g, double xp, double yp, double ticHeight) {
        double xp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + ticHeight : xp;
        double xp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - ticHeight : xp;
        int y0 = this.layer_.getYPtoD(yp);
        int x0 = this.layer_.getXPtoD(xp0);
        int x1 = this.layer_.getXPtoD(xp1);
        g.drawLine(x0, y0, x1, y0);
    }

    protected void drawSmallXTics(VectorGraphics g, double xu, double xtest, double del, double yp) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double yp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + this.smallTicHeight_ : yp;
        double yp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - this.smallTicHeight_ : yp;
        int y0 = this.layer_.getYPtoD(yp0);
        int y1 = this.layer_.getYPtoD(yp1);
        double smdel = del / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double xt = xu + smdel * (double)i;
            if (!((xtest - xt) / del >= 0.0)) continue;
            int x0 = this.layer_.getXPtoD(xt);
            g.drawLine(x0, y0, x0, y1);
        }
    }

    protected void drawSmallYTics(VectorGraphics g, double xp, double yu, double ytest, double del) {
        if (this.numSmallTics_ <= 0) {
            return;
        }
        double xp0 = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + this.smallTicHeight_ : xp;
        double xp1 = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - this.smallTicHeight_ : xp;
        int x0 = this.layer_.getXPtoD(xp0);
        int x1 = this.layer_.getXPtoD(xp1);
        double smdel = del / (double)(this.numSmallTics_ + 1);
        for (int i = 0; i <= this.numSmallTics_; ++i) {
            double yt = yu + smdel * (double)i;
            if (!((ytest - yt) / del >= 0.0)) continue;
            int y0 = this.layer_.getYPtoD(yt);
            g.drawLine(x0, y0, x1, y0);
        }
    }

    public Ruler() {
        this("");
    }

    public Ruler(String ident) {
        this.ident_ = ident;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
    }

    @Override
    public LayerChild copy() {
        Ruler newRuler;
        try {
            newRuler = (Ruler)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newRuler = new Ruler();
        }
        return newRuler;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    public void setLargeTicHeightP(double lthgt) {
        if (this.largeTicHeight_ != lthgt) {
            this.largeTicHeight_ = lthgt;
            this.modified("Ruler: setLargeTicHeightP()");
        }
    }

    public double getLargeTicHeightP() {
        return this.largeTicHeight_;
    }

    public void setNumberSmallTics(int nstic) {
        if (this.numSmallTics_ != nstic) {
            this.numSmallTics_ = nstic;
            this.modified("Ruler: setNumberSmallTics()");
        }
    }

    public int getNumberSmallTics() {
        return this.numSmallTics_;
    }

    public void setSmallTicHeightP(double sthgt) {
        if (this.smallTicHeight_ != sthgt) {
            this.smallTicHeight_ = sthgt;
            this.modified("Ruler: setSmallTicHeightP()");
        }
    }

    public double getSmallTicHeightP() {
        return this.smallTicHeight_;
    }

    public void setTicPosition(int tpos) {
        if (this.ticPosition_ != tpos) {
            this.ticPosition_ = tpos;
            this.modified("Ruler: setTicPosition()");
        }
    }

    public int getTicPosition() {
        return this.ticPosition_;
    }

    public void setLabelPosition(int labp) {
        if (this.labelPosition_ != labp) {
            this.labelPosition_ = labp;
            this.modified("Ruler: setLabelPosition()");
        }
    }

    public int getLabelPosition() {
        return this.labelPosition_;
    }

    public void setLabelFont(Font fnt) {
        if (this.labelFont_ == null || !this.labelFont_.equals(fnt)) {
            this.labelFont_ = fnt;
            this.modified("Ruler: setLabelFont()");
        }
    }

    public Font getLabelFont() {
        return this.labelFont_;
    }

    public void setLabelHeightP(double lhgt) {
        if (this.labelHeight_ != lhgt) {
            this.labelHeight_ = lhgt;
            this.modified("Ruler: setLabelHeightP()");
        }
    }

    public double getLabelHeightP() {
        return this.labelHeight_;
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    public void setRangeU(Range2D range) {
        if (this.uRange_ == null || !this.uRange_.equals(range)) {
            this.uRange_ = range;
            this.modified("Ruler: setRangeU()");
        }
    }

    public Range2D getRangeU() {
        return this.uRange_;
    }

    public void setBoundsP(Rectangle2D.Double bounds) {
        if (this.pBounds_ == null || !this.pBounds_.equals(bounds)) {
            this.pBounds_ = bounds;
            this.modified("Ruler: setBoundsP()");
        }
    }

    public Rectangle2D.Double getBoundsP() {
        return this.pBounds_;
    }

    public void setOrientation(int orient) {
        if (this.orient_ != orient) {
            this.orient_ = orient;
            this.modified("Ruler: setOrientation()");
        }
    }

    public int getOrientation() {
        return this.orient_;
    }

    public void setTitle(SGLabel title) {
        if (this.title_ == null || !this.title_.equals(title)) {
            this.title_ = title;
            this.modified("Ruler: setTitle()");
        }
    }

    public SGLabel getTitle() {
        return this.title_;
    }

    @Override
    public Rectangle getBounds() {
        int x = this.layer_.getXPtoD(this.pBounds_.x);
        int y = this.layer_.getYPtoD(this.pBounds_.y);
        int width = this.layer_.getXPtoD(this.pBounds_.x + this.pBounds_.width) - x;
        int height = this.layer_.getYPtoD(this.pBounds_.y - this.pBounds_.height) - y;
        if (this.orient_ == 1) {
            y -= height;
        }
        return new Rectangle(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
    }

    @Override
    public void draw(VectorGraphics g) {
        String labelText = null;
        if (!this.visible_) {
            return;
        }
        if (this.title_ != null) {
            this.title_.setLayer(this.layer_);
        }
        if (this.lineColor_ == null) {
            g.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            g.setColor(this.lineColor_);
        }
        Format format = this.labelFormat_.length() <= 0 ? new Format(Format.computeFormat(this.uRange_.start, this.uRange_.end, this.sigDigits_)) : new Format(this.labelFormat_);
        if (this.orient_ == 1) {
            double ytitle;
            double yt;
            int vertalign;
            int i;
            LinearTransform sTrans = new LinearTransform(this.pBounds_.x, this.pBounds_.x + this.pBounds_.width, this.uRange_.start, this.uRange_.end);
            int yloc = this.layer_.getYPtoD(this.pBounds_.y);
            double yp = this.pBounds_.y;
            int xloc = this.layer_.getXPtoD(sTrans.getTransP(this.uRange_.start));
            int xend = this.layer_.getXPtoD(sTrans.getTransP(this.uRange_.end));
            g.drawLine(xloc, yloc, xend, yloc);
            double dir = this.uRange_.delta > 0.0 ? 1.0 : -1.0;
            double xt = (double)((int)(this.uRange_.start / this.uRange_.delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * this.uRange_.delta;
            if (dir * xt < dir * this.uRange_.start) {
                xt += this.uRange_.delta;
            }
            int istop = (int)((this.uRange_.end - xt) / this.uRange_.delta + 1.0E-5);
            double x = xt;
            double xp = sTrans.getTransP(x);
            this.drawSmallXTics(g, x, this.uRange_.start, -this.uRange_.delta, yp);
            this.drawXTic(g, xp, yp, this.largeTicHeight_);
            for (i = 0; i < istop; ++i) {
                this.drawSmallXTics(g, x, this.uRange_.end, this.uRange_.delta, yp);
                xp = sTrans.getTransP(x += this.uRange_.delta);
                this.drawXTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallXTics(g, x, this.uRange_.end, this.uRange_.delta, yp);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 0) {
                vertalign = 2;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? yp + 1.3 * this.largeTicHeight_ : yp + 0.05;
                ytitle = yt + 1.3 * this.labelHeight_;
            } else {
                vertalign = 0;
                yt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? yp - 1.3 * this.largeTicHeight_ : yp - 0.05;
                ytitle = yt - 1.3 * this.labelHeight_;
            }
            x = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (this.uRange_.delta * (double)this.labelInterval_) - 1.0E-5)) * this.uRange_.delta * (double)this.labelInterval_ : xt;
            istop = (int)((this.uRange_.end - x) / (this.uRange_.delta * (double)this.labelInterval_) + 1.0E-5);
            for (i = 0; i <= istop; ++i) {
                xt = sTrans.getTransP(x);
                labelText = format.form(x);
                SGLabel label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setFont(this.labelFont_);
                label.setHeightP(this.labelHeight_);
                label.setAlign(vertalign, 1);
                label.setLayer(this.layer_);
                label.setColor(this.labelColor_);
                try {
                    label.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                x += this.uRange_.delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double xtitle = (this.uRange_.end + this.uRange_.start) * 0.5;
                yt = ytitle;
                xt = sTrans.getTransP(xtitle);
                this.title_.setLocationP(new Point2D.Double(xt, yt));
                this.title_.setAlign(vertalign, 1);
                this.title_.setOrientation(0);
                try {
                    this.title_.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {}
            }
        } else {
            double xtitle;
            double xt;
            int vertalign;
            int i;
            LinearTransform sTrans = new LinearTransform(this.pBounds_.y, this.pBounds_.y + this.pBounds_.height, this.uRange_.start, this.uRange_.end);
            int xloc = this.layer_.getXPtoD(this.pBounds_.x);
            double xp = this.pBounds_.x;
            int yloc = this.layer_.getYPtoD(sTrans.getTransP(this.uRange_.start));
            int yend = this.layer_.getYPtoD(sTrans.getTransP(this.uRange_.end));
            g.drawLine(xloc, yloc, xloc, yend);
            double dir = this.uRange_.delta > 0.0 ? 1.0 : -1.0;
            double yt = (double)((int)(this.uRange_.start / this.uRange_.delta + (dir * this.uRange_.start > 0.0 ? 1.0 : -1.0) * 1.0E-5)) * this.uRange_.delta;
            if (dir * yt < dir * this.uRange_.start) {
                yt += this.uRange_.delta;
            }
            int istop = (int)((this.uRange_.end - yt) / this.uRange_.delta + 1.0E-5);
            double y = yt;
            double yp = sTrans.getTransP(y);
            this.drawSmallYTics(g, xp, y, this.uRange_.start, -this.uRange_.delta);
            this.drawYTic(g, xp, yp, this.largeTicHeight_);
            for (i = 0; i < istop; ++i) {
                this.drawSmallYTics(g, xp, y, this.uRange_.end, this.uRange_.delta);
                yp = sTrans.getTransP(y += this.uRange_.delta);
                this.drawYTic(g, xp, yp, this.largeTicHeight_);
            }
            this.drawSmallYTics(g, xp, y, this.uRange_.end, this.uRange_.delta);
            if (this.labelInterval_ <= 0 || this.labelPosition_ == 2) {
                return;
            }
            if (this.labelPosition_ == 1) {
                vertalign = 2;
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 1 ? xp - 1.3 * this.largeTicHeight_ : xp - 0.05;
                xtitle = xt - 1.3 * this.labelHeight_;
            } else {
                vertalign = 0;
                xt = this.ticPosition_ == 2 || this.ticPosition_ == 0 ? xp + 1.3 * this.largeTicHeight_ : xp + 0.05;
                xtitle = xt + 1.3 * this.labelHeight_;
            }
            y = dir * this.uRange_.start <= 0.0 && dir * this.uRange_.end >= 0.0 ? (double)((int)(this.uRange_.start / (this.uRange_.delta * (double)this.labelInterval_) - 1.0E-5)) * this.uRange_.delta * (double)this.labelInterval_ : yt;
            istop = (int)((this.uRange_.end - y) / (this.uRange_.delta * (double)this.labelInterval_) + 1.0E-5);
            for (i = 0; i <= istop; ++i) {
                yt = sTrans.getTransP(y);
                labelText = format.form(y);
                SGLabel label = new SGLabel("coordinate", labelText, new Point2D.Double(xt, yt));
                label.setAlign(vertalign, 1);
                label.setOrientation(1);
                label.setFont(this.labelFont_);
                label.setHeightP(this.labelHeight_);
                label.setLayer(this.layer_);
                try {
                    label.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
                y += this.uRange_.delta * (double)this.labelInterval_;
            }
            if (this.title_ != null) {
                double ytitle = (this.uRange_.end + this.uRange_.start) * 0.5;
                yt = sTrans.getTransP(ytitle);
                xt = xtitle;
                this.title_.setLocationP(new Point2D.Double(xt, yt));
                this.title_.setAlign(vertalign, 1);
                this.title_.setOrientation(1);
                try {
                    this.title_.draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("Ruler: setVisible()");
        }
    }

    public int getLabelInterval() {
        return this.labelInterval_;
    }

    public void setLabelInterval(int labelInterval) {
        this.labelInterval_ = labelInterval;
    }

    public int getSignificantDigits() {
        return this.sigDigits_;
    }

    public void setSignificantDigits(int sigDigits) {
        this.sigDigits_ = sigDigits;
    }

    public String getLabelFormat() {
        return this.labelFormat_;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat_ = labelFormat;
    }

    public Color getLabelColor() {
        return this.labelColor_;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor_ = labelColor;
    }

    public Color getLineColor() {
        return this.lineColor_;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor_ = lineColor;
    }
}

