/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.LayerControl;
import sgtplot.LayerNotFoundException;
import sgtplot.Moveable;
import sgtplot.PaneNotFoundException;
import sgtplot.Selectable;
import sgtplot.StrokeDrawer;
import sgtplot.StrokeDrawer2;
import sgtplot.beans.Panel;
import sgtplot.swing.Draggable;

class PaneProxy {
    public static String SGTVersion = "3.0";
    public static boolean Java2D = false;
    public static StrokeDrawer strokeDrawer = null;
    private Container pane_;
    private String ident_;
    private Dimension panesize_;
    private Image offscreen_;
    private Dimension pagesize_;
    private Point pageOrigin_ = new Point(0, 0);
    private boolean printer_ = false;
    private boolean opaque_ = true;
    private int halign_ = 1;
    private int valign_ = 1;
    private int printMode_ = 2;
    private Object selectedobject_;
    private Object old_selectedobject_ = null;
    private Rectangle selectedRect_;
    private Rectangle zoom_rect_ = new Rectangle(0, 0, 0, 0);
    private Rectangle old_zoom_rect_;
    private Point zoom_start_ = new Point(0, 0);
    private boolean in_zoom_ = false;
    private boolean in_select_ = false;
    private boolean in_move_ = false;
    private boolean moved_ = false;
    private boolean draggable_ = false;
    private boolean moveable_ = false;
    private Point move_ref_;
    private boolean batch_ = true;
    private boolean modified_ = false;
    private boolean ignoreModified_ = false;
    private boolean firstDraw_ = true;
    private boolean mouseEventsEnabled_ = true;
    private PropertyChangeSupport changes_ = null;

    public PaneProxy(Container pane, String id, Dimension size) {
        this.ident_ = id;
        this.panesize_ = size;
        this.pane_ = pane;
        this.changes_ = new PropertyChangeSupport(this.pane_);
        this.testJava2D();
    }

    public static String getVersion() {
        return SGTVersion;
    }

    private void testJava2D() {
        boolean java2d = true;
        try {
            Class<?> cl = Class.forName("org.freehep.graphics2d.VectorGraphics");
        }
        catch (ClassNotFoundException e) {
            java2d = false;
        }
        Java2D = java2d;
        strokeDrawer = new StrokeDrawer2();
    }

    public Dimension getSize() {
        return this.panesize_;
    }

    void draw(VectorGraphics g, String test) {
        this.ignoreModified_ = true;
        this.printer_ = false;
        if (g == null) {
            this.ignoreModified_ = false;
            return;
        }
        if (this.firstDraw_) {
            ((AbstractPane)((Object)this.pane_)).init();
            this.firstDraw_ = false;
        }
        this.drawLayers(g);
        this.drawDraggableItems(g);
        this.modified_ = false;
        this.ignoreModified_ = false;
    }

    void draw(VectorGraphics g) {
        Rectangle clip = this.pane_.getBounds();
        this.draw(g, clip.width, clip.height);
    }

    void draw(VectorGraphics g, int width, int height) {
        this.ignoreModified_ = true;
        if (g instanceof PrintGraphics) {
            this.printer_ = true;
            this.pagesize_ = ((PrintGraphics)g).getPrintJob().getPageDimension();
        } else {
            this.printer_ = false;
            this.pagesize_ = null;
        }
        g.setClip(0, 0, width, height);
        this.drawLayers(g);
        this.drawDraggableItems(g);
        this.modified_ = false;
        this.ignoreModified_ = false;
    }

    void drawPage(VectorGraphics g, double width, double height) {
        this.ignoreModified_ = true;
        this.printer_ = true;
        Color saved = g.getColor();
        g.setColor(this.pane_.getBackground());
        Rectangle r = this.pane_.getBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        g.setColor(saved);
        this.drawLayers(g);
        this.drawDraggableItems(g);
        this.modified_ = false;
        this.ignoreModified_ = false;
        this.printer_ = false;
    }

    void setOpaque(boolean opaque) {
        this.opaque_ = opaque;
    }

    boolean isOpaque() {
        return this.opaque_;
    }

    void drawLayers(VectorGraphics g) {
        if (!this.printer_) {
            if (this.opaque_) {
                Rectangle r = this.pane_.getBounds();
                g.setColor(this.pane_.getBackground());
                g.fillRect(0, 0, r.width, r.height);
            }
            g.setColor(this.pane_.getForeground());
        }
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (comps[i] instanceof Layer) {
                    ((Layer)comps[i]).draw(g);
                    continue;
                }
                if (!(comps[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)comps[i])).draw(g);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void drawDraggableItems(VectorGraphics g) {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                if (!(comps[i] instanceof LayerControl)) continue;
                ((LayerControl)((Object)comps[i])).drawDraggableItems(g);
                continue;
            }
            catch (PaneNotFoundException paneNotFoundException) {
                // empty catch block
            }
        }
    }

    void paint(Graphics g) {
        VectorGraphics vg = VectorGraphics.create((Graphics)g);
        Dimension isze = this.pane_.getSize();
        if (isze.width != this.panesize_.width || isze.height != this.panesize_.height) {
            this.offscreen_ = null;
        }
        if (this.offscreen_ != null && !this.modified_) {
            vg.drawImage(this.offscreen_, 0, 0, (ImageObserver)this.pane_);
            this.drawDraggableItems(vg);
        } else {
            this.draw(vg, "start");
        }
        this.modified_ = false;
    }

    String getId() {
        return this.ident_;
    }

    void setId(String id) {
        this.ident_ = id;
    }

    void setPageAlign(int vert, int horz) {
        this.valign_ = vert;
        this.halign_ = horz;
    }

    void setPageVAlign(int vert) {
        this.valign_ = vert;
    }

    void setPageHAlign(int horz) {
        this.halign_ = horz;
    }

    int getPageVAlign() {
        return this.valign_;
    }

    int getPageHAlign() {
        return this.halign_;
    }

    void setPageOrigin(Point p) {
        this.pageOrigin_ = p;
    }

    Point getPageOrigin() {
        return this.pageOrigin_;
    }

    boolean isPrinter() {
        return this.printer_;
    }

    Dimension getPageSize() {
        return this.pagesize_;
    }

    void setSize(Dimension d) {
        this.panesize_ = d;
        this.offscreen_ = null;
    }

    Layer getFirstLayer() {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (!(comps[i] instanceof Layer)) continue;
            return (Layer)comps[i];
        }
        return null;
    }

    Layer getLayer(String id) throws LayerNotFoundException {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Layer) {
                if (((Layer)comps[i]).getId() != id) continue;
                return (Layer)comps[i];
            }
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).hasLayer(id)) continue;
            return ((Panel)comps[i]).getLayer(id);
        }
        throw new LayerNotFoundException();
    }

    Layer getLayerFromDataId(String id) throws LayerNotFoundException {
        Component[] comps = this.pane_.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] instanceof Layer) {
                if (!((Layer)comps[i]).isDataInLayer(id)) continue;
                return (Layer)comps[i];
            }
            if (!(comps[i] instanceof Panel) || !((Panel)comps[i]).isDataInPanel(id)) continue;
            return ((Panel)comps[i]).getLayerFromDataId(id);
        }
        throw new LayerNotFoundException();
    }

    Object getSelectedObject() {
        return this.selectedobject_;
    }

    void setSelectedObject(Object obj) {
        this.old_selectedobject_ = this.selectedobject_;
        this.selectedobject_ = obj;
    }

    Rectangle getZoomBounds() {
        return this.zoom_rect_;
    }

    Point getZoomStart() {
        return this.zoom_start_;
    }

    Object getObjectAt(int x, int y) {
        Object obj = null;
        Component[] comps = this.pane_.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (!(comps[i] instanceof Layer ? (obj = ((Layer)comps[i]).getObjectAt(x, y, false)) != null : comps[i] instanceof Panel && (obj = ((Panel)comps[i]).getObjectAt(x, y, false)) != null)) continue;
                return obj;
            }
        }
        return obj;
    }

    Object[] getObjectsAt(int x, int y) {
        Vector<Object> obList = new Vector<Object>();
        Object obj = null;
        Component[] comps = this.pane_.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(x, y, false);
                    if (obj == null) continue;
                    obList.addElement(obj);
                    continue;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(x, y, false)) == null) continue;
                obList.addElement(obj);
            }
        }
        return obList.toArray();
    }

    boolean processMouseEvent(MouseEvent event) {
        boolean event_handled = false;
        if (!this.mouseEventsEnabled_) {
            return event_handled;
        }
        if (event.getID() == 500) {
            event_handled = this.Pane_MouseClicked(event);
        } else if (event.getID() == 501) {
            event_handled = this.Pane_MouseDown(event);
        } else if (event.getID() == 502) {
            event_handled = this.Pane_MouseUp(event);
        }
        return event_handled;
    }

    boolean processMouseMotionEvent(MouseEvent event) {
        boolean event_handled = false;
        if (!this.mouseEventsEnabled_) {
            return event_handled;
        }
        if (event.getID() == 506) {
            event_handled = this.Pane_MouseDrag(event);
        } else if (event.getID() == 503) {
            event_handled = this.Pane_MouseMoved(event);
        }
        return event_handled;
    }

    private boolean Pane_MouseClicked(MouseEvent event) {
        Selectable savedobj = null;
        int mod = event.getModifiers();
        if ((mod & 0x10) == 0) {
            return false;
        }
        this.in_zoom_ = false;
        this.in_select_ = false;
        if (!this.moved_ && this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelected()) {
            savedobj = (Selectable)this.selectedobject_;
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            if (this.moveable_) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.blue);
            }
            g.setXORMode(this.pane_.getBackground());
            g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            g.setPaintMode();
            savedobj.setSelected(false);
            this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        this.selectedobject_ = null;
        Component[] comps = this.pane_.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                Object obj;
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(event.getX(), event.getY());
                    if (obj == null) continue;
                    this.selectedobject_ = obj;
                    break;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(event.getX(), event.getY(), false)) == null) continue;
                this.selectedobject_ = obj;
                break;
            }
            if (this.selectedobject_ instanceof Selectable) {
                if (!this.selectedobject_.equals(savedobj) && ((Selectable)this.selectedobject_).isSelectable()) {
                    ((Selectable)this.selectedobject_).setSelected(true);
                    this.in_select_ = true;
                    if (!this.in_move_) {
                        this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                        VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
                        if (this.moveable_) {
                            g.setColor(Color.red);
                        } else {
                            g.setColor(Color.blue);
                        }
                        g.setXORMode(this.pane_.getBackground());
                        g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                        g.setPaintMode();
                    }
                    this.in_move_ = false;
                    this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
                }
            } else if (this.selectedobject_ != null) {
                this.changes_.firePropertyChange("objectSelected", this.old_selectedobject_, this.selectedobject_);
            }
        }
        return false;
    }

    private boolean Pane_MouseMoved(MouseEvent event) {
        if (this.in_select_) {
            if (this.selectedRect_.contains(event.getX(), event.getY())) {
                this.pane_.setCursor(Cursor.getPredefinedCursor(13));
            } else {
                this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            }
            return true;
        }
        this.pane_.setCursor(Cursor.getPredefinedCursor(0));
        return false;
    }

    private boolean Pane_MouseDown(MouseEvent event) {
        Selectable savedobj = null;
        if ((event.getModifiers() & 0x10) == 0) {
            return false;
        }
        this.old_zoom_rect_ = new Rectangle(this.zoom_rect_);
        this.zoom_rect_.x = 0;
        this.zoom_rect_.y = 0;
        this.zoom_rect_.width = 0;
        this.zoom_rect_.height = 0;
        if (event.isShiftDown()) {
            this.in_zoom_ = true;
            this.zoom_start_.x = event.getX();
            this.zoom_start_.y = event.getY();
            this.zoom_rect_.x = event.getX();
            this.zoom_rect_.y = event.getY();
            this.zoom_rect_.width = 1;
            this.zoom_rect_.height = 1;
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            g.setColor(this.pane_.getForeground());
            g.setXORMode(this.pane_.getBackground());
            g.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            g.setPaintMode();
            return true;
        }
        if (event.isControlDown()) {
            return false;
        }
        if (this.in_select_ && this.moveable_ && this.selectedRect_.contains(event.getX(), event.getY())) {
            this.in_move_ = true;
            this.moved_ = false;
            this.move_ref_ = new Point(event.getX(), event.getY());
            return true;
        }
        if (this.in_select_ && !this.moveable_ && this.selectedRect_.contains(event.getX(), event.getY())) {
            this.in_move_ = false;
            this.moved_ = false;
            return true;
        }
        savedobj = this.selectedobject_ instanceof Selectable ? (Selectable)this.selectedobject_ : null;
        this.selectedobject_ = null;
        Component[] comps = this.pane_.getComponents();
        if (comps.length != 0) {
            for (int i = 0; i < comps.length; ++i) {
                Object obj;
                if (comps[i] instanceof Layer) {
                    obj = ((Layer)comps[i]).getObjectAt(event.getX(), event.getY());
                    if (obj == null) continue;
                    this.selectedobject_ = obj;
                    break;
                }
                if (!(comps[i] instanceof Panel) || (obj = ((Panel)comps[i]).getObjectAt(event.getX(), event.getY(), false)) == null) continue;
                this.selectedobject_ = obj;
                break;
            }
            if (this.selectedobject_ instanceof Selectable && ((Selectable)this.selectedobject_).isSelectable()) {
                this.draggable_ = this.selectedobject_ instanceof Draggable;
                this.moveable_ = this.selectedobject_ instanceof Moveable ? ((Moveable)this.selectedobject_).isMoveable() : false;
                this.in_move_ = this.moveable_ || this.draggable_;
                this.moved_ = false;
                ((Selectable)this.selectedobject_).setSelected(false);
                this.selectedRect_ = new Rectangle(((Selectable)this.selectedobject_).getBounds());
                if (!this.draggable_ && this.moveable_) {
                    VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
                    g.setColor(Color.red);
                    g.setXORMode(this.pane_.getBackground());
                    g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                    g.setPaintMode();
                }
                if (!this.draggable_) {
                    this.pane_.setCursor(Cursor.getPredefinedCursor(13));
                }
                this.move_ref_ = new Point(event.getX(), event.getY());
                return true;
            }
        }
        this.in_zoom_ = true;
        this.zoom_start_.x = event.getX();
        this.zoom_start_.y = event.getY();
        this.zoom_rect_.x = event.getX();
        this.zoom_rect_.y = event.getY();
        this.zoom_rect_.width = 1;
        this.zoom_rect_.height = 1;
        VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
        g.setColor(this.pane_.getForeground());
        g.setXORMode(this.pane_.getBackground());
        g.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
        g.setPaintMode();
        return true;
    }

    private boolean Pane_MouseDrag(MouseEvent event) {
        boolean handled = false;
        if (this.in_zoom_) {
            handled = true;
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            g.setColor(this.pane_.getForeground());
            g.setXORMode(this.pane_.getBackground());
            g.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            this.zoom_rect_.width = event.getX() - this.zoom_start_.x;
            if (this.zoom_rect_.width < 0) {
                this.zoom_rect_.x = event.getX();
                this.zoom_rect_.width = Math.abs(this.zoom_rect_.width);
            } else {
                this.zoom_rect_.x = this.zoom_start_.x;
            }
            this.zoom_rect_.height = event.getY() - this.zoom_start_.y;
            if (this.zoom_rect_.height < 0) {
                this.zoom_rect_.y = event.getY();
                this.zoom_rect_.height = Math.abs(this.zoom_rect_.height);
            } else {
                this.zoom_rect_.y = this.zoom_start_.y;
            }
            g.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            g.setPaintMode();
        } else if (this.in_move_) {
            handled = true;
            this.moved_ = true;
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            if (!this.draggable_ && this.moveable_) {
                g.setColor(Color.red);
                g.setXORMode(this.pane_.getBackground());
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
            } else if (this.draggable_) {
                ((LayerChild)this.selectedobject_).setVisible(false);
                Rectangle rect = ((LayerChild)this.selectedobject_).getBounds();
                this.pane_.repaint(rect.x - 1, rect.y - 1, rect.width + 2, rect.height + 2);
            }
            this.selectedRect_.x += event.getX() - this.move_ref_.x;
            this.selectedRect_.y += event.getY() - this.move_ref_.y;
            if (!this.draggable_ && this.moveable_) {
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                g.setPaintMode();
            } else if (this.draggable_) {
                try {
                    ((LayerChild)this.selectedobject_).setVisible(true);
                    ((Draggable)this.selectedobject_).setLocation(new Point(this.selectedRect_.x, this.selectedRect_.y), false);
                    ((LayerChild)this.selectedobject_).draw(g);
                }
                catch (LayerNotFoundException layerNotFoundException) {
                    // empty catch block
                }
            }
            this.move_ref_ = new Point(event.getX(), event.getY());
        }
        return handled;
    }

    private boolean Pane_MouseUp(MouseEvent event) {
        if ((event.getModifiers() & 0x10) == 0) {
            return false;
        }
        if (this.in_zoom_) {
            this.in_zoom_ = false;
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            g.setColor(this.pane_.getForeground());
            g.setXORMode(this.pane_.getBackground());
            g.drawRect(this.zoom_rect_.x, this.zoom_rect_.y, this.zoom_rect_.width, this.zoom_rect_.height);
            this.changes_.firePropertyChange("zoomRectangle", this.old_zoom_rect_, this.zoom_rect_);
            return false;
        }
        if (this.in_move_ && this.moved_) {
            VectorGraphics g = VectorGraphics.create((Graphics)this.pane_.getGraphics());
            if (!this.draggable_ && this.moveable_) {
                g.setColor(Color.red);
                g.setXORMode(this.pane_.getBackground());
                g.drawRect(this.selectedRect_.x, this.selectedRect_.y, this.selectedRect_.width, this.selectedRect_.height);
                g.setPaintMode();
            }
            Point loc = new Point(this.selectedRect_.x, this.selectedRect_.y);
            if (this.draggable_) {
                ((Draggable)this.selectedobject_).setLocation(loc);
                this.paint((Graphics)g);
            } else if (this.moveable_) {
                ((Moveable)this.selectedobject_).setLocation(loc);
                this.modified_ = true;
                this.pane_.repaint();
            }
            this.in_move_ = false;
            this.in_select_ = false;
            this.moved_ = false;
            this.draggable_ = false;
            this.moveable_ = false;
            ((Selectable)this.selectedobject_).setSelected(false);
            this.pane_.setCursor(Cursor.getPredefinedCursor(0));
            return true;
        }
        return false;
    }

    Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    Dimension getMinimumSize() {
        return new Dimension(this.panesize_.width, this.panesize_.height);
    }

    Dimension getPreferredSize() {
        return new Dimension(this.panesize_.width, this.panesize_.height);
    }

    public String toString() {
        String name = this.pane_.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    void setBatch(boolean batch, String msg) {
        this.batch_ = batch;
        if (!this.batch_ && this.modified_) {
            this.pane_.repaint();
        }
    }

    boolean isBatch() {
        return this.batch_;
    }

    void setIgnoreModified(boolean ig) {
        this.ignoreModified_ = ig;
    }

    void clearModified() {
        this.modified_ = false;
    }

    void setModified(boolean mod, String mess) {
        if (this.ignoreModified_) {
            return;
        }
        this.modified_ = mod;
        if (this.modified_ && !this.batch_) {
            this.pane_.repaint();
        }
    }

    boolean isModified() {
        return this.modified_;
    }

    void setMouseEventsEnabled(boolean enable) {
        this.mouseEventsEnabled_ = enable;
    }

    boolean isMouseEventsEnabled() {
        return this.mouseEventsEnabled_;
    }

    void setPageScaleMode(int mode) {
        this.printMode_ = mode;
    }

    int getPageScaleMode() {
        return this.printMode_;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }
}

