/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import sgtplot.TimeAxisStyle;
import sgtplot.util.GeoDate;
import sgtplot.util.IllegalTimeValue;
import sgtplot.util.TimeRange;

class MinuteHourAxis
implements TimeAxisStyle {
    static final int MINUTE_TEST__ = 31;
    static final String defaultMinorLabelFormat__ = "mm";
    static final String defaultMajorLabelFormat__ = "yyyy-MM-dd HH";
    static final int defaultNumSmallTics__ = 0;
    int defaultMinorLabelInterval_ = 2;
    int defaultMajorLabelInterval_ = 1;
    static final double incrementValue__ = 1.0;
    static final int incrementUnits__ = 6;

    @Override
    public double computeLocation(double prev, double now) {
        return prev;
    }

    @Override
    public void computeDefaults(GeoDate delta) {
        long msec = delta.getTime() % 86400000L;
        if (msec > 0x6DDD00L) {
            this.defaultMinorLabelInterval_ = 15;
            this.defaultMajorLabelInterval_ = 2;
        } else if (msec > 1800000L) {
            this.defaultMinorLabelInterval_ = 5;
            this.defaultMajorLabelInterval_ = 1;
        } else {
            this.defaultMinorLabelInterval_ = 1;
            this.defaultMajorLabelInterval_ = 1;
        }
    }

    @Override
    public int getMinorValue(GeoDate time) {
        return time.getGMTMinutes();
    }

    @Override
    public int getMajorValue(GeoDate time) {
        return time.getGMTHours() + 1;
    }

    @Override
    public boolean isRoomForMajorLabel(GeoDate delta) {
        return 1440.0 * ((double)delta.getTime() / 8.64E7) > 31.0;
    }

    @Override
    public boolean isStartOfMinor(GeoDate time) {
        return time.getGMTMinutes() == 0;
    }

    @Override
    public String getDefaultMinorLabelFormat() {
        return defaultMinorLabelFormat__;
    }

    @Override
    public String getDefaultMajorLabelFormat() {
        return defaultMajorLabelFormat__;
    }

    @Override
    public int getDefaultNumSmallTics() {
        return 0;
    }

    @Override
    public int getDefaultMinorLabelInterval() {
        return this.defaultMinorLabelInterval_;
    }

    @Override
    public int getDefaultMajorLabelInterval() {
        return this.defaultMajorLabelInterval_;
    }

    @Override
    public GeoDate getStartTime(TimeRange tRange) {
        GeoDate time = null;
        boolean time_increasing = tRange.end.after(tRange.start);
        try {
            if (time_increasing) {
                time = new GeoDate(tRange.start.getGMTMonth(), tRange.start.getGMTDay(), tRange.start.getGMTYear(), tRange.start.getGMTHours(), tRange.start.getGMTMinutes(), 0, 0);
                if (!time.equals(tRange.start)) {
                    time.increment(1.0, 6);
                }
            } else {
                time = new GeoDate(tRange.end.getGMTMonth(), tRange.end.getGMTDay(), tRange.end.getGMTYear(), tRange.end.getGMTHours(), tRange.end.getGMTMinutes(), 0, 0);
                if (!time.equals(tRange.end)) {
                    time.increment(1.0, 6);
                }
            }
        }
        catch (IllegalTimeValue illegalTimeValue) {
            // empty catch block
        }
        return time;
    }

    @Override
    public double getIncrementValue() {
        return 1.0;
    }

    @Override
    public int getIncrementUnits() {
        return 6;
    }

    @Override
    public String toString() {
        return "MinuteHourAxis";
    }
}

