/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Vector;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.AbstractPane;
import sgtplot.CartesianRenderer;
import sgtplot.DataKey;
import sgtplot.Layer;
import sgtplot.LayerChild;
import sgtplot.LineAttribute;
import sgtplot.LineCartesianRenderer;
import sgtplot.MethodNotImplementedError;
import sgtplot.Moveable;
import sgtplot.PaneProxy;
import sgtplot.SGException;
import sgtplot.SGLabel;
import sgtplot.StrokeDrawer;
import sgtplot.util.Point2D;
import sgtplot.util.Rectangle2D;

public class LineKey
implements Cloneable,
DataKey,
Moveable,
PropertyChangeListener {
    private String ident_;
    private Layer layer_;
    private Vector line_;
    private Vector label_;
    private int columns_;
    private int style_;
    private int valign_;
    private int halign_;
    private Point2D.Double porigin_;
    private double lineLengthP_;
    private int maxLabelLength_;
    private int maxLabelHeight_;
    private StrokeDrawer stroke_ = null;
    private boolean selected_;
    private boolean selectable_;
    private boolean visible_;
    private boolean moveable_;
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private static final int VERTICAL_BORDER_ = 3;
    private static final int HORIZONTAL_BORDER_ = 15;
    private static final int COLUMN_SPACE_ = 10;
    private static final int ROW_SPACE_ = 3;
    private static final int LABEL_SPACE_ = 15;
    public static final int PLAIN_LINE = 0;
    public static final int RAISED = 1;
    public static final int NO_BORDER = 2;
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;

    public LineKey() {
        this(new Point2D.Double(0.0, 0.0), 2, 0);
    }

    public LineKey(Point2D.Double loc, int valign, int halign) {
        this.porigin_ = loc;
        this.valign_ = valign;
        this.halign_ = halign;
        this.line_ = new Vector(2, 2);
        this.label_ = new Vector(2, 2);
        this.style_ = 0;
        this.columns_ = 1;
        this.ident_ = "";
        this.lineLengthP_ = 0.3f;
        this.selected_ = false;
        this.selectable_ = true;
        this.visible_ = true;
        this.moveable_ = true;
        this.stroke_ = PaneProxy.strokeDrawer;
    }

    @Override
    public LayerChild copy() {
        LineKey newKey;
        try {
            newKey = (LineKey)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newKey = new LineKey();
        }
        newKey.line_ = new Vector(2, 2);
        newKey.label_ = new Vector(2, 2);
        return newKey;
    }

    @Override
    public void setSelected(boolean sel) {
        this.selected_ = sel;
    }

    @Override
    public boolean isSelected() {
        return this.selected_;
    }

    @Override
    public void setSelectable(boolean select) {
        this.selectable_ = select;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable_;
    }

    @Override
    public boolean isMoveable() {
        return this.moveable_;
    }

    @Override
    public void setMoveable(boolean moveable) {
        this.moveable_ = moveable;
    }

    @Override
    public void setLayer(Layer l) {
        this.layer_ = l;
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public AbstractPane getPane() {
        return this.layer_.getPane();
    }

    @Override
    public void modified(String mess) {
        if (this.layer_ != null) {
            this.layer_.modified(mess);
        }
    }

    @Override
    public void setId(String id) {
        this.ident_ = id;
    }

    @Override
    public String getId() {
        return this.ident_;
    }

    @Override
    public void setLineLengthP(double len) {
        if (this.lineLengthP_ != len) {
            this.lineLengthP_ = len;
            this.modified("LineKey: setLineLengthP()");
        }
    }

    public double getLineLengthP() {
        return this.lineLengthP_;
    }

    @Override
    public void setColumns(int col) {
        if (this.columns_ != col) {
            this.columns_ = col;
            this.modified("LineKey: setColumms()");
        }
    }

    public int getColumns() {
        return this.columns_;
    }

    @Override
    public void setBorderStyle(int style) {
        if (this.style_ != style) {
            this.style_ = style;
            this.modified("LineKey: setBorderStyle()");
        }
    }

    public int getBorderStyle() {
        return this.style_;
    }

    @Override
    public void setAlign(int vert, int horz) {
        if (this.valign_ != vert || this.halign_ != horz) {
            this.valign_ = vert;
            this.halign_ = horz;
            this.modified("LineKey: setAlign()");
        }
    }

    @Override
    public void setVAlign(int vert) {
        if (this.valign_ != vert) {
            this.valign_ = vert;
            this.modified("LineKey: setVAlign()");
        }
    }

    @Override
    public void setHAlign(int horz) {
        if (this.halign_ != horz) {
            this.halign_ = horz;
            this.modified("LineKey: setHAlign()");
        }
    }

    public int getVAlign() {
        return this.valign_;
    }

    public int getHAlign() {
        return this.halign_;
    }

    @Override
    public void setLocationP(Point2D.Double loc) {
        if (this.porigin_ == null || !this.porigin_.equals(loc)) {
            Point2D.Double temp = this.porigin_;
            this.porigin_ = loc;
            this.changes_.firePropertyChange("location", temp, this.porigin_);
            this.modified("LineKey: setLocationP()");
        }
    }

    @Override
    public void setBoundsP(Rectangle2D.Double r) {
        this.setLocationP(new Point2D.Double(r.x, r.y));
    }

    public Rectangle2D.Double getBoundsP() {
        throw new MethodNotImplementedError();
    }

    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    public void addLineGraph(LineCartesianRenderer line, SGLabel label) {
        this.line_.addElement(line);
        label.setLayer(this.layer_);
        label.setMoveable(false);
        label.setSelectable(false);
        this.label_.addElement(label);
        ((LineAttribute)line.getAttribute()).addPropertyChangeListener(this);
        this.modified("LineKey: addLineGraph()");
    }

    @Override
    public void addGraph(CartesianRenderer rend, SGLabel label) throws IllegalArgumentException {
        if (!(rend instanceof LineCartesianRenderer)) {
            throw new IllegalArgumentException("Renderer is not a LineCartesianRenderer");
        }
        this.addLineGraph((LineCartesianRenderer)rend, label);
    }

    public void removeLineGraph(SGLabel label) {
    }

    public void removeLineRenderer(LineCartesianRenderer line) {
    }

    public void removeLineGraph(String ident) {
    }

    public void clearAll() {
        Enumeration e = this.line_.elements();
        while (e.hasMoreElements()) {
            LineAttribute attr = (LineAttribute)((LineCartesianRenderer)e.nextElement()).getAttribute();
            attr.removePropertyChangeListener(this);
        }
        this.line_.removeAllElements();
        this.label_.removeAllElements();
        this.modified("LineKey: clearAll()");
    }

    public void clear(String data_id) {
        int indx = -1;
        Enumeration it = this.line_.elements();
        while (it.hasMoreElements()) {
            ++indx;
            LineCartesianRenderer lcr = (LineCartesianRenderer)it.nextElement();
            if (!lcr.getLine().getId().equals(data_id)) continue;
            lcr.getAttribute().removePropertyChangeListener(this);
            this.line_.removeElement(lcr);
            this.label_.removeElementAt(indx);
            this.modified("LineKey: clear()");
            break;
        }
    }

    public int getRowHeight() {
        Rectangle bounds = this.getBounds();
        return 3 + this.maxLabelHeight_;
    }

    @Override
    public void draw(VectorGraphics g) {
        int i;
        LineCartesianRenderer render = null;
        LineAttribute attr = null;
        int numLines = this.line_.size();
        if (numLines <= 0 || !this.visible_) {
            return;
        }
        int numRows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++numRows;
        }
        double[] xp = new double[this.columns_];
        int[] xd = new int[this.columns_];
        double[] yp = new double[numRows];
        int[] yd = new int[numRows];
        int[] xout = new int[2];
        int[] yout = new int[2];
        g.setColor(this.layer_.getPane().getComponent().getForeground());
        Rectangle bounds = this.getBounds();
        int lineLength = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        double labelSpace = this.layer_.getXDtoP(15) - this.layer_.getXDtoP(0);
        yd[0] = bounds.y + 3 + this.maxLabelHeight_;
        yp[0] = this.layer_.getYDtoP(yd[0]);
        for (i = 1; i < numRows; ++i) {
            yd[i] = yd[i - 1] + 3 + this.maxLabelHeight_;
            yp[i] = this.layer_.getYDtoP(yd[i]);
        }
        xd[0] = bounds.x + 15;
        xp[0] = this.layer_.getXDtoP(xd[0]);
        for (i = 1; i < this.columns_; ++i) {
            xd[i] = xd[i - 1] + 10 + lineLength + 15 + this.maxLabelLength_;
            xp[i] = this.layer_.getXDtoP(xd[i]);
        }
        int row = 0;
        int col = 0;
        Enumeration labelIt = this.label_.elements();
        Enumeration lineIt = this.line_.elements();
        while (lineIt.hasMoreElements()) {
            Object obj = lineIt.nextElement();
            render = (LineCartesianRenderer)obj;
            attr = (LineAttribute)render.getAttribute();
            SGLabel label = (SGLabel)labelIt.nextElement();
            g.setColor(attr.getColor());
            xout[0] = xd[col];
            xout[1] = xout[0] + lineLength;
            yout[0] = yd[row] - this.maxLabelHeight_ / 2;
            yout[1] = yout[0];
            switch (attr.getStyle()) {
                case 4: {
                    render.drawMark(g, xout, yout, 2, attr);
                    break;
                }
                case 3: {
                    this.stroke_.drawHighlight(g, xout, yout, 2, attr);
                    break;
                }
                case 2: {
                    this.stroke_.drawHeavy(g, xout, yout, 2, attr);
                    break;
                }
                case 1: {
                    this.stroke_.drawDashed(g, xout, yout, 2, attr);
                    break;
                }
                case 6: {
                    this.stroke_.drawStroke(g, xout, yout, 2, attr);
                    break;
                }
                case 5: {
                    render.drawMark(g, xout, yout, 2, attr);
                }
                default: {
                    g.drawLine(xout[0], yout[0], xout[1], yout[1]);
                }
            }
            double xloc = xp[col] + this.lineLengthP_ + labelSpace;
            label.setLocationP(new Point2D.Double(xloc, yp[row]));
            try {
                label.draw(g);
            }
            catch (SGException sGException) {
                // empty catch block
            }
            if (++col < this.columns_) continue;
            col = 0;
            ++row;
        }
        switch (this.style_) {
            case 0: {
                g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    @Override
    public Rectangle getBounds() {
        int numLines = this.line_.size();
        if (numLines <= 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        this.maxLabelLength_ = 0;
        this.maxLabelHeight_ = 0;
        Enumeration it = this.label_.elements();
        while (it.hasMoreElements()) {
            SGLabel label = (SGLabel)it.nextElement();
            Rectangle sz = label.getBounds();
            this.maxLabelLength_ = Math.max(this.maxLabelLength_, sz.width);
            this.maxLabelHeight_ = Math.max(this.maxLabelHeight_, sz.height);
        }
        int rows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++rows;
        }
        int lineLength = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        int width = 30 + this.columns_ * (lineLength + 15 + this.maxLabelLength_) + (this.columns_ - 1) * 10;
        int height = 6 + rows * this.maxLabelHeight_ + (rows - 1) * 3;
        int x = this.layer_.getXPtoD(this.porigin_.x);
        int y = this.layer_.getYPtoD(this.porigin_.y);
        switch (this.halign_) {
            case 2: {
                x -= width;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y -= height;
                break;
            }
            case 1: {
                y -= height / 2;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    @Override
    public Point getLocation() {
        Rectangle bnds = this.getBounds();
        return new Point(bnds.x, bnds.y);
    }

    @Override
    public void setLocation(Point loc) {
        Rectangle bnds = this.getBounds();
        this.setBounds(loc.x, loc.y, bnds.width, bnds.height);
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        switch (this.halign_) {
            case 2: {
                x += width;
                break;
            }
            case 1: {
                x += width / 2;
            }
        }
        switch (this.valign_) {
            case 2: {
                y += height;
                break;
            }
            case 1: {
                y += height / 2;
            }
        }
        double xp = this.layer_.getXDtoP(x);
        double yp = this.layer_.getYDtoP(y);
        if (this.porigin_.x != xp || this.porigin_.y != yp) {
            Point2D.Double temp = this.porigin_;
            this.porigin_.x = xp;
            this.porigin_.y = yp;
            this.changes_.firePropertyChange("location", temp, new Point2D.Double(xp, yp));
            this.modified("LineKey: setBounds()");
        }
    }

    Object getObjectAt(Point pt) {
        int i;
        int numLines = this.line_.size();
        if (numLines <= 0) {
            return null;
        }
        int numRows = numLines / this.columns_;
        if (numLines % this.columns_ != 0) {
            ++numRows;
        }
        int[] xd = new int[this.columns_];
        int[] yd = new int[numRows];
        int[] xout = new int[2];
        int[] yout = new int[2];
        Rectangle bounds = this.getBounds();
        int lineLength = this.layer_.getXPtoD(this.lineLengthP_) - this.layer_.getXPtoD(0.0);
        double labelSpace = this.layer_.getXDtoP(15) - this.layer_.getXDtoP(0);
        yd[0] = bounds.y + 3 + this.maxLabelHeight_;
        for (i = 1; i < numRows; ++i) {
            yd[i] = yd[i - 1] + 3 + this.maxLabelHeight_;
        }
        xd[0] = bounds.x + 15;
        for (i = 1; i < this.columns_; ++i) {
            xd[i] = xd[i - 1] + 10 + lineLength + 15 + this.maxLabelLength_;
        }
        int row = 0;
        int col = 0;
        Enumeration lineIt = this.line_.elements();
        while (lineIt.hasMoreElements()) {
            LineCartesianRenderer line = (LineCartesianRenderer)lineIt.nextElement();
            xout[0] = xd[col];
            xout[1] = xout[0] + lineLength + 15 + this.maxLabelLength_;
            yout[0] = yd[row] - this.maxLabelHeight_;
            yout[1] = yd[row];
            Rectangle lbnds = new Rectangle(xout[0], yout[0], xout[1] - xout[0], yout[1] - yout[0]);
            if (lbnds.contains(pt)) {
                return line;
            }
            if (++col < this.columns_) continue;
            col = 0;
            ++row;
        }
        if (bounds.contains(pt)) {
            return this;
        }
        return null;
    }

    @Override
    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1) + ": " + this.ident_;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.visible_ != visible) {
            this.visible_ = visible;
            this.modified("LineKey: setVisible()");
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.modified("LineKey: propertyChange(" + evt.getSource().toString() + "[" + evt.getPropertyName() + "])");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes_.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes_.removePropertyChangeListener(l);
    }
}

