/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import graph.RTextLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import jplot.Translate;
import org.freehep.graphics2d.VectorGraphics;
import sgtplot.LabelDrawer;
import sgtplot.Layer;
import sgtplot.LayerNotFoundException;
import sgtplot.pmel.swing.MRJUtil;
import sgtplot.util.Point2D;
import sgtplot.util.Rectangle2D;

public class LabelDrawer2D
implements LabelDrawer,
Cloneable {
    private static final long serialVersionUID = 1L;
    private RTextLine text;
    private String label_;
    private Color clr_;
    private Font font_;
    private transient Layer layer_;
    private int orient_;
    private int halign_;
    private int valign_;
    private Point dorigin_;
    private Rectangle dbounds_;
    private Point2D.Double porigin_;
    private Rectangle2D.Double pbounds_;
    private Polygon dpolygon_;
    private double angle_;
    private double sinthta_;
    private double costhta_;
    private double height_;
    private boolean visible_;
    private static boolean fixMetrics_ = MRJUtil.fixFontMetrics();
    private int xoff_ = 0;
    private int yoff_ = 0;
    private boolean alwaysAntiAlias_ = false;
    private Rectangle savedBounds_ = null;
    private Point savedLoc_ = null;

    public LabelDrawer2D(String lbl, double hgt, Point2D.Double loc, int valign, int halign) {
        this.label_ = lbl;
        this.height_ = hgt;
        this.porigin_ = loc;
        this.valign_ = valign;
        this.halign_ = halign;
        this.text = new RTextLine();
        this.dbounds_ = new Rectangle();
        this.dorigin_ = new Point(0, 0);
        this.pbounds_ = new Rectangle2D.Double();
    }

    public LabelDrawer copy() {
        LabelDrawer newLabel = null;
        return newLabel;
    }

    @Override
    public void draw(VectorGraphics g) throws LayerNotFoundException {
        if (this.label_.length() <= 0 || !this.visible_ || g == null) {
            return;
        }
        if (this.layer_ == (Layer)null) {
            throw new LayerNotFoundException();
        }
        this.computeBoundsD(g);
        if (this.clr_ == null) {
            g.setColor(this.layer_.getPane().getComponent().getForeground());
        } else {
            g.setColor(this.clr_);
        }
        if (this.orient_ == 0) {
            int xs = this.dbounds_.x + this.xoff_;
            int ys = this.dbounds_.y + this.yoff_;
            this.drawString(g, xs, ys);
        } else if (this.orient_ == 1) {
            int xs = this.dbounds_.x + this.xoff_;
            int ys = this.dbounds_.y + this.yoff_;
            this.drawString(g, xs, ys);
        } else {
            int xs = this.layer_.getXPtoD(this.porigin_.x);
            int ys = this.layer_.getYPtoD(this.porigin_.y);
            this.drawString(g, xs, ys);
        }
    }

    @Override
    public void setText(String lbl) {
        this.label_ = lbl;
    }

    @Override
    public String getText() {
        return this.label_;
    }

    @Override
    public void setColor(Color clr) {
        this.clr_ = clr;
    }

    @Override
    public Color getColor() {
        return this.clr_;
    }

    @Override
    public void setFont(Font font) {
        this.font_ = font;
    }

    @Override
    public Font getFont() {
        return this.font_;
    }

    @Override
    public void setLayer(Layer layer) {
        this.layer_ = layer;
        if (this.savedBounds_ != null) {
            this.setBounds(this.savedBounds_.x, this.savedBounds_.y, this.savedBounds_.width, this.savedBounds_.height);
            this.savedBounds_ = null;
        }
        if (this.savedLoc_ != null) {
            this.setLocation(this.savedLoc_);
            this.savedLoc_ = null;
        }
    }

    @Override
    public Layer getLayer() {
        return this.layer_;
    }

    @Override
    public void setOrientation(int orient) {
        if (this.orient_ != orient) {
            if (orient == 0) {
                this.costhta_ = 1.0;
                this.sinthta_ = 0.0;
            } else if (orient == 1) {
                this.costhta_ = 0.0;
                this.sinthta_ = 1.0;
            }
            this.orient_ = orient;
        }
    }

    @Override
    public int getOrientation() {
        return this.orient_;
    }

    @Override
    public void setHAlign(int halign) {
        this.halign_ = halign;
    }

    @Override
    public int getHAlign() {
        return this.halign_;
    }

    @Override
    public void setVAlign(int valign) {
        this.valign_ = valign;
    }

    @Override
    public int getVAlign() {
        return this.valign_;
    }

    @Override
    public void setLocation(Point loc) {
        if (this.layer_ == null) {
            this.savedLoc_ = new Point(loc);
            return;
        }
        this.computeBoundsD(VectorGraphics.create((Graphics)this.layer_.getPane().getComponent().getGraphics()));
        if (this.dbounds_.x != loc.x || this.dbounds_.y != loc.y) {
            this.setBounds(loc.x, loc.y, this.dbounds_.width, this.dbounds_.height);
        }
    }

    @Override
    public Point getLocation() {
        if (this.savedLoc_ != null) {
            return this.savedLoc_;
        }
        return this.dorigin_;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int yd;
        int xd;
        if (this.layer_ == null) {
            this.savedBounds_ = new Rectangle(x, y, width, height);
            return;
        }
        Graphics g = this.layer_.getPane().getComponent().getGraphics();
        if (g == null) {
            return;
        }
        VectorGraphics g2 = VectorGraphics.create((Graphics)g);
        this.font_ = this.computeFontSize(g2);
        FontRenderContext frc = this.getFontRenderContext(g2);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        int theight = (int)tbounds.getHeight();
        int twidth = (int)tbounds.getWidth();
        int tx = (int)tbounds.getX();
        int ty = (int)tbounds.getY();
        if (fixMetrics_) {
            ty -= (int)(0.7 * (double)tlayout.getAscent());
        }
        int sascent = (int)tlayout.getAscent();
        if (this.orient_ == 0) {
            int swidth = width;
            xd = x;
            yd = y - ty;
            switch (this.valign_) {
                case 0: {
                    yd -= sascent;
                    break;
                }
                case 1: {
                    yd += ty + theight / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    xd += swidth;
                    break;
                }
                case 1: {
                    xd += swidth / 2;
                    break;
                }
            }
        } else {
            int swidth = height;
            yd = y + height;
            xd = x - ty;
            switch (this.valign_) {
                case 0: {
                    xd -= sascent;
                    break;
                }
                case 1: {
                    xd -= sascent / 2;
                    break;
                }
            }
            switch (this.halign_) {
                case 2: {
                    yd -= swidth;
                    break;
                }
                case 1: {
                    yd -= swidth / 2;
                    break;
                }
            }
        }
        if (this.dorigin_.x != xd || this.dorigin_.y != yd) {
            this.dorigin_.x = xd;
            this.dorigin_.y = yd;
            this.porigin_.x = this.layer_.getXDtoP(xd);
            this.porigin_.y = this.layer_.getYDtoP(yd);
        }
    }

    @Override
    public Rectangle getBounds() {
        if (this.savedBounds_ != null) {
            return this.savedBounds_;
        }
        if (this.layer_ != null) {
            this.computeBoundsD(VectorGraphics.create((Graphics)this.layer_.getPane().getComponent().getGraphics()));
        }
        return this.dbounds_;
    }

    @Override
    public void setLocationP(Point2D.Double loc) {
        this.porigin_ = loc;
    }

    @Override
    public Point2D.Double getLocationP() {
        return this.porigin_;
    }

    @Override
    public Rectangle2D.Double getBoundsP() {
        this.computeBoundsD(VectorGraphics.create((Graphics)this.layer_.getPane().getComponent().getGraphics()));
        return this.pbounds_;
    }

    @Override
    public void setAngle(double angle) {
        this.angle_ = angle;
        double thta = this.angle_ * Math.PI / 180.0;
        if (Math.abs(thta) < 0.001) {
            this.orient_ = 0;
            this.costhta_ = 1.0;
            this.sinthta_ = 0.0;
        } else if (Math.abs(thta - 90.0) < 0.001) {
            this.orient_ = 1;
            this.costhta_ = 0.0;
            this.sinthta_ = 1.0;
        } else {
            this.orient_ = 2;
            this.costhta_ = Math.cos(thta);
            this.sinthta_ = Math.sin(thta);
        }
    }

    @Override
    public double getAngle() {
        return this.angle_;
    }

    @Override
    public void setHeightP(double hgt) {
        this.height_ = hgt;
    }

    @Override
    public double getHeightP() {
        return this.height_;
    }

    @Override
    public void setVisible(boolean vis) {
        this.visible_ = vis;
    }

    @Override
    public boolean isVisible() {
        return this.visible_;
    }

    private void computeBoundsD(VectorGraphics g2) {
        int[] xt = new int[4];
        int[] yt = new int[4];
        int[] xn = new int[4];
        int[] yn = new int[4];
        if (g2 == null) {
            return;
        }
        this.font_ = this.computeFontSize(g2);
        FontRenderContext frc = this.getFontRenderContext(g2);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        int theight = (int)tbounds.getHeight();
        int twidth = (int)tbounds.getWidth();
        int tx = (int)tbounds.getX();
        int ty = (int)tbounds.getY();
        if (fixMetrics_) {
            ty -= (int)(0.7 * (double)tlayout.getAscent());
        }
        int sascent = (int)tlayout.getAscent();
        int xd = this.layer_.getXPtoD(this.porigin_.x);
        int yd = this.layer_.getYPtoD(this.porigin_.y);
        this.dorigin_.x = xd;
        this.dorigin_.y = yd;
        int xorig = xd;
        int yorig = yd;
        switch (this.valign_) {
            case 0: {
                yd += sascent;
                break;
            }
            case 1: {
                yd -= ty + theight / 2;
                break;
            }
        }
        switch (this.halign_) {
            case 2: {
                xd -= twidth;
                break;
            }
            case 1: {
                xd -= twidth / 2;
                break;
            }
        }
        if (this.orient_ == 0) {
            this.xoff_ = 0;
            this.yoff_ = -ty;
        } else if (this.orient_ == 1) {
            this.xoff_ = -ty;
            this.yoff_ = twidth;
        }
        xt[0] = xd + tx;
        xt[1] = xt[0];
        xt[2] = xt[0] + twidth;
        xt[3] = xt[2];
        yt[0] = yd + ty;
        yt[1] = yt[0] + theight;
        yt[2] = yt[1];
        yt[3] = yt[0];
        for (int i = 0; i < 4; ++i) {
            xn[i] = (int)((double)(xt[i] - xorig) * this.costhta_ + (double)(yt[i] - yorig) * this.sinthta_) + xorig;
            yn[i] = (int)((double)(yt[i] - yorig) * this.costhta_ - (double)(xt[i] - xorig) * this.sinthta_) + yorig;
        }
        this.dpolygon_ = new Polygon(xn, yn, 4);
        this.dbounds_ = this.dpolygon_.getBounds();
        this.pbounds_.x = this.layer_.getXDtoP(this.dbounds_.x);
        this.pbounds_.y = this.layer_.getYDtoP(this.dbounds_.y);
        this.pbounds_.width = this.layer_.getXDtoP(this.dbounds_.x + this.dbounds_.width) - this.pbounds_.x;
        this.pbounds_.height = this.pbounds_.y - this.layer_.getYDtoP(this.dbounds_.y + this.dbounds_.height);
    }

    Font computeFontSize(VectorGraphics g2) {
        FontRenderContext frc = this.getFontRenderContext(g2);
        if (g2 == null) {
            return this.font_;
        }
        int hgt = this.layer_.getXPtoD(this.height_) - this.layer_.getXPtoD(0.0);
        int pt_0 = hgt - 3;
        Font tfont = new Font(this.font_.getName(), this.font_.getStyle(), pt_0);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", tfont, frc) : new TextLayout(this.label_, tfont, frc);
        hgt = (int)(tlayout.getAscent() + tlayout.getDescent());
        double hgt_0 = this.layer_.getXDtoP(hgt) - this.layer_.getXDtoP(0);
        pt_0 = tfont.getSize();
        int pt_1 = (int)((double)pt_0 * (this.height_ / hgt_0));
        for (int count = 1; pt_0 != pt_1 && count < 5; ++count) {
            tfont = new Font(this.font_.getName(), this.font_.getStyle(), pt_1);
            tlayout = this.label_.length() == 0 ? new TextLayout(" ", tfont, frc) : new TextLayout(this.label_, tfont, frc);
            hgt = (int)(tlayout.getAscent() + tlayout.getDescent());
            double hgt_1 = this.layer_.getXDtoP(hgt) - this.layer_.getXDtoP(0);
            double del_0 = Math.abs(this.height_ - hgt_0);
            double del_1 = Math.abs(this.height_ - hgt_1);
            if (Math.abs(pt_0 - pt_1) <= 1 && del_0 > del_1) {
                return tfont;
            }
            pt_0 = pt_1;
            hgt_0 = hgt_1;
            pt_1 = (int)((double)pt_0 * (this.height_ / hgt_0));
        }
        return tfont;
    }

    private void drawString(VectorGraphics g2, int x, int y) {
        if (g2 == null) {
            return;
        }
        float angle = this.orient_ == 0 ? 0.0f : (this.orient_ == 1 ? -90.0f : -((float)this.angle_));
        AffineTransform oldTransform = g2.getTransform();
        g2.translate(x, y);
        g2.rotate(Math.PI * (double)angle / 180.0);
        this.text.setText(Translate.decode(this.label_));
        this.text.setFont(this.font_);
        this.text.setColor(this.clr_);
        this.text.draw(g2, 0, 0);
        g2.setTransform(oldTransform);
    }

    @Override
    public float getStringWidth(VectorGraphics g) {
        if (g == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(g);
        FontRenderContext frc = this.getFontRenderContext(g);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        return (float)tbounds.getWidth();
    }

    @Override
    public float getStringHeight(VectorGraphics g2) {
        if (g2 == null) {
            return 0.0f;
        }
        this.font_ = this.computeFontSize(g2);
        FontRenderContext frc = this.getFontRenderContext(g2);
        TextLayout tlayout = this.label_.length() == 0 ? new TextLayout(" ", this.font_, frc) : new TextLayout(this.label_, this.font_, frc);
        Rectangle2D tbounds = tlayout.getBounds();
        return (float)tbounds.getHeight();
    }

    FontRenderContext getFontRenderContext(VectorGraphics g2) {
        if (g2 == null) {
            return null;
        }
        RenderingHints oldRenderingHints = null;
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            oldRenderingHints = g2.getRenderingHints();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        FontRenderContext frc = g2.getFontRenderContext();
        if (this.angle_ != 0.0 || this.alwaysAntiAlias_) {
            g2.setRenderingHints((Map)oldRenderingHints);
        }
        return frc;
    }
}

