/*
 * Decompiled with CFR 0.152.
 */
package sgtplot;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sgtplot.ContourLevelNotFoundException;
import sgtplot.ContourLineAttribute;
import sgtplot.DefaultContourLineAttribute;
import sgtplot.MethodNotImplementedError;
import sgtplot.util.Range2D;

public class ContourLevels
implements Cloneable {
    private DefaultContourLineAttribute defaultAttr_ = new DefaultContourLineAttribute();
    private Vector levels_ = new Vector();
    private Hashtable lineAttrMap_ = new Hashtable();
    private boolean sorted_ = false;
    private static ContourLineAttribute solid_ = new ContourLineAttribute(0);
    private static ContourLineAttribute heavy_ = new ContourLineAttribute(2);
    private static ContourLineAttribute dashed_ = new ContourLineAttribute(1);
    private PropertyChangeSupport changes_ = new PropertyChangeSupport(this);
    private ContourLineAttribute lnkLineAttribute;

    public static ContourLevels getDefault(double[] array) {
        ContourLevels cl = new ContourLevels();
        double val = 0.0;
        for (int i = 0; i < array.length; ++i) {
            cl.addLevel(array[i]);
        }
        return cl;
    }

    public static ContourLevels getDefault(Range2D range) {
        ContourLevels cl = new ContourLevels();
        for (double val = range.start; val <= range.end; val += range.delta) {
            cl.addLevel(val);
        }
        return cl;
    }

    public ContourLevels copy() {
        ContourLevels newcls;
        try {
            newcls = (ContourLevels)this.clone();
            newcls.levels_ = (Vector)this.levels_.clone();
            newcls.lineAttrMap_ = (Hashtable)this.lineAttrMap_.clone();
        }
        catch (CloneNotSupportedException e) {
            newcls = null;
        }
        return newcls;
    }

    public Enumeration levelElements() {
        if (!this.sorted_) {
            this.sort();
        }
        return this.levels_.elements();
    }

    public void setContourLineAttribute(double val, ContourLineAttribute l) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void setContourLineAttribute(int indx, ContourLineAttribute l) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public ContourLineAttribute getContourLineAttribute(double val) throws ContourLevelNotFoundException {
        ContourLineAttribute attr = (ContourLineAttribute)this.lineAttrMap_.get(new Double(val));
        if (attr == null) {
            throw new ContourLevelNotFoundException();
        }
        return attr;
    }

    public ContourLineAttribute getContourLineAttribute(int indx) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.getContourLineAttribute(this.getLevel(indx));
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute() {
        return this.defaultAttr_;
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute(int indx) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.defaultAttr_.setContourLineAttribute(this.getContourLineAttribute(this.getLevel(indx)));
    }

    public DefaultContourLineAttribute getDefaultContourLineAttribute(double val) throws ContourLevelNotFoundException {
        if (!this.sorted_) {
            this.sort();
        }
        return this.defaultAttr_.setContourLineAttribute(this.getContourLineAttribute(val));
    }

    public void setDefaultContourLineAttribute(DefaultContourLineAttribute attr) {
        this.defaultAttr_ = attr;
    }

    public void addLevel(double val) {
        ContourLineAttribute attr = null;
        attr = val < 0.0 ? (ContourLineAttribute)dashed_.copy() : (val > 0.0 ? (ContourLineAttribute)solid_.copy() : (ContourLineAttribute)heavy_.copy());
        attr.setStyleOverridden(true);
        this.addLevel(val, attr);
    }

    public void addLevel(double val, ContourLineAttribute l) {
        Double value = new Double(val);
        this.levels_.addElement(value);
        this.lineAttrMap_.put(value, l);
        this.sorted_ = false;
    }

    public double getLevel(int indx) throws ContourLevelNotFoundException {
        if (indx < 0 || indx >= this.levels_.size()) {
            throw new ContourLevelNotFoundException();
        }
        if (!this.sorted_) {
            this.sort();
        }
        Double value = (Double)this.levels_.elementAt(indx);
        return value;
    }

    public void removeLevel(double val) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public void removeLevel(int indx) throws ContourLevelNotFoundException {
        throw new MethodNotImplementedError();
    }

    public int getIndex(Double dval) {
        if (!this.sorted_) {
            this.sort();
        }
        return this.levels_.indexOf(dval);
    }

    public int getIndex(double val) {
        if (!this.sorted_) {
            this.sort();
        }
        return this.getIndex(new Double(val));
    }

    public int getMaximumIndex() {
        return this.levels_.size() - 1;
    }

    public Range2D getRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.levels_.size(); ++i) {
            double value = (Double)this.levels_.get(i);
            min = Math.min(min, value);
            max = Math.max(max, value);
        }
        return new Range2D(min, max);
    }

    public int size() {
        return this.levels_.size();
    }

    private void sort() {
        int i;
        int size = this.levels_.size();
        int[] index = new int[size];
        boolean flipped = true;
        for (i = 0; i < size; ++i) {
            index[i] = i;
        }
        while (flipped) {
            flipped = false;
            for (i = 0; i < size - 1; ++i) {
                Double a = (Double)this.levels_.elementAt(index[i]);
                Double b = (Double)this.levels_.elementAt(index[i + 1]);
                if (!(a > b)) continue;
                int temp = index[i];
                index[i] = index[i + 1];
                index[i + 1] = temp;
                flipped = true;
            }
        }
        Vector oldValues = this.levels_;
        this.levels_ = new Vector(size);
        for (i = 0; i < size; ++i) {
            this.levels_.addElement(oldValues.elementAt(index[i]));
        }
        this.sorted_ = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changes_.removePropertyChangeListener(listener);
    }
}

