/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.text.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.PatternSyntaxException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.text.XStringBufBase;
import org.clapper.util.text.XStringBuffer;
import org.clapper.util.text.XStringBuilder;

public class XString
extends CommandLineUtility {
    private Type type = Type.BUILDER;
    private Collection<String> strings = new ArrayList<String>();

    private XString() {
    }

    public static void main(String[] args) {
        XString tester = new XString();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            this.runTest();
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        switch (shortOption) {
            case 't': {
                String sType = it.next();
                if (sType.equals("XStringBuffer")) {
                    this.type = Type.BUFFER;
                    break;
                }
                if (sType.equals("XStringBuilder")) {
                    this.type = Type.BUILDER;
                    break;
                }
                throw new CommandLineUsageException("Bad value of \"" + (Object)((Object)this.type) + "\" for -t");
            }
            default: {
                throw new CommandLineUsageException("Unrecognized option");
            }
        }
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        do {
            this.strings.add(it.next());
        } while (it.hasNext());
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addOption('t', "type", "XStringBuffer|XStringBuilder", "Specify the type of object to test. Defaults to XStringBuilder");
        info.addParameter("string ...", "String to append to buffer. May be specified more than once.", true);
    }

    private void runTest() throws PatternSyntaxException {
        XStringBufBase buf = null;
        switch (this.type) {
            case BUFFER: {
                buf = new XStringBuffer();
                break;
            }
            case BUILDER: {
                buf = new XStringBuilder();
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        StringBuilder control = new StringBuilder();
        for (String s : this.strings) {
            control.append(s);
        }
        System.out.println("Testing " + buf.getClass());
        System.out.println();
        System.out.println("Testing append(String)");
        for (String s : this.strings) {
            System.out.println("Appending \"" + s + "\"");
            System.out.println("Before: \"" + buf + "\"");
            buf.append(s);
            System.out.println("After: \"" + buf + "\"");
        }
        assert (control.toString().equals(buf.toString()));
        buf.clear();
        System.out.println();
        System.out.println("Testing append(char)");
        for (String s : this.strings) {
            System.out.println("Appending \"" + s + "\"");
            System.out.println("Before: \"" + buf + "\"");
            char[] ch = s.toCharArray();
            for (int i = 0; i < ch.length; ++i) {
                buf.append(ch[i]);
            }
            System.out.println("After: \"" + buf + "\"");
        }
        assert (control.toString().equals(buf.toString()));
    }

    private static enum Type {
        BUILDER,
        BUFFER;

    }
}

