/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.regex.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.regex.RegexException;
import org.clapper.util.regex.RegexUtil;

public class TestRegexUtil
extends CommandLineUtility {
    private String substitution;
    private Collection<String> strings = new ArrayList<String>();

    public static void main(String[] args) {
        TestRegexUtil tester = new TestRegexUtil();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestRegexUtil() {
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            RegexUtil ru = new RegexUtil();
            LineReaderIterator it = this.strings.size() == 0 ? new LineReaderIterator(System.in) : this.strings.iterator();
            while (it.hasNext()) {
                String s1 = (String)it.next();
                String s2 = ru.substitute(this.substitution, s1);
                System.out.println();
                System.out.println("Substitution: " + this.substitution);
                System.out.println("Before:       " + s1);
                System.out.println("After:        " + s2);
                System.out.flush();
            }
        }
        catch (IOException ex) {
            throw new CommandLineException(ex);
        }
        catch (RegexException ex) {
            throw new CommandLineException(ex);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        throw new CommandLineUsageException("Unrecognized option");
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        this.substitution = it.next();
        while (it.hasNext()) {
            this.strings.add(it.next());
        }
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addParameter("s/re/repl/[g][i][m][o][x]", "Substitution command to execute on strings", true);
        info.addParameter("[string] ...", "One or more strings to execute substitution command line. If not present, then lines from standard input are read, instead.", false);
    }

    class LineReaderIterator
    implements Iterator {
        LineNumberReader r;
        String nextLine;

        LineReaderIterator(InputStream is) throws IOException {
            this.r = new LineNumberReader(new InputStreamReader(is));
            this.nextLine = this.r.readLine();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        public Object next() {
            String lastLine = this.nextLine;
            try {
                if (lastLine != null) {
                    this.nextLine = this.r.readLine();
                }
            }
            catch (IOException ex) {
                System.err.println("*** " + ex.toString());
                this.nextLine = null;
            }
            return lastLine;
        }
    }
}

