/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.misc.ObjectLockSemaphore;
import org.clapper.util.misc.Semaphore;
import org.clapper.util.misc.SemaphoreException;

public class TestSemaphore
extends CommandLineUtility {
    private int semCount = 0;
    private int nThreads = 0;
    private int holdTime = 0;
    private int pendTime = 0;
    private Semaphore semaphore = null;
    private Semaphore parentSem = null;

    public static void main(String[] args) {
        TestSemaphore tester = new TestSemaphore();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestSemaphore() {
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            int i;
            TestThread[] threads = new TestThread[this.nThreads];
            this.semaphore = new ObjectLockSemaphore(this.semCount);
            this.parentSem = new ObjectLockSemaphore(0);
            int myPriority = Thread.currentThread().getPriority();
            for (i = 0; i < this.nThreads; ++i) {
                String name = new String("Thread-" + i);
                this.message("Spawning thread " + name);
                threads[i] = new TestThread(name);
                threads[i].setPriority(1);
            }
            for (i = 0; i < this.nThreads; ++i) {
                this.message("Starting thread " + threads[i].getName());
                threads[i].start();
            }
            this.message("Waiting for the child threads.");
            for (i = 0; i < this.nThreads; ++i) {
                this.parentSem.acquire();
            }
            this.message("Checking final count on semaphore.");
            int val = this.semaphore.getValue();
            if (val != this.semCount) {
                throw new Exception("Count mismatch: Value is " + val + ", expected " + this.semCount);
            }
            this.message("OK");
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        throw new IllegalStateException("(BUG) Unknown option: " + shortOption);
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        this.semCount = this.parseIntParameter(it.next());
        this.nThreads = this.parseIntParameter(it.next());
        this.holdTime = this.parseIntParameter(it.next());
        this.pendTime = this.parseIntParameter(it.next());
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addParameter("semCount", "Initial value of semaphore", true);
        info.addParameter("nThreads", "Number of threads to spawn", true);
        info.addParameter("holdTime", "How long, in milliseconds, a thread should hold a semaphore.", true);
        info.addParameter("pendTime", "How long, in milliseconds, a thread should wait to acquire a semaphore. 0 means forever.", true);
    }

    private synchronized void message(String s) {
        SimpleDateFormat fmt = new SimpleDateFormat("hh:mm:ss");
        System.out.println(fmt.format(new Date()) + " (" + Thread.currentThread().getName() + ") " + s);
    }

    class TestThread
    extends Thread {
        TestThread(String name) {
            this.setName(name);
        }

        @Override
        public void run() {
            try {
                this.doTest();
            }
            catch (SemaphoreException ex) {
                this.message("*** semaphore error: " + ex.toString());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        private void doTest() throws SemaphoreException {
            boolean acquired = false;
            Semaphore semaphore = TestSemaphore.this.semaphore;
            Semaphore parentSem = TestSemaphore.this.parentSem;
            int holdTime = TestSemaphore.this.holdTime;
            int pendTime = TestSemaphore.this.pendTime;
            this.message("Acquiring " + semaphore.toString() + ", pendTime = " + pendTime);
            acquired = semaphore.acquire(pendTime);
            if (!acquired) {
                this.message("*** Failed to acquire semaphore.");
            } else {
                Class<TestSemaphore> clazz = TestSemaphore.class;
                // MONITORENTER : org.clapper.util.misc.test.TestSemaphore.class
                this.message("Got semaphore " + semaphore + ". Waiting " + holdTime + " milliseconds.");
                // MONITOREXIT : clazz
                try {
                    Thread.yield();
                    Thread.sleep(holdTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                clazz = TestSemaphore.class;
                // MONITORENTER : org.clapper.util.misc.test.TestSemaphore.class
                this.message("Releasing semaphore " + semaphore + ".");
                // MONITOREXIT : clazz
                semaphore.release();
            }
            this.message("Notifying parent.");
            parentSem.release();
            this.message("Exiting.");
        }

        private void message(String s) {
            TestSemaphore.this.message(s);
        }
    }
}

