/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.misc.test;

import java.io.IOException;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.logging.LogLevel;
import org.clapper.util.logging.Logger;
import org.clapper.util.misc.FileHashMap;
import org.clapper.util.misc.ObjectExistsException;
import org.clapper.util.misc.VersionMismatchException;

public class TestFileHashMap
extends CommandLineUtility {
    private static final int DEFAULT_ENTRY_PADDING = 1024;
    private static final DecimalFormat KEY_FMT = new DecimalFormat("#00000");
    private static final DecimalFormat AVG_FMT = new DecimalFormat("#0.000");
    private static String filePrefix;
    private static long startTime;
    private static int fileHashMapFlags;
    private static int paddingSize;
    private static int totalValues;
    private static boolean verbose;
    private static boolean readOnly;
    private static boolean useDisk;
    private static boolean useMemory;
    private static boolean clearFirst;
    private static Logger log;

    public static void main(String[] args) {
        TestFileHashMap tester = new TestFileHashMap();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private TestFileHashMap() {
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            this.runTest();
        }
        catch (Exception ex) {
            throw new CommandLineException(ex);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        switch (shortOption) {
            case 'c': {
                clearFirst = true;
                break;
            }
            case 'd': {
                useMemory = false;
                useDisk = true;
                break;
            }
            case 'g': {
                fileHashMapFlags |= 8;
                break;
            }
            case 'm': {
                useMemory = true;
                useDisk = false;
                break;
            }
            case 'n': {
                fileHashMapFlags |= 1;
                break;
            }
            case 'o': {
                fileHashMapFlags |= 4;
                break;
            }
            case 'p': {
                paddingSize = this.parseIntParameter(it.next());
                break;
            }
            case 'r': {
                readOnly = true;
                break;
            }
            case 't': {
                fileHashMapFlags |= 2;
                break;
            }
            case 'v': {
                verbose = true;
                break;
            }
            default: {
                throw new CommandLineUsageException("Unrecognized option");
            }
        }
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        totalValues = this.parseIntParameter(it.next());
        if (it.hasNext()) {
            filePrefix = it.next();
        } else if ((fileHashMapFlags & 2) == 0) {
            throw new CommandLineUsageException("Must specify a file prefix unless -t is specified.");
        }
        if (readOnly && (fileHashMapFlags & 2) != 0) {
            throw new CommandLineUsageException("You cannot specify both -r and -t");
        }
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addOption('c', "clear", "Clear the FileHashMap after loading it from disk initially.");
        info.addOption('d', "disk-only", "Use a FileHashMap table only. Don't use an in-memory hash table.");
        info.addOption('g', "reuse-gaps", "Pass the RECLAIM_FILE_GAPS flag to the FileHashMap constructor");
        info.addOption('m', "mem-only", "Use an in-memory hash table only. Don't use a FileHashMap.");
        info.addOption('n', "no-create", "Pass the NO_CREATE flag to the FileHashMap constructor");
        info.addOption('p', "padding", "<n>", "Specify the number of bytes by which to pad each entry. This is useful for increasing the footprint of each entry, to test the difference between an in-memory and a disk resident map. Default value: 1024");
        info.addOption('o', "overwrite", "Pass the FORCE_OVERWRITE flag to the FileHashMap constructor");
        info.addOption('r', "read-only", "Display the contents of an existing map, but don't modify it. Cannot be specified with -t");
        info.addOption('t', "transient", "Use a transient hash map");
        info.addOption('v', "verbose", "Enable verbose messages");
        info.addParameter("totalEntries", "Total number of keys and synthesized values to stuff in the hash table.", true);
        info.addParameter("filePrefix", "File prefix to use. Required unless -t is specified.", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest() throws IOException, ClassNotFoundException, ObjectExistsException, VersionMismatchException {
        HashMap memoryHash = null;
        FileHashMap<String, Entry> fileHash = null;
        try {
            long ms;
            this.msgln("RUNNING TEST");
            this.msgln("");
            this.msgln("Total entries to be inserted: " + totalValues);
            this.msgln("Element padding size:         " + paddingSize + " bytes");
            this.msgln("----------------------------------------------");
            if (useMemory) {
                this.msgln("Creating in-memory hash table ...");
                this.startTimer();
                memoryHash = new HashMap();
                ms = this.stopTimer();
                this.msgln("Done. Elapsed time: " + ms + " ms");
            }
            if (useDisk) {
                this.msgln("");
                this.msgln("----------------------------------------------");
                this.msgln("Creating on-disk hash table ... ");
                this.startTimer();
                fileHash = (fileHashMapFlags & 2) != 0 ? (filePrefix == null ? new FileHashMap<String, Entry>() : new FileHashMap(filePrefix)) : new FileHashMap(filePrefix, fileHashMapFlags);
                ms = this.stopTimer();
                this.msgln("Done. Elapsed time: " + ms + " ms");
                if (fileHash.size() > 0) {
                    this.msgln("----------------------------------------------");
                    if (clearFirst) {
                        this.msgln("File hash isn't empty. Clearing it.");
                        this.startTimer();
                        fileHash.clear();
                        ms = this.stopTimer();
                        this.msgln("Done. Elapsed time: " + ms + " ms");
                    } else {
                        this.msgln("File hash isn't empty. Dumping it.");
                        this.dumpTableByKeySet(fileHash, "On-disk table");
                    }
                }
            }
            if (!readOnly) {
                this.fillTables(memoryHash, (Map<String, Entry>)fileHash);
            }
            this.dumpTables(memoryHash, (Map<String, Entry>)fileHash);
            if (useDisk) {
                this.msgln("");
                this.msgln("----------------------------------------------");
                this.msgln("Closing on-disk hash table ... ");
                this.startTimer();
                fileHash.close();
                ms = this.stopTimer();
                this.msgln("Done. Elapsed time: " + ms + " ms");
            }
        }
        finally {
            if (fileHash != null) {
                fileHash.close();
                fileHash = null;
            }
        }
    }

    private void fillTables(Map<String, Entry> memoryHash, Map<String, Entry> fileHash) {
        if (memoryHash != null) {
            this.fillTable(memoryHash, "in-memory");
        }
        if (fileHash != null) {
            this.fillTable(fileHash, "on-disk");
        }
    }

    private void fillTable(Map<String, Entry> map, String mapName) {
        int i;
        long msAccum = 0L;
        this.msgln("");
        this.msgln("Filling " + mapName + " table ...");
        for (i = 1; i <= totalValues; ++i) {
            String key = KEY_FMT.format(new Integer(i));
            Entry value = new Entry(key, paddingSize);
            this.verboseln("    Putting key=\"" + key + "\", value=" + value.toString() + " into " + mapName);
            this.startTimer();
            Entry old = map.put(key, value);
            long ms = this.stopTimer();
            this.verboseln("    Elapsed time: " + ms + " ms");
            if (old != null) {
                this.verboseln("    (previous value was \"" + old + "\")");
            }
            msAccum += ms;
        }
        this.msgln("(Done.)");
        this.msgln("Total entries:             " + totalValues);
        this.msgln("Total insert time:         " + msAccum + " ms");
        this.msgln("Avg insert time per entry: " + this.getAverage(msAccum, i) + " ms");
    }

    private void dumpTables(Map<String, Entry> memoryHash, Map<String, Entry> fileHash) {
        this.msgln("");
        this.msgln("----------------------------------------------");
        this.msgln("Walking hash table(s) using a key set.");
        if (memoryHash != null) {
            this.dumpTableByKeySet(memoryHash, "In-memory table");
        }
        if (fileHash != null) {
            this.dumpTableByKeySet(fileHash, "On-disk table");
        }
        this.msgln("");
        this.msgln("----------------------------------------------");
        this.msgln("Walking hash table(s) using a value set.");
        if (memoryHash != null) {
            this.dumpTableByValueSet(memoryHash, "In-memory table");
        }
        if (fileHash != null) {
            this.dumpTableByValueSet(fileHash, "On-disk table");
        }
        this.msgln("");
        this.msgln("----------------------------------------------");
        this.msgln("Walking hash table(s) using an entry set.");
        if (memoryHash != null) {
            this.dumpTableByEntrySet(memoryHash, "In-memory table");
        }
        if (fileHash != null) {
            this.dumpTableByEntrySet(fileHash, "On-disk table");
        }
        this.msgln("");
        this.msgln("----------------------------------------------");
        this.msgln("Walking hash table(s) non-sequentially.");
        if (memoryHash != null) {
            this.dumpTableNonSequentially(memoryHash, "In-memory table");
        }
        if (fileHash != null) {
            this.dumpTableNonSequentially(fileHash, "On-disk table");
        }
    }

    private void dumpTableByKeySet(Map<String, Entry> map, String label) {
        if (map.size() == 0) {
            this.msgln(label + " is empty");
        } else {
            this.msgln("");
            this.msgln(label);
            this.verboseln("(key -> value)");
            long ms = 0L;
            int i = 0;
            for (String key : map.keySet()) {
                this.startTimer();
                Entry value = map.get(key);
                ms += this.stopTimer();
                this.verboseln("    \"" + key + "\" -> \"" + value + "\"");
                ++i;
            }
            this.msgln("");
            this.msgln("Total entries:             " + i);
            this.msgln("Total access time:         " + ms + " ms");
            this.msgln("Avg access time per entry: " + this.getAverage(ms, i) + " ms");
            if (map.size() != i) {
                throw new IllegalStateException("Dumped more values than table says it contains! map.size() returns " + map.size());
            }
        }
    }

    private void dumpTableByValueSet(Map<String, Entry> map, String label) {
        if (map.size() == 0) {
            this.msgln(label + " is empty");
        } else {
            this.msgln("");
            this.msgln(label);
            this.verboseln("(values only):");
            long ms = 0L;
            int i = 0;
            Iterator<Entry> it = map.values().iterator();
            while (it.hasNext()) {
                this.startTimer();
                Entry value = it.next();
                ms += this.stopTimer();
                this.verboseln("    \"" + value + "\"");
                ++i;
            }
            this.msgln("");
            this.msgln("Total entries:             " + i);
            this.msgln("Total access time:         " + ms + " ms");
            this.msgln("Avg access time per entry: " + this.getAverage(ms, i) + " ms");
            if (map.size() != i) {
                throw new IllegalStateException("Dumped more values than table says it contains! map.size() returns " + map.size());
            }
        }
    }

    private void dumpTableByEntrySet(Map<String, Entry> map, String label) {
        if (map.size() == 0) {
            this.msgln(label + " is empty");
        } else {
            this.msgln("");
            this.msgln(label);
            this.verboseln("(key -> value)");
            long ms = 0L;
            int i = 0;
            Iterator<Map.Entry<String, Entry>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                this.startTimer();
                Map.Entry<String, Entry> entry = it.next();
                String key = entry.getKey();
                Entry value = entry.getValue();
                ms += this.stopTimer();
                this.verboseln("    \"" + key + "\" -> \"" + value + "\"");
                ++i;
            }
            this.msgln("");
            this.msgln("Total entries:             " + i);
            this.msgln("Total access time:         " + ms + " ms");
            this.msgln("Avg access time per entry: " + this.getAverage(ms, i) + " ms");
            if (map.size() != i) {
                throw new IllegalStateException("Dumped more values than table says it contains! map.size() returns " + map.size());
            }
        }
    }

    private void dumpTableNonSequentially(Map map, String label) {
        int middle;
        Object[] keys = map.keySet().toArray();
        int top = 0;
        int m = middle = keys.length / 2;
        long ms = 0L;
        int total = 0;
        while (top < middle || m < keys.length) {
            Object value;
            Object key;
            if (top < middle) {
                key = keys[top];
                this.startTimer();
                value = map.get(key);
                ms += this.stopTimer();
                this.verboseln("(top) Key #" + top + "=\"" + key + "\" -> \"" + value + "\"");
                ++total;
                ++top;
            }
            if (m >= keys.length) continue;
            key = keys[m];
            this.startTimer();
            value = map.get(key);
            ms += this.stopTimer();
            this.verboseln("(mid) Key #" + m + "=\"" + key + "\" -> \"" + value + "\"");
            ++total;
            ++m;
        }
        if (total != keys.length) {
            throw new IllegalStateException("Dumped " + total + " values, but table  contains " + map.size() + "entries.");
        }
        this.msgln("");
        this.msgln("Total entries:             " + total);
        this.msgln("Total access time:         " + ms + " ms");
        this.msgln("Avg access time per entry: " + this.getAverage(ms, total) + " ms");
    }

    private String getAverage(long ms, int total) {
        StringBuffer result = new StringBuffer();
        if (total == 0) {
            result.append("0.0");
        } else {
            float avg = (float)ms / (float)total;
            result.append(AVG_FMT.format(avg));
        }
        return result.toString();
    }

    private void startTimer() {
        startTime = System.currentTimeMillis();
    }

    private long stopTimer() {
        long endTime = System.currentTimeMillis();
        return endTime - startTime;
    }

    private void msgln(String s) {
        this.msgln(Logger.LEVEL_INFO, s);
    }

    private void msgln(LogLevel level, String s) {
        if (s != null) {
            System.out.print(s);
            log.message(level, s);
        }
        System.out.println();
        System.out.flush();
    }

    private void verboseln(String s) {
        if (verbose) {
            this.msgln(Logger.LEVEL_DEBUG, s);
        }
    }

    static {
        fileHashMapFlags = 0;
        paddingSize = 1024;
        totalValues = 0;
        verbose = false;
        readOnly = false;
        useDisk = true;
        useMemory = true;
        clearFirst = false;
        log = new Logger(TestFileHashMap.class);
    }

    private static class Entry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int paddingSize;
        private String value;
        private byte[] padding;

        Entry(String value, int paddingSize) {
            this.paddingSize = paddingSize;
            this.value = value;
            this.padding = new byte[paddingSize];
        }

        public String toString() {
            return new String("[value=\"" + this.value + "\", padding=" + this.paddingSize + " bytes]");
        }
    }
}

