/*
 * Decompiled with CFR 0.152.
 */
package org.clapper.util.io.test;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.clapper.util.cmdline.CommandLineException;
import org.clapper.util.cmdline.CommandLineUsageException;
import org.clapper.util.cmdline.CommandLineUtility;
import org.clapper.util.cmdline.UsageInfo;
import org.clapper.util.io.RollingFileWriter;

public class RollingFile
extends CommandLineUtility
implements RollingFileWriter.RolloverCallback {
    private String rollOverMsg = null;
    private long maxSize = 0L;
    private String fileNamePattern = null;
    private int maxFiles = 0;
    private int totalLines = Integer.MAX_VALUE;
    private RollingFileWriter.Compression compressionType = RollingFileWriter.Compression.DONT_COMPRESS_BACKUPS;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");

    public static void main(String[] args) {
        RollingFile tester = new RollingFile();
        try {
            tester.execute(args);
        }
        catch (CommandLineUsageException ex) {
            System.exit(1);
        }
        catch (CommandLineException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace();
            System.exit(1);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private RollingFile() {
    }

    @Override
    public String getRollOverMessage() {
        if (this.rollOverMsg != null) {
            return this.dateFormat.format(new Date()) + " " + this.rollOverMsg;
        }
        return null;
    }

    @Override
    protected void runCommand() throws CommandLineException {
        try {
            RollingFileWriter w = new RollingFileWriter(this.fileNamePattern, null, this.maxSize, this.maxFiles, this.compressionType, this);
            for (int i = 0; i < this.totalLines; ++i) {
                w.print(this.dateFormat.format(new Date()));
                w.println(" Test message " + i);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    @Override
    protected void parseCustomOption(char shortOption, String longOption, Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        switch (shortOption) {
            case 't': {
                this.totalLines = this.parseIntOptionArgument(shortOption, longOption, it.next());
                break;
            }
            case 'z': {
                this.compressionType = RollingFileWriter.Compression.COMPRESS_BACKUPS;
                break;
            }
            case 'r': {
                this.rollOverMsg = it.next();
                break;
            }
            default: {
                throw new CommandLineUsageException("Unknown option: --" + longOption + " (" + '-' + shortOption + ")");
            }
        }
    }

    @Override
    protected void processPostOptionCommandLine(Iterator<String> it) throws CommandLineUsageException, NoSuchElementException {
        this.fileNamePattern = it.next();
        String s = it.next();
        try {
            this.maxSize = Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("Bad value (\"" + s + "\" for maximum file size.");
        }
        s = it.next();
        try {
            this.maxFiles = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new CommandLineUsageException("Bad value of \"" + s + "\" for maximum number of files.");
        }
        if (it.hasNext()) {
            this.rollOverMsg = it.next();
        }
    }

    @Override
    protected void getCustomUsageInfo(UsageInfo info) {
        info.addOption('t', "total-lines", "<n>", "Total lines to write. Defaults to MAXINT");
        info.addOption('r', "rollover-msg", "<s>", "Roll-over message. Defaults to none.");
        info.addOption('z', "gzip", null, "Gzipped rolled files.");
        info.addParameter("filenamePattern", "file name pattern to use", true);
        info.addParameter("maxsize", "max file size, in bytes", true);
        info.addParameter("maxfiles", "max files", true);
    }
}

