/*
 * Decompiled with CFR 0.152.
 */
package odine;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImagePanel
extends JPanel {
    private JScrollPane scrollpane;
    private int imgWidth;
    private int imgHeight;
    private int minWidth;
    private int minHeight;
    private Image img;
    private String imgFilename;
    private boolean imgSet = false;

    @Override
    public void paintComponent(Graphics g) {
        g.drawImage(this.img, (this.getWidth() - this.getImageWidth()) / 2, (this.getHeight() - this.getImageHeight()) / 2, this.getImageWidth(), this.getImageHeight(), null);
    }

    @Override
    public void update(Graphics g) {
        this.paintComponent(g);
    }

    public void setImage(String imgFilename) {
        Graphics g = this.getGraphics();
        Toolkit tk = Toolkit.getDefaultToolkit();
        if (imgFilename == null || imgFilename.length() < 1) {
            URL url = this.getClass().getResource("gfx/odine.png");
            this.img = Toolkit.getDefaultToolkit().getImage(url);
            imgFilename = "";
            this.imgSet = false;
        } else {
            this.img = tk.getImage(imgFilename);
            this.imgFilename = imgFilename;
            this.imgSet = true;
        }
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(this.img, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            System.err.println(e);
            System.exit(1);
        }
        this.setImageWidth(this.img.getWidth(null));
        this.setImageHeight(this.img.getHeight(null));
        this.setPreferredSize(new Dimension(1, 1));
        this.setSize(1, 1);
        this.scale(this.getImageWidth(), this.getImageHeight());
        this.update(g);
    }

    public void scaleImage(int w, int h) {
        this.setImageWidth(w);
        this.setImageHeight(h);
        int nw = this.getMinWidth();
        int nh = this.getMinHeight();
        if (w > this.getMinWidth()) {
            nw = w;
        }
        if (h > this.getMinHeight()) {
            nh = h;
        }
        this.setPreferredSize(new Dimension(1, 1));
        this.setSize(1, 1);
        this.scale(nw, nh);
    }

    public void scaleImage(double p) {
        this.scaleImage((int)((double)this.img.getWidth(null) * p / 100.0), (int)((double)this.img.getHeight(null) * p / 100.0));
    }

    private void scale(int w, int h) {
        if (w < this.getMinWidth()) {
            w = this.getMinWidth();
        }
        if (h < this.getMinHeight()) {
            h = this.getMinHeight();
        }
        this.setPreferredSize(new Dimension(w, h));
        this.setSize(w, h);
    }

    public void scaleToFitScreen() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int maxWidth = screenSize.width - 5;
        int maxHeight = screenSize.height - 110;
        int newWidth = maxWidth;
        double resizeFactor = (double)maxWidth / (double)this.getUnscaledImageWidth();
        int newHeight = (int)((double)this.getUnscaledImageHeight() * resizeFactor);
        if (newHeight >= maxHeight) {
            resizeFactor = (double)maxHeight / (double)newHeight;
            newHeight = maxHeight;
            newWidth = (int)((double)newWidth * resizeFactor);
        }
        this.scaleImage(newWidth, newHeight);
    }

    public void rotate90() {
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMinWidth(int w) {
        if (w < this.getImageWidth()) {
            w = this.getImageWidth();
        }
        this.minWidth = w;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public void setMinHeight(int h) {
        if (h < this.getImageHeight()) {
            h = this.getImageHeight();
        }
        this.minHeight = h;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public void setImageWidth(int w) {
        this.imgWidth = w;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public void setImageHeight(int h) {
        this.imgHeight = h;
    }

    public int getUnscaledImageWidth() {
        return this.img.getWidth(null);
    }

    public int getUnscaledImageHeight() {
        return this.img.getHeight(null);
    }
}

