/*
 * Decompiled with CFR 0.152.
 */
package odine;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.Collections;
import java.util.LinkedList;

public class ImageList {
    private LinkedList L = new LinkedList();
    private int listPos = -1;

    public ImageList() {
    }

    public ImageList(String s) {
        this();
        this.initList(s);
    }

    public void initList(String s) {
        File sFile = new File(s);
        File dir = sFile.getParentFile();
        String filename = "";
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image testImg = null;
        if (dir.isDirectory() && dir.exists()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                filename = files[i].getAbsolutePath();
                testImg = tk.getImage(filename);
                if (!this.isImage(filename) || files[i].isDirectory()) continue;
                this.L.add(filename);
            }
            Collections.sort(this.L);
            this.goTo(s);
        }
    }

    public boolean isEmpty() {
        return this.L.isEmpty();
    }

    public String getCurrentImage() {
        return (String)this.L.get(this.listPos);
    }

    public String getImageFilename() {
        return this.getCurrentImage().substring(this.getCurrentImage().lastIndexOf(File.separator) + 1);
    }

    public void prevImage() {
        if (!this.isEmpty() && this.listPos > 0) {
            --this.listPos;
        }
    }

    public void nextImage() {
        if (!this.isEmpty() && this.listPos < this.L.size() - 1) {
            ++this.listPos;
        }
    }

    public void goTo(String s) {
        this.listPos = this.L.indexOf(s);
    }

    public void goFirst() {
        if (!this.isEmpty()) {
            this.listPos = this.L.size() - 1;
        }
    }

    public void goLast() {
        if (!this.isEmpty()) {
            this.listPos = 0;
        }
    }

    public boolean isImage(String f) {
        String extension = this.getExtension(f);
        return extension.equals("jpg") || extension.equals("png") || extension.equals("gif");
    }

    private String getExtension(String s) {
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            return s.substring(i + 1).toLowerCase();
        }
        return "";
    }
}

