/*
 * Decompiled with CFR 0.152.
 */
package odine;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import odine.AboutWindow;
import odine.ImageFileFilter;
import odine.ImageList;
import odine.ImagePanel;

public class GUI
extends JFrame
implements ActionListener {
    protected final String title = "Odine 0.2.3";
    protected final int pos100 = 5;
    protected ImageList imageList = null;
    protected JLabel info;
    protected ImagePanel ip;
    protected JFrame f;
    protected JToolBar toolBar;
    protected JButton leftArrowButton;
    protected JButton rightArrowButton;
    protected JButton scaleToScreenButton;
    protected JButton plusButton;
    protected JButton minusButton;
    protected JButton lastButton;
    protected JButton firstButton;
    protected JMenuBar menuBar;
    protected JMenu fileMenu;
    protected JMenu helpMenu;
    protected JMenuItem openImage;
    protected JMenuItem exit;
    protected JMenuItem about;
    protected double[] R = new double[]{12.5, 25.0, 33.0, 50.0, 67.0, 100.0, 125.0, 150.0, 200.0, 300.0, 400.0};
    protected int resizePos = 5;

    public GUI() {
        this.setTitle("Odine 0.2.3");
        URL iconURL = GUI.class.getResource("gfx/odineicon32x32.png");
        Image windowIcon = Toolkit.getDefaultToolkit().getImage(iconURL);
        URL leftArrowURL = GUI.class.getResource("gfx/leftarrow.gif");
        URL rightArrowURL = GUI.class.getResource("gfx/rightarrow.gif");
        ImageIcon leftArrowIcon = new ImageIcon(leftArrowURL);
        ImageIcon rightArrowIcon = new ImageIcon(rightArrowURL);
        URL plusURL = GUI.class.getResource("gfx/plus.gif");
        URL minusURL = GUI.class.getResource("gfx/minus.gif");
        ImageIcon plusIcon = new ImageIcon(plusURL);
        ImageIcon minusIcon = new ImageIcon(minusURL);
        URL lastURL = GUI.class.getResource("gfx/last.gif");
        URL firstURL = GUI.class.getResource("gfx/first.gif");
        ImageIcon lastIcon = new ImageIcon(lastURL);
        ImageIcon firstIcon = new ImageIcon(firstURL);
        URL scaleToScreenURL = GUI.class.getResource("gfx/scaletoscreen.gif");
        ImageIcon scaleToScreenIcon = new ImageIcon(scaleToScreenURL);
        this.leftArrowButton = new JButton(leftArrowIcon);
        this.rightArrowButton = new JButton(rightArrowIcon);
        this.plusButton = new JButton(plusIcon);
        this.minusButton = new JButton(minusIcon);
        this.lastButton = new JButton(lastIcon);
        this.firstButton = new JButton(firstIcon);
        this.scaleToScreenButton = new JButton(scaleToScreenIcon);
        this.leftArrowButton.addActionListener(this);
        this.rightArrowButton.addActionListener(this);
        this.plusButton.addActionListener(this);
        this.minusButton.addActionListener(this);
        this.lastButton.addActionListener(this);
        this.firstButton.addActionListener(this);
        this.scaleToScreenButton.addActionListener(this);
        this.leftArrowButton.setToolTipText("Previous image");
        this.rightArrowButton.setToolTipText("Next image");
        this.plusButton.setToolTipText("Enlarge image");
        this.minusButton.setToolTipText("Shrink image");
        this.lastButton.setToolTipText("Last image");
        this.firstButton.setToolTipText("First image");
        this.scaleToScreenButton.setToolTipText("Scale image to fit screen");
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.openImage = new JMenuItem("Open image");
        this.exit = new JMenuItem("Exit");
        this.fileMenu.add(this.openImage);
        this.openImage.addActionListener(this);
        this.fileMenu.add(this.exit);
        this.exit.addActionListener(this);
        this.menuBar.add(this.fileMenu);
        this.helpMenu = new JMenu("Help");
        this.about = new JMenuItem("About Odine");
        this.helpMenu.add(this.about);
        this.about.addActionListener(this);
        this.menuBar.add(this.helpMenu);
        this.toolBar = new JToolBar();
        this.toolBar.add(this.lastButton);
        this.toolBar.add(this.leftArrowButton);
        this.toolBar.add(this.rightArrowButton);
        this.toolBar.add(this.firstButton);
        this.toolBar.add(this.minusButton);
        this.toolBar.add(this.plusButton);
        this.toolBar.add(this.scaleToScreenButton);
        this.ip = new ImagePanel();
        this.ip.setMinWidth(240);
        this.ip.setMinHeight(240);
        this.info = new JLabel("");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.setJMenuBar(this.menuBar);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.info, "Center");
        this.getContentPane().add((Component)this.ip, "South");
        this.setIconImage(windowIcon);
        this.setSize(240, 240);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void buildImageList(String s) {
        try {
            this.imageList = new ImageList(s);
            this.imageList.goTo(s);
            this.setImage(this.imageList.getCurrentImage());
        }
        catch (NullPointerException n) {
            this.imageList = null;
            throw n;
        }
    }

    public void setInfo() {
        String s = "";
        try {
            s = this.imageList.getImageFilename() + " " + this.ip.getUnscaledImageWidth() + "x" + this.ip.getUnscaledImageHeight() + " (" + this.R[this.resizePos] + "%)";
        }
        catch (NullPointerException n) {
            s = "Thanks for using Odine";
        }
        this.info.setText(s);
    }

    public void setInfo(String s) {
        this.info.setText(s);
    }

    public void setImage(String s) {
        this.ip.setImage(s);
        this.setLocation(new Point(0, 0));
        this.pack();
        this.resizePos = 5;
        this.setInfo();
    }

    public void resizeImage() {
        this.ip.scaleImage(this.R[this.resizePos]);
        this.pack();
        this.setInfo();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        if (action.getSource() == this.leftArrowButton) {
            if (this.imageList != null) {
                this.imageList.prevImage();
                this.setImage(this.imageList.getCurrentImage());
            }
        } else if (action.getSource() == this.rightArrowButton) {
            if (this.imageList != null) {
                this.imageList.nextImage();
                this.setImage(this.imageList.getCurrentImage());
            }
        } else if (action.getSource() == this.plusButton) {
            if (this.imageList != null && this.resizePos < this.R.length - 1) {
                ++this.resizePos;
                this.resizeImage();
            }
        } else if (action.getSource() == this.minusButton) {
            if (this.imageList != null && this.resizePos > 0) {
                --this.resizePos;
                this.resizeImage();
            }
        } else if (action.getSource() == this.lastButton) {
            if (this.imageList != null) {
                this.imageList.goLast();
                this.setImage(this.imageList.getCurrentImage());
            }
        } else if (action.getSource() == this.firstButton) {
            if (this.imageList != null) {
                this.imageList.goFirst();
                this.setImage(this.imageList.getCurrentImage());
            }
        } else if (action.getSource() == this.scaleToScreenButton) {
            if (this.imageList != null) {
                this.ip.scaleToFitScreen();
                this.pack();
            }
        } else if (action.getSource() == this.openImage) {
            JFileChooser fileOpenDialog = new JFileChooser();
            ImageFileFilter iff = new ImageFileFilter();
            fileOpenDialog.setFileFilter(iff);
            fileOpenDialog.showOpenDialog(null);
            if (fileOpenDialog.getSelectedFile() != null) {
                File f = fileOpenDialog.getSelectedFile();
                this.buildImageList(f.getAbsolutePath());
            }
        } else if (action.getSource() == this.about) {
            AboutWindow aboutWindow = new AboutWindow("About Odine 0.2.3", "about.txt");
        } else if (action.getSource() == this.exit) {
            System.exit(0);
        }
    }
}

