/*
 * Decompiled with CFR 0.152.
 */
package jhplot.utils;

import graph.RTextLine;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JPanel;
import jplot.Translate;

public class DrawingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private String sname;
    private Font f;
    private Color c;
    private FontMetrics fm;
    private int WIDTH = 600;
    private int HEIGHT = 400;
    private int xpos;
    private int ypos;

    DrawingPanel() {
        this.setBackground(Color.WHITE);
        this.sname = " ";
        this.f = new Font("Lucida Sans", 1, 16);
        this.c = Color.black;
        this.xpos = -1;
        this.ypos = -1;
    }

    public void setText(String sname, Font f, Color c) {
        this.sname = sname;
        this.f = f;
        this.c = c;
        this.repaint();
    }

    public void setText(String sname, Font f) {
        this.setText(sname, f, Color.black);
    }

    public void setText(String sname) {
        this.setText(sname, new Font("Lucida Sans", 1, 16), Color.black);
    }

    public void setTextPosition(int xpos, int ypos) {
        this.xpos = xpos;
        this.ypos = ypos;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int dX;
        super.paintComponent(g);
        g.setFont(this.f);
        this.fm = this.getFontMetrics(this.f);
        int dY = this.getSize().height;
        this.WIDTH = dX = this.getSize().width;
        this.HEIGHT = dY;
        int midY = dY / 2;
        int midX = dX / 2;
        int rectX = 3 * dX / 4;
        int rectY = 3 * dY / 4;
        String tmp = Translate.shrink(this.sname);
        int textWidth = this.fm.stringWidth(tmp);
        int textHeight = this.fm.getHeight();
        RTextLine text = new RTextLine();
        text.setFont(this.f);
        text.setColor(this.c);
        String stext = Translate.decode(this.sname);
        text.setText(stext);
        if (this.xpos == -1 && this.ypos == -1) {
            text.draw(g, midX - (int)(0.5 * (double)textWidth), midY + (int)(0.5 * (double)textHeight));
        } else {
            text.draw(g, midX - (int)(0.5 * (double)textWidth), this.xpos, this.ypos);
        }
    }
}

