/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml.demo;

import com.microstar.xml.demo.XmlApp;
import java.util.Enumeration;

public class DtdDemo
extends XmlApp {
    public static void main(String[] args) throws Exception {
        DtdDemo demo = new DtdDemo();
        if (args.length != 1) {
            System.err.println("Usage: java DtdDemo <uri>");
            System.exit(1);
        } else {
            demo.doParse(args[0]);
        }
    }

    public void startDocument() {
        this.displayText("<-- Start of DTD -->\n");
    }

    public void endDocument(int errorCount) {
        this.displayText("<-- End of DTD -->");
    }

    public void doctypeDecl(String name, String pubid, String sysid) {
        this.dumpNotations();
        this.dumpEntities();
        this.dumpElements();
    }

    public void dumpNotations() {
        Enumeration notationNames = this.parser.declaredNotations();
        this.displayText("<-- Notation Declarations -->\n");
        while (notationNames.hasMoreElements()) {
            String nname = (String)notationNames.nextElement();
            String extId = this.makeExternalIdentifiers(this.parser.getNotationPublicId(nname), this.parser.getNotationSystemId(nname));
            this.displayText("<!NOTATION " + nname + 32 + extId + ">\n");
        }
    }

    public void dumpEntities() {
        Enumeration entityNames = this.parser.declaredEntities();
        this.displayText("<-- Entity Declarations -->\n");
        while (entityNames.hasMoreElements()) {
            String ename = (String)entityNames.nextElement();
            if (ename.startsWith("%")) continue;
            String value = null;
            switch (this.parser.getEntityType(ename)) {
                case 1: {
                    value = this.makeLiteral(this.parser.getEntityValue(ename));
                    break;
                }
                case 2: {
                    value = this.makeExternalIdentifiers(this.parser.getEntityPublicId(ename), this.parser.getEntitySystemId(ename)) + "NDATA " + this.parser.getEntityNotationName(ename);
                    break;
                }
                case 3: {
                    value = this.makeExternalIdentifiers(this.parser.getEntityPublicId(ename), this.parser.getEntitySystemId(ename));
                }
            }
            this.displayText("<!ENTITY " + ename + ' ' + value + ">\n");
        }
    }

    public void dumpElements() {
        Enumeration elementNames = this.parser.declaredElements();
        this.displayText("<-- Element Type Declarations -->\n");
        while (elementNames.hasMoreElements()) {
            String contentSpec = "ANY";
            String elname = (String)elementNames.nextElement();
            switch (this.parser.getElementContentType(elname)) {
                case 2: {
                    contentSpec = "EMPTY";
                    break;
                }
                case 1: {
                    contentSpec = "ANY";
                    break;
                }
                case 3: 
                case 4: {
                    contentSpec = this.parser.getElementContentModel(elname);
                }
            }
            this.displayText("<!ELEMENT " + elname + ' ' + contentSpec + ">");
            this.dumpAttributes(elname);
            this.displayText("");
        }
    }

    public void dumpAttributes(String elname) {
        Enumeration attributeNames = this.parser.declaredAttributes(elname);
        if (attributeNames == null) {
            return;
        }
        this.displayText("<!ATTLIST " + elname);
        while (attributeNames.hasMoreElements()) {
            String aname = (String)attributeNames.nextElement();
            String type = this.makeAttributeType(elname, aname);
            String value = this.makeAttributeValue(elname, aname);
            this.displayText("  " + aname + ' ' + type + ' ' + value);
        }
        this.displayText(">");
    }

    public String makeAttributeType(String elname, String aname) {
        switch (this.parser.getAttributeType(elname, aname)) {
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 9: {
                return this.parser.getAttributeEnumeration(elname, aname);
            }
            case 10: {
                return "NOTATION " + this.parser.getAttributeEnumeration(elname, aname);
            }
        }
        return null;
    }

    public String makeAttributeValue(String elname, String aname) {
        switch (this.parser.getAttributeDefaultValueType(elname, aname)) {
            case 2: {
                return "#IMPLIED";
            }
            case 1: {
                return this.makeLiteral(this.parser.getAttributeDefaultValue(elname, aname));
            }
            case 3: {
                return "#REQUIRED";
            }
            case 4: {
                return "#FIXED " + this.makeLiteral(this.parser.getAttributeDefaultValue(elname, aname));
            }
        }
        return null;
    }

    public String makeExternalIdentifiers(String pubid, String sysid) {
        String extId = "";
        if (pubid != null) {
            extId = "PUBLIC " + this.makeLiteral(pubid);
            if (sysid != null) {
                extId = extId + ' ' + this.makeLiteral(sysid);
            }
        } else {
            extId = "SYSTEM " + this.makeLiteral(sysid);
        }
        return extId;
    }

    public String makeLiteral(String data) {
        char[] ch = data.toCharArray();
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == '\"') {
                buf.append("&#22;");
                continue;
            }
            if (ch[i] > '\u007f') {
                buf.append("&#" + ch[i] + ";");
                continue;
            }
            buf.append(ch[i]);
        }
        buf.append('\"');
        return buf.toString();
    }
}

