/*
 * Decompiled with CFR 0.152.
 */
package com.csam.dif;

import com.csam.dif.DIFCell;
import com.csam.dif.DIFDataPairParsingException;
import com.csam.dif.DIFException;
import com.csam.dif.DIFKeywordException;
import com.csam.dif.DIFKeywords;
import com.csam.dif.DIFNumberPairInfoException;
import com.csam.dif.DIFRow;
import com.csam.dif.DIFSheet;
import com.csam.dif.DIFStringFormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DIFReader {
    private SimpleDateFormat usFmt = new SimpleDateFormat("MM/dd/yyyy");

    public static DIFSheet readSheet(DIFSheet sheet, InputStream inStream) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException, ParseException {
        DIFReader reader = new DIFReader();
        return reader.read(sheet, inStream);
    }

    public DIFSheet read(DIFSheet sheet, InputStream inStream) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException, ParseException {
        String line;
        sheet.cleanUp();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStream));
        this.readTitle(reader, sheet);
        int vectors = this.readVectors(reader);
        int tuples = this.readTuples(reader);
        this.readData(reader);
        try {
            for (int i = 0; i < tuples; ++i) {
                DIFRow row = sheet.createRow(i);
                for (int j = 0; j < vectors; ++j) {
                    row.createCell(j);
                }
            }
        }
        catch (DIFException ex) {
            throw new RuntimeException("PANIC!", ex);
        }
        int rowCount = 0;
        this.readExpectedNumberPair(reader, -1, 0);
        block4: while (!(line = reader.readLine()).equals(DIFKeywords.EOD.name())) {
            String indicator;
            if (!line.equals(DIFKeywords.BOT.name())) {
                throw new DIFKeywordException("Unknown keyword '" + line + "'", "BOT/EOD", line);
            }
            DIFRow row = sheet.getRow(rowCount++);
            int colCount = 0;
            while (true) {
                DIFCell cell = row.getCell(colCount++);
                line = reader.readLine();
                String[] parts = this.simpleSplit(line);
                int code = Integer.parseInt(parts[0]);
                if (code == -1) {
                    if (Integer.parseInt(parts[1]) == 0) continue block4;
                    throw new DIFNumberPairInfoException(-1, 0, code, Integer.parseInt(parts[1]));
                }
                if (code == 1) {
                    if (Integer.parseInt(parts[1]) != 0) {
                        throw new DIFNumberPairInfoException(-1, 0, code, Integer.parseInt(parts[1]));
                    }
                    String val = this.readString(reader);
                    cell.setCellValue(val);
                    continue;
                }
                if (code != 0) continue;
                indicator = reader.readLine();
                if (indicator.equals("V")) {
                    if (parts[1].matches("\\A[0-9]{2}/[0-9]{2}/[0-9]{4}\\z")) {
                        Date parsed = this.usFmt.parse(parts[1]);
                        cell.setCellValue(new java.sql.Date(parsed.getTime()));
                        continue;
                    }
                    cell.setCellValue(new BigDecimal(parts[1]));
                    continue;
                }
                if (indicator.equals("TRUE")) {
                    if (Integer.parseInt(parts[1]) != 1) {
                        throw new DIFNumberPairInfoException(code, 1, code, Integer.parseInt(parts[1]));
                    }
                    cell.setCellValue(true);
                    continue;
                }
                if (!indicator.equals("FALSE")) break;
                if (Integer.parseInt(parts[1]) != 0) {
                    throw new DIFNumberPairInfoException(code, 0, code, Integer.parseInt(parts[1]));
                }
                cell.setCellValue(false);
            }
            throw new DIFKeywordException("Unsupported type indicator", "V/TRUE/FALSE", indicator);
        }
        return sheet;
    }

    public DIFSheet read(InputStream inStream) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException, ParseException {
        return this.read(new DIFSheet(), inStream);
    }

    private String readExpectedKeyword(BufferedReader reader, String expected) throws IOException, DIFKeywordException {
        String actual = reader.readLine();
        if (!actual.equals(expected)) {
            throw new DIFKeywordException("Expected keyword '" + expected + "' but found '" + actual + "'", expected, actual);
        }
        return actual;
    }

    private String[] simpleSplit(String line) throws DIFDataPairParsingException {
        int index = line.indexOf(44);
        if (index == -1) {
            throw new DIFDataPairParsingException("Missing ','", line);
        }
        return new String[]{line.substring(0, index), line.substring(index + 1)};
    }

    private int[] readNumberPair(BufferedReader reader) throws IOException, DIFDataPairParsingException {
        String line = reader.readLine();
        String[] parts = this.simpleSplit(line);
        try {
            int[] result = new int[parts.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Integer.parseInt(parts[i]);
            }
            return result;
        }
        catch (NumberFormatException ex) {
            throw new DIFDataPairParsingException(ex, line);
        }
    }

    private int[] readExpectedNumberPair(BufferedReader reader, int vector, int tuple) throws IOException, DIFDataPairParsingException, DIFNumberPairInfoException {
        int[] numbers = this.readNumberPair(reader);
        if (numbers[0] != vector || numbers[1] != tuple) {
            throw new DIFNumberPairInfoException("Bad vector/tuple info", vector, tuple, numbers[0], numbers[1]);
        }
        return numbers;
    }

    private String readString(BufferedReader reader) throws IOException, DIFStringFormatException {
        String line = reader.readLine();
        if (!line.startsWith("\"") || !line.startsWith("\"")) {
            throw new DIFStringFormatException("Missing leading and trailing '\"' character");
        }
        return line.substring(1, line.length() - 1).replace("\"\"", "\"");
    }

    private void readTitle(BufferedReader reader, DIFSheet sheet) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException {
        this.readExpectedKeyword(reader, DIFKeywords.TABLE.name());
        this.readExpectedNumberPair(reader, 0, 1);
        sheet.setTitle(this.readString(reader));
        sheet.setVersion(1);
    }

    private int readVectors(BufferedReader reader) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException {
        this.readExpectedKeyword(reader, DIFKeywords.VECTORS.name());
        int[] np = this.readNumberPair(reader);
        if (np[0] != 0) {
            throw new DIFNumberPairInfoException("Invalid formatted 'VECTORS' info", 0, np[1], np[0], np[1]);
        }
        if (this.readString(reader).length() != 0) {
            throw new DIFStringFormatException("Expected empty string");
        }
        return np[1];
    }

    private int readTuples(BufferedReader reader) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException {
        this.readExpectedKeyword(reader, DIFKeywords.TUPLES.name());
        int[] np = this.readNumberPair(reader);
        if (np[0] != 0) {
            throw new DIFNumberPairInfoException("Invalid formatted 'TUPLES' info", 0, np[1], np[0], np[1]);
        }
        if (this.readString(reader).length() != 0) {
            throw new DIFStringFormatException("Expected empty string");
        }
        return np[1];
    }

    private void readData(BufferedReader reader) throws IOException, DIFKeywordException, DIFDataPairParsingException, DIFNumberPairInfoException, DIFStringFormatException {
        this.readExpectedKeyword(reader, DIFKeywords.DATA.name());
        this.readExpectedNumberPair(reader, 0, 0);
        if (this.readString(reader).length() != 0) {
            throw new DIFStringFormatException("Expected empty string");
        }
    }
}

