/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.InnerStrategy;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.timingdiagram.ChangeState;
import net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingRuler;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Histogram
implements TimeDrawing {
    private final List<ChangeState> changes = new ArrayList<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private List<String> allStates = new ArrayList<String>();
    private final double stepHeight = 20.0;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;

    public Histogram(TimingRuler ruler, ISkinParam skinParam) {
        this.ruler = ruler;
        this.skinParam = skinParam;
    }

    @Override
    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick tick) {
        double x = this.ruler.getPosInPixel(tick);
        List<String> states = this.getStatesAt(tick);
        if (states.size() == 0) {
            return null;
        }
        if (states.size() == 1) {
            double y = this.getStateYFor(states.get(0));
            return new IntricatedPoint(new Point2D.Double(x, y), new Point2D.Double(x, y));
        }
        assert (states.size() == 2);
        double y1 = this.getStateYFor(states.get(0));
        double y2 = this.getStateYFor(states.get(1));
        assert (y1 != y2);
        return new IntricatedPoint(new Point2D.Double(x, y1), new Point2D.Double(x, y2));
    }

    private double getStateYFor(String state) {
        return (double)(this.allStates.size() - 1 - this.allStates.indexOf(state)) * 20.0;
    }

    private List<String> getStatesAt(TimeTick tick) {
        if (this.changes.size() == 0) {
            return Collections.emptyList();
        }
        for (int i = 0; i < this.changes.size(); ++i) {
            if (this.changes.get(i).getWhen().compareTo(tick) == 0) {
                if (i == 0 && this.initialState == null) {
                    return Arrays.asList(this.changes.get(i).getState());
                }
                if (i == 0 && this.initialState != null) {
                    return Arrays.asList(this.initialState, this.changes.get(i).getState());
                }
                return Arrays.asList(this.changes.get(i - 1).getState(), this.changes.get(i).getState());
            }
            if (this.changes.get(i).getWhen().compareTo(tick) <= 0) continue;
            return Collections.singletonList(this.changes.get(i - 1).getState());
        }
        return Collections.singletonList(this.changes.get(this.changes.size() - 1).getState());
    }

    @Override
    public void addChange(ChangeState change) {
        String state = change.getState();
        if (!this.allStates.contains(state)) {
            this.allStates.add(state);
        }
        this.changes.add(change);
    }

    private Point2D getPoint(int i) {
        ChangeState change = this.changes.get(i);
        double x = this.ruler.getPosInPixel(change.getWhen());
        return new Point2D.Double(x, this.yOfState(change.getState()));
    }

    private double yOfState(String state) {
        return -20.0 * (double)this.allStates.indexOf(state);
    }

    private SymbolContext getContext() {
        return new SymbolContext(HtmlColorUtils.COL_D7E0F2, HtmlColorUtils.COL_038048).withStroke(new UStroke(1.5));
    }

    @Override
    public void drawU(UGraphic ug) {
        int i;
        ug = this.getContext().apply(ug);
        UTranslate deltaY = new UTranslate(0.0, this.getFullDeltaY());
        if (this.changes.size() == 0) {
            return;
        }
        if (this.initialState != null) {
            Point2D pt = this.getPoint(0);
            this.drawHLine(ug, this.getInitialPoint(), this.getInitialWidth() + pt.getX());
        }
        for (int i2 = 0; i2 < this.changes.size() - 1; ++i2) {
            Point2D pt = this.getPoint(i2);
            Point2D pt2 = this.getPoint(i2 + 1);
            double len = pt2.getX() - pt.getX();
            this.drawHLine(ug, pt, len);
        }
        Point2D pt = this.getPoint(this.changes.size() - 1);
        double len = this.ruler.getWidth() - pt.getX();
        this.drawHLine(ug, pt, len);
        if (this.initialState != null) {
            Point2D.Double before = this.getInitialPoint();
            Point2D current = this.getPoint(0);
            ug.apply(new UTranslate(current).compose(deltaY)).draw(new ULine(0.0, ((Point2D)before).getY() - current.getY()));
        }
        for (i = 1; i < this.changes.size(); ++i) {
            Point2D before = this.getPoint(i - 1);
            Point2D current = this.getPoint(i);
            ug.apply(new UTranslate(current).compose(deltaY)).draw(new ULine(0.0, before.getY() - current.getY()));
        }
        for (i = 0; i < this.changes.size(); ++i) {
            Point2D ptLabel = this.getPoint(i);
            String comment = this.changes.get(i).getComment();
            if (comment == null) continue;
            TextBlock label = this.getTextBlock(comment);
            Dimension2D dim = label.calculateDimension(ug.getStringBounder());
            label.drawU(ug.apply(new UTranslate(ptLabel).compose(deltaY).compose(new UTranslate(2.0, -dim.getHeight()))));
        }
        for (TimeConstraint constraint : this.constraints) {
            String state1 = Histogram.last(this.getStatesAt(constraint.getTick1()));
            String state2 = this.getStatesAt(constraint.getTick2()).get(0);
            double y1 = this.getStateYFor(state1);
            double y2 = this.getStateYFor(state2);
            constraint.drawU(ug.apply(new UTranslate(0.0, y1 - 10.0)), this.ruler, this.skinParam);
        }
    }

    private static String last(List<String> list) {
        return list.get(list.size() - 1);
    }

    private Point2D.Double getInitialPoint() {
        return new Point2D.Double(-this.getInitialWidth(), this.yOfState(this.initialState));
    }

    private void drawHLine(UGraphic ug, Point2D pt, double len) {
        UTranslate deltaY = new UTranslate(0.0, this.getFullDeltaY());
        UTranslate pos = new UTranslate(pt).compose(deltaY);
        ug = ug.apply(pos);
        ug.draw(new ULine(len, 0.0));
    }

    private double getFullDeltaY() {
        return 20.0 * (double)(this.allStates.size() - 1);
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    private TextBlock getTextBlock(String value) {
        Display display = Display.getWithNewlines(value);
        return display.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    @Override
    public double getHeight(StringBounder stringBounder) {
        return 20.0 * (double)this.allStates.size() + 10.0;
    }

    @Override
    public TextBlock getWidthHeader(StringBounder stringBounder) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                for (String state : Histogram.this.allStates) {
                    TextBlock label = Histogram.this.getTextBlock(state);
                    Dimension2D dim = label.calculateDimension(ug.getStringBounder());
                    label.drawU(ug.apply(new UTranslate(0.0, Histogram.this.getFullDeltaY() + Histogram.this.yOfState(state) - dim.getHeight())));
                }
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                double width = 0.0;
                for (String state : Histogram.this.allStates) {
                    TextBlock label = Histogram.this.getTextBlock(state);
                    Dimension2D dim = label.calculateDimension(stringBounder);
                    width = Math.max(width, dim.getWidth());
                }
                if (Histogram.this.initialState != null) {
                    width += Histogram.this.getInitialWidth();
                }
                return new Dimension2DDouble(width, Histogram.this.getFullDeltaY());
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Rectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }
        };
    }

    @Override
    public void setInitialState(String initialState, Colors initialColors) {
        this.initialState = initialState;
        if (initialState != null) {
            this.allStates.add(initialState);
        }
    }

    private double getInitialWidth() {
        return 40.0;
    }

    @Override
    public void addConstraint(TimeConstraint constraint) {
        this.constraints.add(constraint);
    }
}

