/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.eps;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.eps.PostScriptCommandMacro;
import net.sourceforge.plantuml.eps.PostScriptCommandRaw;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ShadowManager;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.version.Version;

public class EpsGraphics {
    public static final String END_OF_FILE = "%plantuml done";
    private final StringBuilder body = new StringBuilder();
    private final StringBuilder header = new StringBuilder();
    private Color color = Color.BLACK;
    private Color fillcolor = Color.BLACK;
    private String strokeWidth = "1";
    private final PostScriptCommandMacro setcolorgradient = new PostScriptCommandMacro("setcolorgradient");
    private final PostScriptCommandMacro simplerect = new PostScriptCommandMacro("simplerect");
    private final PostScriptCommandMacro roundrect = new PostScriptCommandMacro("roundrect");
    private boolean setcolorgradientUsed = false;
    private boolean simplerectUsed = false;
    private boolean roundrectUsed = false;
    private boolean closeDone = false;
    private int maxX = 10;
    private int maxY = 10;
    private double dashVisible = 0.0;
    private double dashSpace = 0.0;
    private UrlArea urlArea;
    private final ShadowManager shadowManager = new ShadowManager(50, 200);

    public EpsGraphics() {
        this.header.append("%!PS-Adobe-3.0 EPSF-3.0\n");
        this.header.append("%%Creator: PlantUML v" + Version.versionString(15) + "\n");
        this.header.append("%%Title: noTitle\n");
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 1 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 2 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("3 index 7 index sub 3 index mul 7 index add", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("setrgbcolor", true));
        this.setcolorgradient.add(new PostScriptCommandRaw("pop pop pop pop pop pop pop ", true));
        this.simplerect.add(new PostScriptCommandRaw("newpath moveto 1 index 0 rlineto", true));
        this.simplerect.add(new PostScriptCommandRaw("0 exch rlineto", true));
        this.simplerect.add(new PostScriptCommandRaw("neg 0 rlineto", true));
        this.roundrect.add(new PostScriptCommandRaw("newpath", true));
        this.roundrect.add(new PostScriptCommandRaw("dup 3 index add 2 index 2 index add 2 index 180 270 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("2 index 5 index add 1 index sub 2 index 2 index add 2 index 270 0 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("2 index 5 index add 1 index sub 2 index 5 index add 2 index sub 2 index 0 90 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("dup 3 index add 2 index 5 index add 2 index sub 2 index 90 180 arc", true));
        this.roundrect.add(new PostScriptCommandRaw("pop pop pop pop pop ", true));
    }

    protected final void ensureVisible(double x, double y) {
        if (x > (double)this.maxX) {
            this.maxX = (int)(x + 1.0);
        }
        if (y > (double)this.maxY) {
            this.maxY = (int)(y + 1.0);
        }
        if (this.urlArea != null) {
            this.urlArea.ensureVisible((int)Math.round(x), (int)Math.round(y));
        }
    }

    protected final Color getColor() {
        return this.color;
    }

    public void close() {
        this.checkCloseDone();
        this.header.append("%%BoundingBox: 0 0 " + this.maxX + " " + this.maxY + "\n");
        this.header.append("%%ColorUsage: Color\n");
        this.header.append("%%Origin: 0 0\n");
        this.header.append("%%EndComments\n\n");
        this.header.append("gsave\n");
        this.header.append("0 " + this.maxY + " translate\n");
        this.header.append("1 -1 scale\n");
        if (this.setcolorgradientUsed) {
            this.header.append(this.setcolorgradient.getPostStringDefinition());
        }
        if (this.simplerectUsed) {
            this.header.append(this.simplerect.getPostStringDefinition());
        }
        if (this.roundrectUsed) {
            this.header.append(this.roundrect.getPostStringDefinition());
        }
        this.append("grestore", true);
        this.append("showpage", true);
        this.append(END_OF_FILE, true);
        this.append("%%EOF", true);
        this.closeDone = true;
    }

    private void checkCloseDone() {
        if (this.closeDone) {
            throw new IllegalStateException();
        }
    }

    public String getEPSCode() {
        if (!this.closeDone) {
            this.close();
        }
        return this.header.toString() + this.getBodyString();
    }

    protected String getBodyString() {
        return this.body.toString();
    }

    public final void setStrokeColor(Color c) {
        this.checkCloseDone();
        this.color = c;
    }

    public void setFillColor(Color c) {
        this.checkCloseDone();
        this.fillcolor = c;
    }

    public final void setStrokeWidth(String strokeWidth, double dashVisible, double dashSpace) {
        this.checkCloseDone();
        this.strokeWidth = strokeWidth;
        this.dashVisible = dashVisible;
        this.dashSpace = dashSpace;
    }

    public void newpathDot() {
        boolean dashed = this.dashVisible != 0.0 || this.dashSpace != 0.0;
        this.checkCloseDone();
        this.append(this.strokeWidth + " setlinewidth", true);
        this.appendColor(this.color);
        if (dashed) {
            this.append("[9 9] 0 setdash", true);
        }
        this.append("newpath", true);
    }

    public void closepathDot() {
        boolean dashed = this.dashVisible != 0.0 || this.dashSpace != 0.0;
        this.append("stroke", true);
        if (dashed) {
            this.append("[] 0 setdash", true);
        }
    }

    public void epsLine(double x1, double y1, double x2, double y2) {
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
        this.checkCloseDone();
        this.append(this.strokeWidth + " setlinewidth", true);
        this.appendColor(this.color);
        this.append("newpath", true);
        if (this.dashVisible == 0.0 || this.dashSpace == 0.0) {
            this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " moveto", true);
            this.append(EpsGraphics.format(x2 - x1) + " " + EpsGraphics.format(y2 - y1) + " rlineto", true);
        } else if (x1 == x2) {
            this.epsHLine(x1, Math.min(y1, y2), Math.max(y1, y2));
        } else if (y1 == y2) {
            this.epsVLine(y1, Math.min(x1, x2), Math.max(x1, x2));
        }
        this.append("stroke", true);
        this.ensureVisible(Math.max(x1, x2), Math.max(y1, y2));
    }

    protected void epsHLine(double x, double ymin, double ymax) {
        this.append(EpsGraphics.format(x) + " " + EpsGraphics.format(ymin) + " moveto", true);
        for (double y = ymin; y < ymax; y += this.dashVisible + this.dashSpace) {
            double v = y + this.dashVisible > ymax ? y - ymax : this.dashSpace;
            this.append("0 " + EpsGraphics.format(v) + " rlineto", true);
            this.append("0 " + EpsGraphics.format(this.dashSpace) + " rmoveto", true);
        }
    }

    protected void epsVLine(double y, double xmin, double xmax) {
        this.append(EpsGraphics.format(xmin) + " " + EpsGraphics.format(y) + " moveto", true);
        for (double x = xmin; x < xmax; x += this.dashVisible + this.dashSpace) {
            double v = x + this.dashVisible > xmax ? x - xmax : this.dashSpace;
            this.append(EpsGraphics.format(v) + " 0 rlineto", true);
            this.append(EpsGraphics.format(this.dashSpace) + " 0 rmoveto", true);
        }
    }

    public void epsPath(double x, double y, UPath path2) {
        double[] coord;
        USegmentType type;
        this.checkCloseDone();
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            for (USegment seg : path2) {
                type = seg.getSegmentType();
                coord = seg.getCoord();
                if (type == USegmentType.SEG_MOVETO) {
                    this.movetoNoMacro(coord[0] + x, coord[1] + y);
                    continue;
                }
                if (type == USegmentType.SEG_LINETO) {
                    this.linetoNoMacro(coord[0] + x, coord[1] + y);
                    continue;
                }
                if (type == USegmentType.SEG_QUADTO) {
                    throw new UnsupportedOperationException();
                }
                if (type == USegmentType.SEG_CUBICTO) {
                    this.curvetoNoMacro(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
                    continue;
                }
                if (type == USegmentType.SEG_CLOSE) continue;
                Log.println("unknown " + seg);
            }
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            for (USegment seg : path2) {
                type = seg.getSegmentType();
                coord = seg.getCoord();
                if (type == USegmentType.SEG_MOVETO) {
                    this.movetoNoMacro(coord[0] + x, coord[1] + y);
                    continue;
                }
                if (type == USegmentType.SEG_LINETO) {
                    this.linetoNoMacro(coord[0] + x, coord[1] + y);
                    continue;
                }
                if (type == USegmentType.SEG_QUADTO) {
                    throw new UnsupportedOperationException();
                }
                if (type == USegmentType.SEG_CUBICTO) {
                    this.curvetoNoMacro(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
                    continue;
                }
                if (type == USegmentType.SEG_CLOSE) continue;
                Log.println("unknown " + seg);
            }
            this.append("stroke", true);
        }
    }

    public void epsPolygon(HtmlColorGradient gr, ColorMapper mapper, double ... points) {
        this.setFillColor(mapper.getMappedColor(gr.getColor1()));
        this.epsPolygon(points);
    }

    public void epsPolygon(double ... points) {
        int i;
        this.checkCloseDone();
        double lastX = 0.0;
        double lastY = 0.0;
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            for (i = 0; i < points.length; i += 2) {
                this.ensureVisible(points[i], points[i + 1]);
                if (i == 0) {
                    this.append(EpsGraphics.format(points[i]) + " " + EpsGraphics.format(points[i + 1]) + " moveto", true);
                } else {
                    this.append(EpsGraphics.format(points[i] - lastX) + " " + EpsGraphics.format(points[i + 1] - lastY) + " rlineto", true);
                }
                lastX = points[i];
                lastY = points[i + 1];
            }
            this.append(EpsGraphics.format(points[0]) + " " + EpsGraphics.format(points[1]) + " lineto", true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            for (i = 0; i < points.length; i += 2) {
                this.ensureVisible(points[i], points[i + 1]);
                if (i == 0) {
                    this.append(EpsGraphics.format(points[i]) + " " + EpsGraphics.format(points[i + 1]) + " moveto", true);
                } else {
                    this.append(EpsGraphics.format(points[i] - lastX) + " " + EpsGraphics.format(points[i + 1] - lastY) + " rlineto", true);
                }
                lastX = points[i];
                lastY = points[i + 1];
            }
            this.append(EpsGraphics.format(points[0]) + " " + EpsGraphics.format(points[1]) + " lineto", true);
            this.append("closepath stroke", true);
        }
    }

    public void epsRectangle(double x, double y, double width, double height, double rx, double ry) {
        this.checkCloseDone();
        this.ensureVisible(x, y);
        this.ensureVisible(x + width, y + height);
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.epsRectangleInternal(x, y, width, height, rx, ry, true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.epsRectangleInternal(x, y, width, height, rx, ry, false);
            this.append("closepath stroke", true);
        }
    }

    public void epsRectangle(double x, double y, double width, double height, double rx, double ry, HtmlColorGradient gr, ColorMapper mapper) {
        this.checkCloseDone();
        this.ensureVisible(x, y);
        this.ensureVisible(x + width, y + height);
        this.setcolorgradientUsed = true;
        if (rx == 0.0 && ry == 0.0) {
            this.simplerectUsed = true;
            this.appendColorShort(mapper.getMappedColor(gr.getColor1()));
            this.appendColorShort(mapper.getMappedColor(gr.getColor2()));
            this.append(EpsGraphics.format(width) + " " + EpsGraphics.format(height) + " " + EpsGraphics.format(x) + " " + EpsGraphics.format(y), true);
            this.append("100 -1 1 {", true);
            this.append("100 div", true);
            this.append("newpath", true);
            this.append("2 index 2 index moveto", true);
            this.append("dup 5 index mul 2 mul dup 0 rlineto", true);
            this.append("neg 4 index 2 index mul 2 mul rlineto", true);
            this.append("closepath eoclip", true);
            this.append("10 index 10 index 10 index", true);
            this.append("10 index 10 index 10 index", true);
            this.append("6 index setcolorgradient", true);
            this.append("4 index 4 index 4 index 4 index simplerect", true);
            this.append("closepath eofill", true);
            this.append("pop", true);
            this.append("} for", true);
            this.append("pop pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("initclip", true);
        } else {
            this.roundrectUsed = true;
            this.appendColorShort(mapper.getMappedColor(gr.getColor1()));
            this.appendColorShort(mapper.getMappedColor(gr.getColor2()));
            this.append(EpsGraphics.format(width) + " " + EpsGraphics.format(height) + " " + EpsGraphics.format(x) + " " + EpsGraphics.format(y) + " " + EpsGraphics.format((rx + ry) / 2.0), true);
            this.append("100 -1 1 {", true);
            this.append("100 div", true);
            this.append("newpath", true);
            this.append("3 index 3 index moveto", true);
            this.append("dup 6 index mul 2 mul dup 0 rlineto", true);
            this.append("neg 5 index 2 index mul 2 mul rlineto", true);
            this.append("closepath eoclip", true);
            this.append("11 index 11 index 11 index", true);
            this.append("11 index 11 index 11 index", true);
            this.append("6 index setcolorgradient", true);
            this.append("5 index 5 index 5 index 5 index 5 index roundrect", true);
            this.append("closepath eofill", true);
            this.append("pop", true);
            this.append("} for", true);
            this.append("pop pop pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("pop pop pop", true);
            this.append("initclip", true);
        }
    }

    private void epsRectangleInternal(double x, double y, double width, double height, double rx, double ry, boolean fill) {
        if (rx == 0.0 && ry == 0.0) {
            this.simpleRectangle(x, y, width, height, fill);
        } else {
            this.roundRectangle(x, y, width, height, rx, ry);
        }
    }

    private void roundRectangle(double x, double y, double width, double height, double rx, double ry) {
        this.append(EpsGraphics.format(width) + " " + EpsGraphics.format(height) + " " + EpsGraphics.format(x) + " " + EpsGraphics.format(y) + " " + EpsGraphics.format((rx + ry) / 2.0) + " roundrect", true);
        this.roundrectUsed = true;
    }

    private void simpleRectangle(double x, double y, double width, double height, boolean fill) {
        if (this.dashSpace == 0.0 && this.dashVisible == 0.0 || fill) {
            this.append(EpsGraphics.format(width) + " " + EpsGraphics.format(height) + " " + EpsGraphics.format(x) + " " + EpsGraphics.format(y) + " simplerect", true);
            this.simplerectUsed = true;
        } else {
            this.epsVLine(y, x, x + width);
            this.epsVLine(y + height, x, x + width);
            this.epsHLine(x, y, y + height);
            this.epsHLine(x + width, y, y + height);
        }
    }

    public void epsEllipse(double x, double y, double xRadius, double yRadius, double start, double extend) {
        this.checkCloseDone();
        this.ensureVisible(x + xRadius, y + yRadius);
        double scale = 1.0;
        if (xRadius != yRadius) {
            scale = yRadius / xRadius;
            this.append("gsave", true);
            this.append("1 " + EpsGraphics.format(scale) + " scale", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            double a1 = -start + 180.0 + 5.0;
            double a2 = -start - extend + 180.0 - 5.0;
            this.append(EpsGraphics.format(x) + " " + EpsGraphics.format(y / scale) + " " + EpsGraphics.format(xRadius) + " " + EpsGraphics.format(a1) + " " + EpsGraphics.format(a2) + " arc", true);
            this.append("stroke", true);
        }
        if (scale != 1.0) {
            this.append("grestore", true);
        }
    }

    public void epsEllipse(double x, double y, double xRadius, double yRadius) {
        this.checkCloseDone();
        this.ensureVisible(x + xRadius, y + yRadius);
        double scale = 1.0;
        if (xRadius != yRadius) {
            scale = yRadius / xRadius;
            this.append("gsave", true);
            this.append("1 " + EpsGraphics.format(scale) + " scale", true);
        }
        if (this.fillcolor != null) {
            this.appendColor(this.fillcolor);
            this.append("newpath", true);
            this.append(EpsGraphics.format(x) + " " + EpsGraphics.format(y / scale) + " " + EpsGraphics.format(xRadius) + " 0 360 arc", true);
            this.append("closepath eofill", true);
        }
        if (this.color != null) {
            this.append(this.strokeWidth + " setlinewidth", true);
            this.appendColor(this.color);
            this.append("newpath", true);
            this.append(EpsGraphics.format(x) + " " + EpsGraphics.format(y / scale) + " " + EpsGraphics.format(xRadius) + " 0 360 arc", true);
            this.append("closepath stroke", true);
        }
        if (scale != 1.0) {
            this.append("grestore", true);
        }
    }

    protected void appendColor(Color c) {
        if (c == null) {
            return;
        }
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        this.append(EpsGraphics.format(r) + " " + EpsGraphics.format(g) + " " + EpsGraphics.format(b) + " setrgbcolor", true);
    }

    protected void appendColorShort(Color c) {
        if (c == null) {
            return;
        }
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        this.append(EpsGraphics.format(r) + " " + EpsGraphics.format(g) + " " + EpsGraphics.format(b), true);
    }

    public static String format(double x) {
        if (x == 0.0) {
            return "0";
        }
        String s = String.format(Locale.US, "%1.4f", x);
        if ((s = s.replaceAll("(\\.\\d*?)0+$", "$1")).endsWith(".")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected void append(String s, boolean checkConsistence) {
        if (checkConsistence && s.indexOf("  ") != -1) {
            throw new IllegalArgumentException(s);
        }
        this.body.append(s + "\n");
    }

    public final void linetoNoMacro(double x1, double y1) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " lineto", true);
        this.ensureVisible(x1, y1);
    }

    public final void movetoNoMacro(double x1, double y1) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " moveto", true);
        this.ensureVisible(x1, y1);
    }

    public final void curvetoNoMacro(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " " + EpsGraphics.format(x2) + " " + EpsGraphics.format(y2) + " " + EpsGraphics.format(x3) + " " + EpsGraphics.format(y3) + " curveto", true);
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
        this.ensureVisible(x3, y3);
    }

    public void moveto(double x1, double y1) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " moveto", true);
        this.ensureVisible(x1, y1);
    }

    public void lineto(double x1, double y1) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " lineto", true);
        this.ensureVisible(x1, y1);
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " " + EpsGraphics.format(x2) + " " + EpsGraphics.format(y2) + " " + EpsGraphics.format(x3) + " " + EpsGraphics.format(y3) + " curveto", true);
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
        this.ensureVisible(x3, y3);
    }

    public void quadto(double x1, double y1, double x2, double y2) {
        this.append(EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " " + EpsGraphics.format(x1) + " " + EpsGraphics.format(y1) + " " + EpsGraphics.format(x2) + " " + EpsGraphics.format(y2) + " curveto", true);
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
    }

    public void newpath() {
        this.append("0 setlinewidth", true);
        this.appendColor(this.color);
        this.append("newpath", true);
    }

    public void closepath() {
        this.append("closepath", true);
    }

    public void fill(int windingRule) {
        this.append("%fill", true);
        if (windingRule == 0) {
            this.append("eofill", true);
        } else if (windingRule == 1) {
            this.append("fill", true);
        }
    }

    public void drawImage(BufferedImage image, double x, double y) {
        int width = image.getWidth();
        int height = image.getHeight();
        this.append("gsave", true);
        this.append(EpsGraphics.format(x) + " " + EpsGraphics.format(y) + " translate", true);
        this.append(EpsGraphics.format(width) + " " + EpsGraphics.format(height) + " scale", true);
        this.append("" + width + " " + height + " 8 [" + width + " 0 0 -" + height + " 0 " + height + "]", true);
        this.append("{<", true);
        StringBuilder sb = new StringBuilder();
        for (int j = height - 1; j >= 0; --j) {
            for (int i = 0; i < width; ++i) {
                String hexString = EpsGraphics.getRgb(image.getRGB(i, j));
                assert (hexString.length() == 6);
                sb.append(hexString);
            }
        }
        this.append(sb.toString(), true);
        this.append(">} false 3 colorimage", true);
        this.ensureVisible(x + (double)width, y + (double)height);
        this.append("grestore", true);
    }

    static String getRgb(int x) {
        String s = "000000" + Integer.toHexString(x);
        return s.substring(s.length() - 6);
    }

    public void drawEps(String eps, double x, double y) {
        int idx = eps.indexOf("%%BoundingBox:");
        if (idx == -1) {
            throw new IllegalArgumentException();
        }
        StringTokenizer st = new StringTokenizer(eps.substring(idx + "%%BoundingBox:".length()), " \n\t\r");
        int x1 = Integer.parseInt(st.nextToken());
        int y1 = Integer.parseInt(st.nextToken());
        int x2 = Integer.parseInt(st.nextToken());
        int y2 = Integer.parseInt(st.nextToken());
        assert (x2 >= x1);
        assert (y2 >= y1);
        this.append("gsave", true);
        double dx = x - (double)x1;
        double dy = y + (double)y2;
        this.append(EpsGraphics.format(dx) + " " + EpsGraphics.format(dy) + " translate", true);
        this.append("1 -1 scale", true);
        this.append(eps, false);
        this.ensureVisible(x + (double)(x2 - x1), y + (double)(y2 - y1));
        this.append("grestore", true);
    }

    protected final double getDashVisible() {
        return this.dashVisible;
    }

    protected final double getDashSpace() {
        return this.dashSpace;
    }

    public void closeLink() {
        if (this.urlArea != null && this.urlArea.xmin != Integer.MAX_VALUE) {
            int width = this.urlArea.xmax - this.urlArea.xmin;
            int height = this.urlArea.ymax - this.urlArea.ymin;
            assert (width >= 0 && height >= 0);
            this.epsUrlLink(this.urlArea.xmin, this.urlArea.ymin, width, height, this.urlArea.url);
        }
        this.urlArea = null;
    }

    public void epsUrlLink(int x, int y, int width, int height, String url) {
        this.append("[ /Rect [ " + x + " " + y + " " + (x + width) + " " + (y + height) + " ]", true);
        this.append("/Border [ 0 0 0 ]", true);
        this.append("/Action << /Subtype /URI /URI (" + url + ") >>", true);
        this.append("/Subtype /Link", true);
        this.append("/ANN pdfmark", true);
    }

    public void openLink(String url) {
        this.urlArea = new UrlArea(url);
    }

    public void epsRectangleShadow(double x, double y, double width, double height, double rx, double ry, double deltaShadow) {
        this.setStrokeColor(null);
        for (double i = 0.0; i <= deltaShadow; i += 0.5) {
            this.setFillColor(this.shadowManager.getColor(i, deltaShadow));
            double diff = i;
            this.epsRectangle(x + deltaShadow + diff, y + deltaShadow + diff, width - 2.0 * diff, height - 2.0 * diff, rx + 1.0, ry + 1.0);
        }
    }

    public void epsPolygonShadow(double deltaShadow, double ... points) {
        this.setStrokeColor(null);
        for (double i = 0.0; i <= deltaShadow; i += 0.5) {
            this.setFillColor(this.shadowManager.getColor(i, deltaShadow));
            double diff = i;
            this.epsPolygon(this.shadowManager.getShadowDeltaPoints(deltaShadow, diff, points));
        }
    }

    public void epsEllipseShadow(double x, double y, double xRadius, double yRadius, double deltaShadow) {
        this.setStrokeColor(null);
        for (double i = 0.0; i <= deltaShadow; i += 0.5) {
            this.setFillColor(this.shadowManager.getColor(i, deltaShadow));
            double diff = i;
            this.epsEllipse(x + deltaShadow, y + deltaShadow, xRadius - diff, yRadius - diff);
        }
    }

    static class UrlArea {
        private final String url;
        private int xmin = Integer.MAX_VALUE;
        private int xmax = Integer.MIN_VALUE;
        private int ymin = Integer.MAX_VALUE;
        private int ymax = Integer.MIN_VALUE;

        UrlArea(String url) {
            this.url = url;
        }

        void ensureVisible(int x, int y) {
            if (x < this.xmin) {
                this.xmin = x;
            }
            if (x > this.xmax) {
                this.xmax = x;
            }
            if (y < this.ymin) {
                this.ymin = y;
            }
            if (y > this.ymax) {
                this.ymax = y;
            }
        }
    }
}

