/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole;

import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.creole.Atom;
import net.sourceforge.plantuml.creole.AtomTree;
import net.sourceforge.plantuml.creole.AtomWithMargin;
import net.sourceforge.plantuml.creole.CreoleContext;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.creole.Stripe;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.StripeStyle;
import net.sourceforge.plantuml.creole.StripeStyleType;
import net.sourceforge.plantuml.creole.StripeTable;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public class StripeTree
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTree tree;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.TREE, 0, '\u0000');

    public StripeTree(FontConfiguration fontConfiguration, ISkinSimple skinParam, String line) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        this.tree = new AtomTree(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.tree, 2.0, 2.0);
        this.analyzeAndAdd(line);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    public void analyzeAndAdd(String line) {
        List<String> lines = StripeTable.getWithNewlinesInternal(line);
        for (String s : lines) {
            StripeSimple cell2 = new StripeSimple(this.fontConfiguration, this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
            String text = s.replaceFirst("^\\s*\\|_", "");
            int level = (s.length() - text.length()) / 2;
            cell2.analyzeAndAdd(text);
            this.tree.addCell(StripeTable.asAtom(Collections.singletonList(cell2), 0.0), level);
        }
    }
}

