/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;

public class CommandHideShowSpecificClass
extends SingleLineCommand2<CucaDiagram> {
    public CommandHideShowSpecificClass() {
        super(CommandHideShowSpecificClass.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COMMAND", "(hide|show)"), new RegexLeaf("[%s]+"), new RegexLeaf("CODE", "([^%s{}%g<>]+)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(CucaDiagram diagram, RegexResult arg) {
        String codeString = arg.get("CODE", 0);
        if (codeString.equals("class")) {
            diagram.hideOrShow(LeafType.CLASS, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else if (codeString.equals("interface")) {
            diagram.hideOrShow(LeafType.INTERFACE, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        } else {
            Code code = Code.of(codeString);
            IEntity hidden = diagram.getEntityFactory().getLeafs().get(code);
            if (hidden == null) {
                hidden = diagram.getEntityFactory().getGroups().get(code);
            }
            if (hidden == null) {
                return CommandExecutionResult.error("Class/Package does not exist : " + code.getFullName());
            }
            diagram.hideOrShow(hidden, arg.get("COMMAND", 0).equalsIgnoreCase("show"));
        }
        return CommandExecutionResult.ok();
    }
}

