/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.PaddingParam;
import net.sourceforge.plantuml.RoundParam;
import net.sourceforge.plantuml.SplitParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.TikzFontDistortion;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.cucadiagram.LinkStyle;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.ColorMapperReverse;
import net.sourceforge.plantuml.ugraphic.ColorOrder;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import net.sourceforge.plantuml.ugraphic.sprite.SpriteImage;

public class SkinParam
implements ISkinParam {
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern2 stereoPattern = MyPattern.cmpile("\\<\\<(.*?)\\>\\>");
    private final Map<String, String> params = new HashMap<String, String>();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private String dotExecutable;
    private final UmlDiagramType type;
    private final Map<String, List<String>> cacheCleanForKey = new HashMap<String, List<String>>();
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private final IHtmlColorSet htmlColorSet = new HtmlColorSetSimple();

    @Override
    public String getDotExecutable() {
        return this.dotExecutable;
    }

    public void setDotExecutable(String dotExecutable) {
        Log.info("Overwritting dot in skinparam " + dotExecutable);
        this.dotExecutable = dotExecutable;
    }

    public void setParam(String key, String value) {
        for (String key2 : this.cleanForKey(key)) {
            this.params.put(key2, StringUtils.trin(value));
        }
    }

    private SkinParam(UmlDiagramType type) {
        this.type = type;
    }

    public static SkinParam create(UmlDiagramType type) {
        return new SkinParam(type);
    }

    public static SkinParam noShadowing(UmlDiagramType type) {
        SkinParam result = new SkinParam(type);
        result.setParam("shadowing", "false");
        return result;
    }

    List<String> cleanForKey(String key) {
        List<String> result = this.cacheCleanForKey.get(key);
        if (result == null) {
            result = this.cleanForKeySlow(key);
            this.cacheCleanForKey.put(key, result);
        }
        return result;
    }

    List<String> cleanForKeySlow(String key) {
        key = StringUtils.trin(StringUtils.goLowerCase(key));
        key = key.replaceAll("_|\\.|\\s", "");
        key = SkinParam.replaceSmart(key, "sequenceparticipant", "participant");
        key = SkinParam.replaceSmart(key, "sequenceactor", "actor");
        key = key.replaceAll("activityarrow", "arrow");
        key = key.replaceAll("objectarrow", "arrow");
        key = key.replaceAll("classarrow", "arrow");
        key = key.replaceAll("componentarrow", "arrow");
        key = key.replaceAll("statearrow", "arrow");
        key = key.replaceAll("usecasearrow", "arrow");
        key = key.replaceAll("sequencearrow", "arrow");
        Matcher2 mm = stereoPattern.matcher(key);
        ArrayList<String> result = new ArrayList<String>();
        while (mm.find()) {
            String s = mm.group(1);
            result.add(key.replaceAll(stereoPatternString, "") + "<<" + s + ">>");
        }
        if (result.size() == 0) {
            result.add(key);
        }
        return Collections.unmodifiableList(result);
    }

    private static String replaceSmart(String s, String src, String target) {
        if (!s.contains(src)) {
            return s;
        }
        return s.replaceAll(src, target);
    }

    @Override
    public HtmlColor getHyperlinkColor() {
        HtmlColor result = this.getHtmlColor(ColorParam.hyperlink, null, false);
        if (result == null) {
            return HtmlColorUtils.BLUE;
        }
        return result;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        HtmlColor result = this.getHtmlColor(ColorParam.background, null, false);
        if (result == null) {
            return HtmlColorUtils.WHITE;
        }
        return result;
    }

    @Override
    public String getValue(String key) {
        for (String key2 : this.cleanForKey(key)) {
            String result = this.params.get(key2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static String humanName(String key) {
        StringBuilder sb = new StringBuilder();
        boolean upper = true;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '_') {
                upper = true;
                continue;
            }
            sb.append(upper ? StringUtils.goUpperCase(c) : StringUtils.goLowerCase(c));
            upper = false;
        }
        return sb.toString();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam param, Stereotype stereotype, boolean clickable) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            for (String s : stereotype.getMultipleLabels()) {
                String value2 = this.getValue(param.name() + "color<<" + s + ">>");
                if (value2 == null || this.getIHtmlColorSet().getColorIfValid(value2) == null) continue;
                return this.getIHtmlColorSet().getColorIfValid(value2);
            }
        }
        if ((value = this.getValue(this.getParamName(param, clickable))) == null) {
            return null;
        }
        boolean acceptTransparent = param == ColorParam.background || param == ColorParam.sequenceGroupBodyBackground || param == ColorParam.sequenceBoxBackground;
        return this.getIHtmlColorSet().getColorIfValid(value, acceptTransparent);
    }

    @Override
    public Colors getColors(ColorParam param, Stereotype stereotype) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue(param.name() + "color" + stereotype.getLabel(false));
            if (value2 != null && this.getIHtmlColorSet().getColorIfValid(value2) != null) {
                return new Colors(value2, this.getIHtmlColorSet(), param.getColorType());
            }
        }
        if ((value = this.getValue(this.getParamName(param, false))) == null) {
            return Colors.empty();
        }
        return new Colors(value, this.getIHtmlColorSet(), param.getColorType());
    }

    private String getParamName(ColorParam param, boolean clickable) {
        String n = param.name();
        if (clickable && n.endsWith("Background")) {
            n = n.replaceAll("Background", "ClickableBackground");
        } else if (clickable && n.endsWith("Border")) {
            n = n.replaceAll("Border", "ClickableBorder");
        }
        return n + "color";
    }

    private void checkStereotype(Stereotype stereotype) {
    }

    private int getFontSize(Stereotype stereotype, FontParam ... param) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getFirstValueNonNullWithSuffix("fontsize" + stereotype.getLabel(false), param);
            if (value2 != null && value2.matches("\\d+")) {
                return Integer.parseInt(value2);
            }
        }
        if ((value = this.getFirstValueNonNullWithSuffix("fontsize", param)) == null || !value.matches("\\d+")) {
            value = this.getValue("defaultfontsize");
        }
        if (value == null || !value.matches("\\d+")) {
            return param[0].getDefaultSize(this);
        }
        return Integer.parseInt(value);
    }

    private String getFontFamily(Stereotype stereotype, FontParam ... param) {
        String value;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getFirstValueNonNullWithSuffix("fontname" + stereotype.getLabel(false), param);
            if (value2 != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value2);
            }
        }
        if ((value = this.getFirstValueNonNullWithSuffix("fontname", param)) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        if (param[0] != FontParam.CIRCLED_CHARACTER && (value = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(value);
        }
        return param[0].getDefaultFamily();
    }

    @Override
    public HtmlColor getFontHtmlColor(Stereotype stereotype, FontParam ... param) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getFirstValueNonNullWithSuffix("fontcolor" + stereotype.getLabel(false), param);
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = this.getFirstValueNonNullWithSuffix("fontcolor", param);
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = this.getValue("defaultfontcolor");
        }
        if (value == null || this.getIHtmlColorSet().getColorIfValid(value) == null) {
            value = param[0].getDefaultColor();
        }
        return this.getIHtmlColorSet().getColorIfValid(value);
    }

    private String getFirstValueNonNullWithSuffix(String suffix, FontParam ... param) {
        for (FontParam p : param) {
            String v = this.getValue(p.name() + suffix);
            if (v == null) continue;
            return v;
        }
        return null;
    }

    private int getFontStyle(Stereotype stereotype, boolean inPackageTitle, FontParam ... param) {
        String value = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value = this.getFirstValueNonNullWithSuffix("fontstyle" + stereotype.getLabel(false), param);
        }
        if (value == null) {
            value = this.getFirstValueNonNullWithSuffix("fontstyle", param);
        }
        if (value == null) {
            value = this.getValue("defaultfontstyle");
        }
        if (value == null) {
            return param[0].getDefaultFontStyle(this, inPackageTitle);
        }
        int result = 0;
        if (StringUtils.goLowerCase(value).contains("bold")) {
            result |= 1;
        }
        if (StringUtils.goLowerCase(value).contains("italic")) {
            result |= 2;
        }
        return result;
    }

    @Override
    public UFont getFont(Stereotype stereotype, boolean inPackageTitle, FontParam ... fontParam) {
        if (stereotype != null) {
            this.checkStereotype(stereotype);
        }
        String fontFamily = this.getFontFamily(stereotype, fontParam);
        int fontStyle = this.getFontStyle(stereotype, inPackageTitle, fontParam);
        int fontSize = this.getFontSize(stereotype, fontParam);
        return new UFont(fontFamily, fontStyle, fontSize);
    }

    @Override
    public int getCircledCharacterRadius() {
        String value = this.getValue("circledcharacterradius");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return this.getFontSize(null, FontParam.CIRCLED_CHARACTER) / 3 + 6;
    }

    @Override
    public int classAttributeIconSize() {
        String value = this.getValue("classAttributeIconSize");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 10;
    }

    public static Collection<String> getPossibleValues() {
        String h;
        TreeSet<String> result = new TreeSet<String>();
        result.add("Monochrome");
        result.add("CircledCharacterRadius");
        result.add("ClassAttributeIconSize");
        result.add("DefaultFontName");
        result.add("DefaultFontStyle");
        result.add("DefaultFontSize");
        result.add("DefaultFontColor");
        result.add("MinClassWidth");
        result.add("MinClassWidth");
        result.add("Dpi");
        result.add("DefaultTextAlignment");
        result.add("Shadowing");
        result.add("NoteShadowing");
        result.add("Handwritten");
        result.add("CircledCharacterRadius");
        result.add("ClassAttributeIconSize");
        result.add("Linetype");
        result.add("PackageStyle");
        result.add("ComponentStyle");
        result.add("StereotypePosition");
        result.add("Nodesep");
        result.add("Ranksep");
        result.add("RoundCorner");
        result.add("TitleBorderRoundCorner");
        result.add("MaxMessageSize");
        result.add("Style");
        result.add("SequenceParticipant");
        result.add("ConditionStyle");
        result.add("SameClassWidth");
        result.add("HyperlinkUnderline");
        result.add("Padding");
        result.add("Guillemet");
        result.add("SvglinkTarget");
        result.add("DefaultMonospacedFontName");
        result.add("TabSize");
        result.add("MaxAsciiMessageLength");
        result.add("ColorArrowSeparationSpace");
        for (FontParam fontParam : EnumSet.allOf(FontParam.class)) {
            h = SkinParam.humanName(fontParam.name());
            result.add(h + "FontStyle");
            result.add(h + "FontName");
            result.add(h + "FontSize");
            result.add(h + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            h = SkinParam.capitalize(colorParam.name());
            result.add(h + "Color");
        }
        for (LineParam lineParam : EnumSet.allOf(LineParam.class)) {
            h = SkinParam.capitalize(lineParam.name());
            result.add(h + "Thickness");
        }
        return Collections.unmodifiableSet(result);
    }

    private static String capitalize(String name) {
        return StringUtils.goUpperCase(name.substring(0, 1)) + name.substring(1);
    }

    @Override
    public int getDpi() {
        String value = this.getValue("dpi");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 96;
    }

    @Override
    public DotSplines getDotSplines() {
        String value = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(value)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(value)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment(AlignParam param, ArrowDirection arrowDirection) {
        HorizontalAlignment result;
        String value;
        switch (param) {
            case SEQUENCE_MESSAGE_ALIGN: {
                value = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 0);
                break;
            }
            case SEQUENCE_MESSAGETEXT_ALIGN: {
                value = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 1);
                break;
            }
            default: {
                value = this.getValue(param.name());
            }
        }
        if ("direction".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.LEFT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.RIGHT;
            }
        }
        if ("reversedirection".equalsIgnoreCase(value)) {
            if (arrowDirection == ArrowDirection.LEFT_TO_RIGHT_NORMAL) {
                return HorizontalAlignment.RIGHT;
            }
            if (arrowDirection == ArrowDirection.RIGHT_TO_LEFT_REVERSE) {
                return HorizontalAlignment.LEFT;
            }
        }
        if ((result = HorizontalAlignment.fromString(value)) == null) {
            return param.getDefaultValue();
        }
        return result;
    }

    @Override
    public HorizontalAlignment getDefaultTextAlignment(HorizontalAlignment defaultValue) {
        String value = this.getValue("defaulttextalignment");
        HorizontalAlignment result = HorizontalAlignment.fromString(value);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private String getArg(String value, int i) {
        if (value == null) {
            return null;
        }
        String[] split = value.split(":");
        if (i >= split.length) {
            return split[0];
        }
        return split[i];
    }

    @Override
    public ColorMapper getColorMapper() {
        String monochrome = this.getValue("monochrome");
        if ("true".equals(monochrome)) {
            return new ColorMapperMonochrome(false);
        }
        if ("reverse".equals(monochrome)) {
            return new ColorMapperMonochrome(true);
        }
        String value = this.getValue("reversecolor");
        if (value == null) {
            return new ColorMapperIdentity();
        }
        ColorOrder order = ColorOrder.fromString(value);
        if (order == null) {
            return new ColorMapperIdentity();
        }
        return new ColorMapperReverse(order);
    }

    @Override
    public boolean shadowing() {
        String value = this.getValue("shadowing");
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public boolean shadowingForNote(Stereotype stereotype) {
        String value2;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            value2 = this.getValue("noteshadowing" + stereotype.getLabel(false));
            if (value2 != null) {
                return value2.equalsIgnoreCase("true");
            }
        }
        if ((value2 = this.getValue("noteshadowing")) != null) {
            return value2.equalsIgnoreCase("true");
        }
        return this.shadowing();
    }

    @Override
    public boolean shadowing2(SkinParameter skinParameter) {
        if (skinParameter == null) {
            throw new IllegalArgumentException();
        }
        String name = skinParameter.getUpperCaseName();
        String value = this.getValue(name + "shadowing");
        if (value == null) {
            return this.shadowing();
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public PackageStyle getPackageStyle() {
        String value = this.getValue("packageStyle");
        PackageStyle p = PackageStyle.fromString(value);
        if (p == null) {
            return PackageStyle.FOLDER;
        }
        return p;
    }

    public void addSprite(String name, Sprite sprite) {
        this.sprites.put(name, sprite);
    }

    @Override
    public Sprite getSprite(String name) {
        Sprite result = this.sprites.get(name);
        if (result == null) {
            result = SpriteImage.fromInternal(name);
        }
        return result;
    }

    @Override
    public boolean useUml2ForComponent() {
        if (this.strictUmlStyle()) {
            return true;
        }
        String value = this.getValue("componentstyle");
        return "uml2".equalsIgnoreCase(value);
    }

    @Override
    public boolean stereotypePositionTop() {
        String value = this.getValue("stereotypePosition");
        return !"bottom".equalsIgnoreCase(value);
    }

    @Override
    public boolean useSwimlanes(UmlDiagramType type) {
        if (type != UmlDiagramType.ACTIVITY) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.getValue("swimlane"))) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getValue("swimlanes"));
    }

    @Override
    public double getNodesep() {
        String value = this.getValue("nodesep");
        if (value != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public double getRanksep() {
        String value = this.getValue("ranksep");
        if (value != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public double getRoundCorner(RoundParam param, Stereotype stereotype) {
        Double result = this.getRoundCornerInternal(param, stereotype);
        if (result != null) {
            return result;
        }
        result = this.getRoundCornerInternal(param, null);
        if (result != null) {
            return result;
        }
        if (param == RoundParam.DEFAULT) {
            return 0.0;
        }
        return this.getRoundCorner(RoundParam.DEFAULT, stereotype);
    }

    private Double getRoundCornerInternal(RoundParam param, Stereotype stereotype) {
        String value;
        String key = param.getKey();
        if (stereotype != null) {
            key = key + stereotype.getLabel(false);
        }
        if ((value = this.getValue(key)) != null && value.matches("\\d+")) {
            return Double.parseDouble(value);
        }
        return null;
    }

    @Override
    public UStroke getThickness(LineParam param, Stereotype stereotype) {
        String styleValue;
        String value;
        LinkStyle style = null;
        if (stereotype != null) {
            String value2;
            this.checkStereotype(stereotype);
            String styleValue2 = this.getValue(param.name() + "style" + stereotype.getLabel(false));
            if (styleValue2 != null) {
                style = LinkStyle.fromString2(styleValue2);
            }
            if ((value2 = this.getValue(param.name() + "thickness" + stereotype.getLabel(false))) != null && value2.matches("[\\d.]+")) {
                if (style == null) {
                    style = LinkStyle.NORMAL();
                }
                return style.goThickness(Double.parseDouble(value2)).getStroke3();
            }
        }
        if ((value = this.getValue(param.name() + "thickness")) != null && value.matches("[\\d.]+")) {
            if (style == null) {
                style = LinkStyle.NORMAL();
            }
            return style.goThickness(Double.parseDouble(value)).getStroke3();
        }
        if (style == null && (styleValue = this.getValue(param.name() + "style")) != null) {
            style = LinkStyle.fromString2(styleValue);
        }
        if (style != null && !style.isNormal()) {
            return style.getStroke3();
        }
        return null;
    }

    @Override
    public LineBreakStrategy maxMessageSize() {
        return new LineBreakStrategy(this.getValue("maxmessagesize"));
    }

    @Override
    public boolean strictUmlStyle() {
        String value = this.getValue("style");
        return "strictuml".equalsIgnoreCase(value);
    }

    @Override
    public boolean forceSequenceParticipantUnderlined() {
        String value = this.getValue("sequenceParticipant");
        return "underline".equalsIgnoreCase(value);
    }

    @Override
    public ConditionStyle getConditionStyle() {
        String value = this.getValue("conditionStyle");
        ConditionStyle p = ConditionStyle.fromString(value);
        if (p == null) {
            return ConditionStyle.INSIDE;
        }
        return p;
    }

    @Override
    public double minClassWidth() {
        String value = this.getValue("minclasswidth");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 0.0;
    }

    @Override
    public boolean sameClassWidth() {
        return "true".equals(this.getValue("sameclasswidth"));
    }

    @Override
    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public boolean useOctagonForActivity(Stereotype stereotype) {
        String value = this.getValue("activityshape");
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String value2 = this.getValue("activityshape" + stereotype.getLabel(false));
            if (value2 != null) {
                value = value2;
            }
        }
        if ("roundedbox".equalsIgnoreCase(value)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(value);
    }

    @Override
    public IHtmlColorSet getIHtmlColorSet() {
        return this.htmlColorSet;
    }

    @Override
    public boolean useUnderlineForHyperlink() {
        String value = this.getValue("hyperlinkunderline");
        return !"false".equalsIgnoreCase(value);
    }

    @Override
    public int groupInheritance() {
        String value = this.getValue("groupinheritance");
        int result = Integer.MAX_VALUE;
        if (value != null && value.matches("\\d+")) {
            result = Integer.parseInt(value);
        }
        if (result <= 1) {
            result = Integer.MAX_VALUE;
        }
        return result;
    }

    @Override
    public boolean useGuillemet() {
        String value = this.getValue("guillemet");
        return !"false".equalsIgnoreCase(value);
    }

    @Override
    public boolean handwritten() {
        String value = this.getValue("handwritten");
        return "true".equalsIgnoreCase(value);
    }

    @Override
    public String getSvgLinkTarget() {
        String value = this.getValue("svglinktarget");
        if (value == null) {
            return "_top";
        }
        return value;
    }

    @Override
    public String getMonospacedFamily() {
        String value = this.getValue("defaultMonospacedFontName");
        if (value == null) {
            return "monospaced";
        }
        return value;
    }

    @Override
    public int getTabSize() {
        String value = this.getValue("tabsize");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 8;
    }

    @Override
    public int maxAsciiMessageLength() {
        String value = this.getValue("maxasciimessagelength");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    @Override
    public int colorArrowSeparationSpace() {
        String value = this.getValue("colorarrowseparationspace");
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public SplitParam getSplitParam() {
        String border = this.getValue("pageBorderColor");
        String external = this.getValue("pageExternalColor");
        String marginString = this.getValue("pageMargin");
        int margin = 0;
        if (marginString != null && marginString.matches("\\d+")) {
            margin = Integer.parseInt(marginString);
        }
        return new SplitParam(this.getIHtmlColorSet().getColorIfValid(border), this.getIHtmlColorSet().getColorIfValid(external), margin);
    }

    @Override
    public int swimlaneWidth() {
        String value = this.getValue("swimlanewidth");
        if ("same".equalsIgnoreCase(value)) {
            return -1;
        }
        if (value != null && value.matches("\\d+")) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return this.type;
    }

    @Override
    public HtmlColor getHoverPathColor() {
        String value = this.getValue("pathhovercolor");
        if (value == null) {
            return null;
        }
        return this.getIHtmlColorSet().getColorIfValid(value, false);
    }

    @Override
    public double getPadding() {
        String value = this.getValue("padding");
        if (value != null && value.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public double getPadding(PaddingParam param) {
        String value = this.getValue(param.getSkinName());
        if (value != null && value.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(value);
        }
        return 0.0;
    }

    @Override
    public boolean useRankSame() {
        return false;
    }

    @Override
    public boolean displayGenericWithOldFashion() {
        String value = this.getValue("genericDisplay");
        return "old".equalsIgnoreCase(value);
    }

    @Override
    public TikzFontDistortion getTikzFontDistortion() {
        String value = this.getValue("tikzFont");
        return TikzFontDistortion.fromValue(value);
    }
}

