/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.CharSequence2;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.ErrorUmlType;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.acearth.PSystemXearthFactory;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagramFactory;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagramFactory3;
import net.sourceforge.plantuml.api.PSystemFactory;
import net.sourceforge.plantuml.bpm.BpmDiagramFactory;
import net.sourceforge.plantuml.classdiagram.ClassDiagramFactory;
import net.sourceforge.plantuml.compositediagram.CompositeDiagramFactory;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.creole.PSystemCreoleFactory;
import net.sourceforge.plantuml.cute.PSystemCuteFactory;
import net.sourceforge.plantuml.dedication.PSystemDedicationFactory;
import net.sourceforge.plantuml.definition.PSystemDefinitionFactory;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagramFactory;
import net.sourceforge.plantuml.directdot.PSystemDotFactory;
import net.sourceforge.plantuml.ditaa.PSystemDitaaFactory;
import net.sourceforge.plantuml.donors.PSystemDonorsFactory;
import net.sourceforge.plantuml.donors.PSystemSkinparameterListFactory;
import net.sourceforge.plantuml.eggs.PSystemAppleTwoFactory;
import net.sourceforge.plantuml.eggs.PSystemCharlieFactory;
import net.sourceforge.plantuml.eggs.PSystemColorsFactory;
import net.sourceforge.plantuml.eggs.PSystemEggFactory;
import net.sourceforge.plantuml.eggs.PSystemLostFactory;
import net.sourceforge.plantuml.eggs.PSystemPathFactory;
import net.sourceforge.plantuml.eggs.PSystemRIPFactory;
import net.sourceforge.plantuml.eggs.PSystemWelcomeFactory;
import net.sourceforge.plantuml.flowdiagram.FlowDiagramFactory;
import net.sourceforge.plantuml.font.PSystemListFontsFactory;
import net.sourceforge.plantuml.jcckit.PSystemJcckitFactory;
import net.sourceforge.plantuml.jungle.PSystemTreeFactory;
import net.sourceforge.plantuml.logo.PSystemLogoFactory;
import net.sourceforge.plantuml.math.PSystemLatexFactory;
import net.sourceforge.plantuml.math.PSystemMathFactory;
import net.sourceforge.plantuml.openiconic.PSystemListOpenIconicFactory;
import net.sourceforge.plantuml.openiconic.PSystemOpenIconicFactory;
import net.sourceforge.plantuml.oregon.PSystemOregonFactory;
import net.sourceforge.plantuml.postit.PostIdDiagramFactory;
import net.sourceforge.plantuml.printskin.PrintSkinFactory;
import net.sourceforge.plantuml.project3.GanttDiagramFactory;
import net.sourceforge.plantuml.salt.PSystemSaltFactory;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagramFactory;
import net.sourceforge.plantuml.statediagram.StateDiagramFactory;
import net.sourceforge.plantuml.stats.StatsUtilsIncrement;
import net.sourceforge.plantuml.sudoku.PSystemSudokuFactory;
import net.sourceforge.plantuml.timingdiagram.TimingDiagramFactory;
import net.sourceforge.plantuml.ugraphic.sprite.PSystemListInternalSpritesFactory;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.PSystemLicenseFactory;
import net.sourceforge.plantuml.version.PSystemVersionFactory;

public class PSystemBuilder {
    public static final long startTime = System.currentTimeMillis();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Diagram createPSystem(List<CharSequence2> strings2, int startLine) {
        long now = System.currentTimeMillis();
        Object result = null;
        try {
            DiagramType type = DiagramType.getTypeFromArobaseStart(strings2.get(0).toString2());
            UmlSource umlSource = new UmlSource(strings2, type == DiagramType.UML, startLine);
            for (CharSequence2 s : strings2) {
                if (s.getPreprocessorError() == null) continue;
                Log.error("Preprocessor Error: " + s.getPreprocessorError());
                ErrorUml err = new ErrorUml(ErrorUmlType.SYNTAX_ERROR, s.getPreprocessorError(), s.getLocation());
                PSystemError pSystemError = new PSystemError(umlSource, err, Collections.emptyList());
                return pSystemError;
            }
            DiagramType diagramType = umlSource.getDiagramType();
            ArrayList<PSystemError> errors = new ArrayList<PSystemError>();
            List<PSystemFactory> factories = this.getAllFactories();
            for (PSystemFactory systemFactory : factories) {
                if (diagramType != systemFactory.getDiagramType()) continue;
                Diagram sys = systemFactory.createSystem(umlSource);
                if (this.isOk(sys)) {
                    result = sys;
                    Diagram diagram = sys;
                    return diagram;
                }
                errors.add((PSystemError)sys);
            }
            PSystemError err = PSystemError.merge(errors);
            result = err;
            PSystemError pSystemError = err;
            return pSystemError;
        }
        finally {
            if (result != null && OptionFlags.getInstance().isEnableStats()) {
                StatsUtilsIncrement.onceMoreParse(System.currentTimeMillis() - now, result.getClass());
            }
        }
    }

    private List<PSystemFactory> getAllFactories() {
        ArrayList<PSystemFactory> factories = new ArrayList<PSystemFactory>();
        factories.add(new PSystemWelcomeFactory());
        factories.add(new PSystemColorsFactory());
        factories.add(new SequenceDiagramFactory());
        factories.add(new ClassDiagramFactory());
        factories.add(new ActivityDiagramFactory());
        factories.add(new DescriptionDiagramFactory());
        factories.add(new StateDiagramFactory());
        factories.add(new ActivityDiagramFactory3());
        factories.add(new CompositeDiagramFactory());
        factories.add(new BpmDiagramFactory(DiagramType.BPM));
        factories.add(new PostIdDiagramFactory());
        factories.add(new PrintSkinFactory());
        factories.add(new PSystemLicenseFactory());
        factories.add(new PSystemVersionFactory());
        factories.add(new PSystemDonorsFactory());
        factories.add(new PSystemSkinparameterListFactory());
        factories.add(new PSystemListFontsFactory());
        factories.add(new PSystemOpenIconicFactory());
        factories.add(new PSystemListOpenIconicFactory());
        factories.add(new PSystemListInternalSpritesFactory());
        factories.add(new PSystemSaltFactory(DiagramType.SALT));
        factories.add(new PSystemSaltFactory(DiagramType.UML));
        factories.add(new PSystemDotFactory(DiagramType.DOT));
        factories.add(new PSystemDotFactory(DiagramType.UML));
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemDitaaFactory(DiagramType.DITAA));
            factories.add(new PSystemDitaaFactory(DiagramType.UML));
            factories.add(new PSystemJcckitFactory(DiagramType.JCCKIT));
            factories.add(new PSystemJcckitFactory(DiagramType.UML));
            factories.add(new PSystemLogoFactory());
            factories.add(new PSystemSudokuFactory());
        }
        factories.add(new PSystemDefinitionFactory());
        factories.add(new PSystemMathFactory(DiagramType.MATH));
        factories.add(new PSystemLatexFactory(DiagramType.LATEX));
        factories.add(new PSystemCreoleFactory());
        factories.add(new PSystemEggFactory());
        factories.add(new PSystemAppleTwoFactory());
        factories.add(new PSystemRIPFactory());
        factories.add(new PSystemLostFactory());
        factories.add(new PSystemPathFactory());
        factories.add(new PSystemOregonFactory());
        factories.add(new PSystemCharlieFactory());
        if (License.getCurrent() == License.GPL || License.getCurrent() == License.GPLV2) {
            factories.add(new PSystemXearthFactory());
        }
        factories.add(new GanttDiagramFactory(DiagramType.GANTT));
        factories.add(new GanttDiagramFactory(DiagramType.UML));
        factories.add(new FlowDiagramFactory());
        factories.add(new PSystemTreeFactory(DiagramType.JUNGLE));
        factories.add(new PSystemCuteFactory(DiagramType.CUTE));
        factories.add(new PSystemDedicationFactory());
        factories.add(new TimingDiagramFactory());
        return factories;
    }

    private boolean isOk(Diagram ps) {
        return ps != null && !(ps instanceof PSystemError);
    }
}

