/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.awt.Color;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Polygon;
import jcckit.graphic.ShapeAttributes;
import jcckit.plot.Curve;
import jcckit.plot.Hint;
import jcckit.plot.Legend;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class SimpleCurve
implements Curve {
    public static final String SYMBOL_FACTORY_KEY = "symbolFactory";
    public static final String WITH_LINE_KEY = "withLine";
    public static final String SOFT_CLIPPING_KEY = "softClipping";
    public static final String LINE_ATTRIBUTES_KEY = "lineAttributes";
    public static final String INITIAL_HINT_FOR_NEXT_POINT_KEY = "initialHintForNextPoint";
    private final ClippingShape _clippingShape;
    private final SymbolFactory _symbolFactory;
    private final GraphicalComposite _symbols;
    private final GraphicalComposite _completeCurve;
    private final GraphicalElement _legendSymbol;
    private final Hint _initialHintForNextPoint;
    private final Polygon _curve;
    private final boolean _softClipping;
    private Hint _hintForNextPoint;

    public SimpleCurve(ConfigParameters config, int curveIndex, int numberOfCurves, ClippingShape clippingShape, Legend legend) {
        this._symbolFactory = (SymbolFactory)Factory.createOrGet(config.getNode(SYMBOL_FACTORY_KEY), null);
        boolean withLine = config.getBoolean(WITH_LINE_KEY, true);
        LineAttributes lineAttributes = (LineAttributes)Factory.createOrGet(config.getNode(LINE_ATTRIBUTES_KEY), new ShapeAttributes(null, Color.getHSBColor((float)(curveIndex % 6) / 6.0f, 1.0f, 0.8f), 0.0, null));
        if (this._symbolFactory != null || withLine) {
            this._clippingShape = clippingShape;
            this._completeCurve = new GraphicalComposite(null);
            if (withLine) {
                GraphicalComposite container = new GraphicalComposite(clippingShape);
                this._curve = new Polygon(lineAttributes, false);
                container.addElement(this._curve);
                this._completeCurve.addElement(container);
            } else {
                this._curve = null;
            }
            this._softClipping = config.getBoolean(SOFT_CLIPPING_KEY, true);
            if (this._symbolFactory != null) {
                this._symbols = new GraphicalComposite(this._softClipping ? null : clippingShape);
                this._completeCurve.addElement(this._symbols);
            } else {
                this._symbols = null;
            }
        } else {
            throw new IllegalArgumentException("Either a SymbolFactory must exist or withLines == true.");
        }
        this._hintForNextPoint = this._initialHintForNextPoint = (Hint)Factory.createOrGet(config.getNode(INITIAL_HINT_FOR_NEXT_POINT_KEY), null);
        this._legendSymbol = legend.createSymbol(curveIndex, numberOfCurves, this._symbolFactory, withLine, lineAttributes);
    }

    @Override
    public GraphicalElement getView() {
        return this._completeCurve;
    }

    @Override
    public GraphicalElement getLegendSymbol() {
        return this._legendSymbol;
    }

    @Override
    public Hint addPoint(GraphPoint point2, Hint hintFromPreviousCurve) {
        if (this._curve != null) {
            this._curve.addPoint(point2);
        }
        Hint hintForNextCurve = hintFromPreviousCurve;
        if (this._symbolFactory != null) {
            Symbol symbol = this._symbolFactory.createSymbol(point2, this._hintForNextPoint, hintFromPreviousCurve);
            if (this._clippingShape == null || !this._softClipping || this._clippingShape.isInside(point2)) {
                this._symbols.addElement(symbol.getSymbol());
            }
            this._hintForNextPoint = symbol.getHintForNextPoint();
            hintForNextCurve = symbol.getHintForNextCurve();
        }
        return hintForNextCurve;
    }

    @Override
    public void removeAllPoints() {
        if (this._curve != null) {
            this._curve.removeAllPoints();
        }
        if (this._symbols != null) {
            this._symbols.removeAllElements();
        }
        this._hintForNextPoint = this._initialHintForNextPoint;
    }
}

