/*
 * Decompiled with CFR 0.152.
 */
package smile.vq;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.NominalAttribute;
import smile.data.parser.DelimitedTextParser;
import smile.data.parser.IOUtils;
import smile.validation.AdjustedRandIndex;
import smile.validation.RandIndex;
import smile.vq.NeuralMap;

public class NeuralMapTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testUSPS() {
        System.out.println("USPS");
        DelimitedTextParser parser = new DelimitedTextParser();
        parser.setResponseIndex(new NominalAttribute("class"), 0);
        try {
            AttributeDataset train = parser.parse("USPS Train", IOUtils.getTestDataFile("usps/zip.train"));
            AttributeDataset test = parser.parse("USPS Test", IOUtils.getTestDataFile("usps/zip.test"));
            double[][] x = (double[][])train.toArray((E[])new double[train.size()][]);
            int[] y = train.toArray(new int[train.size()]);
            double[][] testx = (double[][])test.toArray((E[])new double[test.size()][]);
            int[] testy = test.toArray(new int[test.size()]);
            NeuralMap cortex = new NeuralMap(x[0].length, 8.0, 0.05, 6.0E-4, 5, 3);
            for (int i = 0; i < 5; ++i) {
                for (double[] xi : x) {
                    cortex.update(xi);
                }
            }
            cortex.purge(16);
            cortex.partition(10);
            AdjustedRandIndex ari = new AdjustedRandIndex();
            RandIndex rand = new RandIndex();
            int[] p = new int[x.length];
            for (int i = 0; i < x.length; ++i) {
                p[i] = cortex.predict(x[i]);
            }
            double r = rand.measure(y, p);
            double r2 = ari.measure(y, p);
            System.out.format("Training rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
            p = new int[testx.length];
            for (int i = 0; i < testx.length; ++i) {
                p[i] = cortex.predict(testx[i]);
            }
            r = rand.measure(testy, p);
            r2 = ari.measure(testy, p);
            System.out.format("Testing rand index = %.2f%%\tadjusted rand index = %.2f%%%n", 100.0 * r, 100.0 * r2);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

