/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic.internal;

import smile.symbolic.internal.BinaryNode;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Expression;
import smile.symbolic.internal.Negation;
import smile.symbolic.internal.Sum;

public class Difference
extends BinaryNode {
    public Difference(Expression left, Expression right) {
        super(left, right, Expression.BinaryOperator.MINUS);
    }

    @Override
    public Expression derive() {
        return new Difference(this.left.derive(), this.right.derive());
    }

    @Override
    public Expression reduce() {
        Expression l = this.left.reduce();
        Expression r = this.right.reduce();
        if (l instanceof Constant || r instanceof Constant) {
            if (l.getValue() == 0.0) {
                return new Negation(r);
            }
            if (r.getValue() == 0.0) {
                return l;
            }
            if (l instanceof Constant && r instanceof Constant) {
                return new Constant(l.getValue() - r.getValue());
            }
        }
        if (l instanceof Negation) {
            return new Difference(r, l.getRightChild());
        }
        if (r instanceof Negation) {
            return new Sum(l, r.getRightChild());
        }
        return new Difference(l, r);
    }

    @Override
    public double getValue() {
        return 0.0;
    }
}

