/*
 * Decompiled with CFR 0.152.
 */
package smile.symbolic;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;
import smile.symbolic.ExpressionParser;
import smile.symbolic.internal.Constant;
import smile.symbolic.internal.Cosecant;
import smile.symbolic.internal.Cosine;
import smile.symbolic.internal.Cotangent;
import smile.symbolic.internal.Difference;
import smile.symbolic.internal.Exponent;
import smile.symbolic.internal.Expression;
import smile.symbolic.internal.Logarithm;
import smile.symbolic.internal.NaturalLogarithm;
import smile.symbolic.internal.Negation;
import smile.symbolic.internal.Product;
import smile.symbolic.internal.Quotient;
import smile.symbolic.internal.Secant;
import smile.symbolic.internal.Sine;
import smile.symbolic.internal.Sum;
import smile.symbolic.internal.Tangent;
import smile.symbolic.internal.Variable;

public class ExpressionTree {
    private Expression root;
    private String var;
    private double val;
    private ArrayList<String> tokens;

    public ExpressionTree() {
        this.init("x", new ArrayList<String>());
    }

    public ExpressionTree(String var, ArrayList<String> tokens) {
        this.init(var, tokens);
    }

    public Expression getRoot() {
        return this.root;
    }

    public double getVal() {
        return this.val;
    }

    public ArrayList<String> getTokens() {
        return this.tokens;
    }

    public void printTree() {
        LinkedList<Expression> currentLevel = new LinkedList<Expression>();
        LinkedList<Expression> nextLevel = new LinkedList<Expression>();
        currentLevel.add(this.root);
        while (!currentLevel.isEmpty()) {
            for (Expression currentNode : currentLevel) {
                if (currentNode.getLeftChild() != null) {
                    nextLevel.add(currentNode.getLeftChild());
                }
                if (currentNode.getRightChild() != null) {
                    nextLevel.add(currentNode.getRightChild());
                }
                System.out.print(currentNode.getType() + " ");
            }
            System.out.println();
            currentLevel = nextLevel;
            nextLevel = new LinkedList();
        }
        System.out.println("==================");
    }

    public void init(String var, ArrayList<String> tokens) {
        this.var = var;
        this.val = 0.0;
        this.tokens = tokens;
        this.root = this.constructTree(tokens);
    }

    public void reduce() {
        this.root = this.root.reduce();
    }

    public void derive() {
        this.root = this.root.derive();
    }

    public void derive(double val) {
        this.derive();
    }

    public String toString() {
        return this.createInfix(this.root);
    }

    public String createInfix(Expression root) {
        String str = "";
        String closeParen = "";
        String leftOpenParen = "";
        String leftCloseParen = "";
        if (root == null) {
            return str;
        }
        if (ExpressionParser.isOperand(root.getType(), this.var)) {
            str = str + root.getType();
        } else if (root.getType().equals("$")) {
            str = str + "-";
        } else if (ExpressionParser.isFunction(root.getType())) {
            str = str + root.getType();
            str = str + "(";
            closeParen = ")";
        } else {
            int parentPrecedence = ExpressionParser.getPrecedence(root.getType());
            str = str + root.getType();
            if (ExpressionParser.isOperator(root.getLeftChild().getType()) && ExpressionParser.getPrecedence(root.getLeftChild().getType()) < parentPrecedence) {
                leftOpenParen = "(";
                leftCloseParen = ")";
            } else if (ExpressionParser.isOperator(root.getRightChild().getType()) && ExpressionParser.getPrecedence(root.getRightChild().getType()) < parentPrecedence) {
                str = str + "(";
                closeParen = ")";
            }
        }
        return leftOpenParen + this.createInfix(root.getLeftChild()) + leftCloseParen + str + this.createInfix(root.getRightChild()) + closeParen;
    }

    public Expression constructTree(ArrayList<String> postTokens) {
        Expression root = null;
        Stack<Expression> nodes = new Stack<Expression>();
        for (String str : postTokens) {
            if (str.isEmpty()) continue;
            if (str.matches("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?")) {
                nodes.push(new Constant(Double.parseDouble(str)));
                continue;
            }
            if (str.equals(this.var)) {
                nodes.push(new Variable(this.var));
                continue;
            }
            if (!nodes.isEmpty() && ExpressionParser.isFunction(str)) {
                Expression function = this.matchFunc(str, (Expression)nodes.pop());
                nodes.push(function);
                continue;
            }
            if (!nodes.isEmpty() && str.equals("$")) {
                Negation unaryMinus = new Negation((Expression)nodes.pop());
                nodes.push(unaryMinus);
                continue;
            }
            if (nodes.isEmpty()) continue;
            Expression right = (Expression)nodes.pop();
            Expression binaryOperator = this.matchOperator(str, (Expression)nodes.pop(), right);
            nodes.push(binaryOperator);
        }
        if (!nodes.isEmpty()) {
            root = (Expression)nodes.pop();
        }
        return root;
    }

    public Expression matchFunc(String str, Expression exp) {
        switch (str) {
            case "ln": {
                return new NaturalLogarithm(exp);
            }
            case "log": {
                return new Logarithm(exp);
            }
            case "sin": {
                return new Sine(exp);
            }
            case "cos": {
                return new Cosine(exp);
            }
            case "tan": {
                return new Tangent(exp);
            }
            case "csc": {
                return new Cosecant(exp);
            }
            case "sec": {
                return new Secant(exp);
            }
            case "cot": {
                return new Cotangent(exp);
            }
        }
        System.out.println("BINARYEXPRESSIONTREE: Ambiguous function: " + str + " " + str.isEmpty());
        return null;
    }

    public Expression matchOperator(String str, Expression left, Expression right) {
        switch (str) {
            case "+": {
                return new Sum(left, right);
            }
            case "-": {
                return new Difference(left, right);
            }
            case "*": {
                return new Product(left, right);
            }
            case "/": {
                return new Quotient(left, right);
            }
            case "^": {
                return new Exponent(left, right);
            }
        }
        System.out.println("BINARYEXPRESSIONTREE: Ambiguous operator: " + str + " " + str.isEmpty());
        return null;
    }
}

