/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import smile.plot.PlotCanvas;

abstract class Projection {
    protected PlotCanvas canvas;
    private int[][] baseScreenCoords;

    public Projection(PlotCanvas canvas) {
        this.canvas = canvas;
        this.initBaseCoordsProjection();
    }

    public void reset() {
        this.initBaseCoordsProjection();
    }

    private void initBaseCoordsProjection() {
        this.baseScreenCoords = new int[this.canvas.base.baseCoords.length][2];
        for (int i = 0; i < this.canvas.base.dimension + 1; ++i) {
            double[] ratio = this.baseCoordsScreenProjectionRatio(this.canvas.base.baseCoords[i]);
            this.baseScreenCoords[i][0] = (int)((double)this.canvas.getWidth() * (this.canvas.margin + (1.0 - 2.0 * this.canvas.margin) * ratio[0]));
            this.baseScreenCoords[i][1] = (int)((double)this.canvas.getHeight() - (double)this.canvas.getHeight() * (this.canvas.margin + (1.0 - 2.0 * this.canvas.margin) * ratio[1]));
        }
    }

    public int[] screenProjection(double ... coord) {
        double[] sc = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (int i = 0; i < this.canvas.base.dimension; ++i) {
            sc[0] = sc[0] + (coord[i] - this.canvas.base.baseCoords[0][i]) / (this.canvas.base.baseCoords[i + 1][i] - this.canvas.base.baseCoords[0][i]) * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sc[1] = sc[1] + (coord[i] - this.canvas.base.baseCoords[0][i]) / (this.canvas.base.baseCoords[i + 1][i] - this.canvas.base.baseCoords[0][i]) * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        return new int[]{(int)sc[0], (int)sc[1]};
    }

    public int[] screenProjectionBaseRatio(double ... coord) {
        double[] sc = new double[]{this.baseScreenCoords[0][0], this.baseScreenCoords[0][1]};
        for (int i = 0; i < this.canvas.base.dimension; ++i) {
            sc[0] = sc[0] + coord[i] * (double)(this.baseScreenCoords[i + 1][0] - this.baseScreenCoords[0][0]);
            sc[1] = sc[1] + coord[i] * (double)(this.baseScreenCoords[i + 1][1] - this.baseScreenCoords[0][1]);
        }
        return new int[]{(int)sc[0], (int)sc[1]};
    }

    abstract double[] baseCoordsScreenProjectionRatio(double[] var1);
}

