/*
 * Decompiled with CFR 0.152.
 */
package smile.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import smile.plot.Graphics;
import smile.plot.Shape;

public class Line
extends Shape {
    private static final BasicStroke SOLID_STROKE = new BasicStroke(1.0f, 0, 1);
    private static final BasicStroke DOT_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private static final BasicStroke DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{10.0f}, 0.0f);
    private static final BasicStroke DOT_DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{10.0f, 2.0f, 2.0f, 2.0f}, 0.0f);
    private static final BasicStroke LONG_DASH_STROKE = new BasicStroke(1.0f, 0, 1, 1.0f, new float[]{20.0f}, 0.0f);
    private Stroke stroke;
    double[][] points;

    public Line(double[] ... points) {
        this.points = points;
        this.stroke = SOLID_STROKE;
    }

    public Line(Style style, double[] ... points) {
        switch (style) {
            case SOLID: {
                this.stroke = SOLID_STROKE;
                break;
            }
            case DOT: {
                this.stroke = DOT_STROKE;
                break;
            }
            case DASH: {
                this.stroke = DASH_STROKE;
                break;
            }
            case DOT_DASH: {
                this.stroke = DOT_DASH_STROKE;
                break;
            }
            case LONG_DASH: {
                this.stroke = LONG_DASH_STROKE;
                break;
            }
            default: {
                this.stroke = SOLID_STROKE;
            }
        }
        this.points = points;
    }

    public Line(Style style, Color color, double[] ... points) {
        super(color);
        switch (style) {
            case SOLID: {
                this.stroke = SOLID_STROKE;
                break;
            }
            case DOT: {
                this.stroke = DOT_STROKE;
                break;
            }
            case DASH: {
                this.stroke = DASH_STROKE;
                break;
            }
            case DOT_DASH: {
                this.stroke = DOT_DASH_STROKE;
                break;
            }
            case LONG_DASH: {
                this.stroke = LONG_DASH_STROKE;
            }
        }
        this.points = points;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public Line setStroke(Stroke stroke) {
        this.stroke = stroke;
        return this;
    }

    @Override
    public void paint(Graphics g) {
        Color c = g.getColor();
        g.setColor(this.getColor());
        Stroke s = g.getStroke();
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        g.drawLine(this.points);
        if (this.stroke != null) {
            g.setStroke(s);
        }
        g.setColor(c);
    }

    public static enum Style {
        SOLID,
        DOT,
        DASH,
        DOT_DASH,
        LONG_DASH;

    }
}

