/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.tokenizer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smile.nlp.tokenizer.ParagraphSplitter;

public class SimpleParagraphSplitter
implements ParagraphSplitter {
    private static Pattern REGEX_BLANK_LINE = Pattern.compile("(?m)^\\s+$");
    private static Pattern REGEX_PARAGRAPH = Pattern.compile("(\\n|(\\n\\r)|(\\r\\n)){2,}+|'\u2029+");
    private static SimpleParagraphSplitter singleton = new SimpleParagraphSplitter();

    private SimpleParagraphSplitter() {
    }

    public static SimpleParagraphSplitter getInstance() {
        return singleton;
    }

    @Override
    public String[] split(String text) {
        Matcher matcher = REGEX_BLANK_LINE.matcher(text);
        text = matcher.replaceAll("");
        return REGEX_PARAGRAPH.split(text);
    }
}

