/*
 * Decompiled with CFR 0.152.
 */
package smile.nlp.pos;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.nlp.pos.PennTreebankPOS;

public class EnglishPOSLexicon {
    private static final Logger logger = LoggerFactory.getLogger(EnglishPOSLexicon.class);
    private static final HashMap<String, PennTreebankPOS[]> dict = new HashMap();

    private EnglishPOSLexicon() {
    }

    public static PennTreebankPOS[] get(String word) {
        return dict.get(word);
    }

    static {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(EnglishPOSLexicon.class.getResourceAsStream("/smile/nlp/pos/part-of-speech_en.txt")));){
            String line = null;
            while ((line = input.readLine()) != null) {
                String[] pos = line.trim().split("\t");
                if (pos.length != 2) continue;
                int len = pos[1].length();
                if (pos[1].indexOf(124) != -1) {
                    --len;
                }
                PennTreebankPOS[] tag = new PennTreebankPOS[len];
                int k = 0;
                block26: for (int i = 0; i < pos[1].length(); ++i) {
                    switch (pos[1].charAt(i)) {
                        case 'N': {
                            tag[k++] = PennTreebankPOS.NN;
                            continue block26;
                        }
                        case 'p': {
                            tag[k++] = PennTreebankPOS.NNS;
                            continue block26;
                        }
                        case 'h': {
                            tag[k++] = PennTreebankPOS.NN;
                            continue block26;
                        }
                        case 'V': 
                        case 'i': 
                        case 't': {
                            tag[k++] = PennTreebankPOS.VB;
                            continue block26;
                        }
                        case 'A': {
                            tag[k++] = PennTreebankPOS.JJ;
                            continue block26;
                        }
                        case 'v': {
                            tag[k++] = PennTreebankPOS.RB;
                            continue block26;
                        }
                        case 'C': {
                            tag[k++] = PennTreebankPOS.CC;
                            continue block26;
                        }
                        case 'P': {
                            tag[k++] = PennTreebankPOS.IN;
                            continue block26;
                        }
                        case '!': {
                            tag[k++] = PennTreebankPOS.UH;
                            continue block26;
                        }
                        case 'r': {
                            tag[k++] = PennTreebankPOS.PRP;
                            continue block26;
                        }
                        case 'D': 
                        case 'I': {
                            tag[k++] = PennTreebankPOS.DT;
                            continue block26;
                        }
                        case 'o': {
                            tag[k++] = PennTreebankPOS.NN;
                        }
                    }
                }
                dict.put(pos[0], tag);
            }
        }
        catch (IOException ex) {
            logger.error("Failed to load /smile/nlp/pos/part-of-speech_en.txt", ex);
        }
    }
}

