/*
 * Decompiled with CFR 0.152.
 */
package smile.math.matrix;

import smile.math.matrix.DenseMatrix;
import smile.math.matrix.Matrix;

public class EVD {
    private double[] d;
    private double[] e;
    private DenseMatrix V;

    public EVD(DenseMatrix V, double[] d) {
        this.V = V;
        this.d = d;
    }

    public EVD(DenseMatrix V, double[] d, double[] e) {
        this.V = V;
        this.d = d;
        this.e = e;
    }

    public DenseMatrix getEigenVectors() {
        return this.V;
    }

    public double[] getEigenValues() {
        return this.d;
    }

    public double[] getRealEigenValues() {
        return this.d;
    }

    public double[] getImagEigenValues() {
        return this.e;
    }

    public DenseMatrix getD() {
        int n = this.V.nrows();
        DenseMatrix D = Matrix.zeros(n, n);
        for (int i = 0; i < n; ++i) {
            D.set(i, i, this.d[i]);
            if (this.e == null) continue;
            if (this.e[i] > 0.0) {
                D.set(i, i + 1, this.e[i]);
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D.set(i, i - 1, this.e[i]);
        }
        return D;
    }
}

