/*
 * Decompiled with CFR 0.152.
 */
package smile.manifold;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import smile.graph.AdjacencyList;
import smile.graph.Graph;
import smile.math.Math;
import smile.math.distance.EuclideanDistance;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.EVD;
import smile.math.matrix.Matrix;
import smile.neighbor.CoverTree;
import smile.neighbor.KDTree;
import smile.neighbor.NearestNeighborSearch;
import smile.neighbor.Neighbor;

public class IsoMap {
    private static final Logger logger = LoggerFactory.getLogger(IsoMap.class);
    private int[] index;
    private double[][] coordinates;
    private Graph graph;

    public IsoMap(double[][] data, int d, int k) {
        this(data, d, k, true);
    }

    public IsoMap(double[][] data, int d, int k, boolean CIsomap) {
        int i;
        int[][] cc;
        int n = data.length;
        NearestNeighborSearch knn = null;
        knn = data[0].length < 10 ? new KDTree(data, (E[])data) : new CoverTree<double[]>((E[])data, new EuclideanDistance());
        this.graph = new AdjacencyList(n);
        double[] M = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            Neighbor<double[], V>[] neighbors = knn.knn(data[i2], k);
            for (int j = 0; j < neighbors.length; ++j) {
                this.graph.setWeight(i2, neighbors[j].index, neighbors[j].distance);
                int n2 = i2;
                M[n2] = M[n2] + neighbors[j].distance;
            }
            M[i2] = Math.sqrt(M[i2] / (double)neighbors.length);
        }
        if (CIsomap) {
            for (Graph.Edge edge : this.graph.getEdges()) {
                edge.weight /= M[edge.v1] * M[edge.v2];
            }
        }
        if ((cc = this.graph.bfs()).length == 1) {
            this.index = new int[n];
            for (int i3 = 0; i3 < n; ++i3) {
                this.index[i3] = i3;
            }
        } else {
            n = 0;
            int component = 0;
            for (i = 0; i < cc.length; ++i) {
                if (cc[i].length <= n) continue;
                component = i;
                n = cc[i].length;
            }
            logger.info("IsoMap: {} connected components, largest one has {} samples.", (Object)cc.length, (Object)n);
            this.index = cc[component];
            this.graph = this.graph.subgraph(this.index);
        }
        double[][] D = this.graph.dijkstra();
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                D[i][j] = -0.5 * D[i][j] * D[i][j];
                D[j][i] = D[i][j];
            }
        }
        double[] mean = Math.rowMeans(D);
        double mu = Math.mean(mean);
        DenseMatrix B = Matrix.zeros(n, n);
        for (int i4 = 0; i4 < n; ++i4) {
            for (int j = 0; j <= i4; ++j) {
                double b = D[i4][j] - mean[i4] - mean[j] + mu;
                B.set(i4, j, b);
                B.set(j, i4, b);
            }
        }
        B.setSymmetric(true);
        EVD eigen = B.eigen(d);
        if (eigen.getEigenValues().length < d) {
            logger.warn("eigen({}) returns only {} eigen vectors", (Object)d, (Object)eigen.getEigenValues().length);
            d = eigen.getEigenValues().length;
        }
        DenseMatrix V = eigen.getEigenVectors();
        this.coordinates = new double[n][d];
        for (int j = 0; j < d; ++j) {
            if (eigen.getEigenValues()[j] < 0.0) {
                throw new IllegalArgumentException(String.format("Some of the first %d eigenvalues are < 0.", d));
            }
            double scale = Math.sqrt(eigen.getEigenValues()[j]);
            for (int i5 = 0; i5 < n; ++i5) {
                this.coordinates[i5][j] = V.get(i5, j) * scale;
            }
        }
    }

    public int[] getIndex() {
        return this.index;
    }

    public double[][] getCoordinates() {
        return this.coordinates;
    }

    public Graph getNearestNeighborGraph() {
        return this.graph;
    }
}

