/*
 * Decompiled with CFR 0.152.
 */
package smile.interpolation;

import smile.interpolation.Interpolation;
import smile.math.Math;
import smile.math.matrix.DenseMatrix;
import smile.math.matrix.LU;
import smile.math.matrix.Matrix;

public class KrigingInterpolation1D
implements Interpolation {
    private double[] x;
    private double[] yvi;
    private double[] vstar;
    private double alpha;
    private double beta;

    public KrigingInterpolation1D(double[] x, double[] y) {
        this.x = x;
        this.pow(x, y);
        int n = x.length;
        this.yvi = new double[n + 1];
        this.vstar = new double[n + 1];
        DenseMatrix v = Matrix.zeros(n + 1, n + 1);
        for (int i = 0; i < n; ++i) {
            this.yvi[i] = y[i];
            for (int j = i; j < n; ++j) {
                double var = this.variogram(Math.abs(x[i] - x[j]));
                v.set(i, j, var);
                v.set(j, i, var);
            }
            v.set(n, i, 1.0);
            v.set(i, n, 1.0);
        }
        this.yvi[n] = 0.0;
        v.set(n, n, 0.0);
        LU lu = v.lu(true);
        lu.solve(this.yvi);
    }

    @Override
    public double interpolate(double x) {
        int n = this.x.length;
        for (int i = 0; i < n; ++i) {
            this.vstar[i] = this.variogram(Math.abs(x - this.x[i]));
        }
        this.vstar[n] = 1.0;
        double y = 0.0;
        for (int i = 0; i <= n; ++i) {
            y += this.yvi[i] * this.vstar[i];
        }
        return y;
    }

    private void pow(double[] x, double[] y) {
        this.beta = 1.5;
        int n = x.length;
        double num = 0.0;
        double denom = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                double rb = Math.sqr(x[i] - x[j]);
                rb = Math.pow(rb, 0.5 * this.beta);
                num += rb * 0.5 * Math.sqr(y[i] - y[j]);
                denom += rb * rb;
            }
        }
        this.alpha = num / denom;
    }

    private double variogram(double r) {
        return this.alpha * Math.pow(r, this.beta);
    }
}

