/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.feature.SignalNoiseRatio;

public class SignalNoiseRatioTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testRank() {
        System.out.println("rank");
        try {
            ArffParser arffParser = new ArffParser();
            arffParser.setResponseIndex(4);
            AttributeDataset iris = arffParser.parse(IOUtils.getTestDataFile("weka/iris.arff"));
            double[][] x = (double[][])iris.toArray((E[])new double[iris.size()][]);
            int[] y = iris.toArray(new int[iris.size()]);
            for (int i = 0; i < y.length; ++i) {
                y[i] = y[i] < 2 ? 0 : 1;
            }
            SignalNoiseRatio s2n = new SignalNoiseRatio();
            double[] ratio = s2n.rank(x, y);
            Assert.assertEquals(4L, ratio.length);
            Assert.assertEquals(0.8743107, ratio[0], 1.0E-7);
            Assert.assertEquals(0.1502717, ratio[1], 1.0E-7);
            Assert.assertEquals(1.3446912, ratio[2], 1.0E-7);
            Assert.assertEquals(1.4757334, ratio[3], 1.0E-7);
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

