/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import smile.feature.FeatureRanking;
import smile.math.Math;

public class SignalNoiseRatio
implements FeatureRanking {
    @Override
    public double[] rank(double[][] x, int[] y) {
        if (x.length != y.length) {
            throw new IllegalArgumentException(String.format("The sizes of X and Y don't match: %d != %d", x.length, y.length));
        }
        int n1 = 0;
        for (int yi : y) {
            if (yi == 0) {
                ++n1;
                continue;
            }
            if (yi == 1) continue;
            throw new IllegalArgumentException("Invalid class label: " + yi);
        }
        int n = x.length;
        int n2 = n - n1;
        double[][] x1 = new double[n1][];
        double[][] x2 = new double[n2][];
        int j = 0;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (y[i] == 0) {
                x1[j++] = x[i];
                continue;
            }
            x2[k++] = x[i];
        }
        double[] mu1 = Math.colMeans(x1);
        double[] mu2 = Math.colMeans(x2);
        double[] sd1 = Math.colSds(x1);
        double[] sd2 = Math.colSds(x2);
        int p = mu1.length;
        double[] s2n = new double[p];
        for (int i = 0; i < p; ++i) {
            s2n[i] = Math.abs(mu1[i] - mu2[i]) / (sd1[i] + sd2[i]);
        }
        return s2n;
    }
}

