/*
 * Decompiled with CFR 0.152.
 */
package smile.feature;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import smile.data.Attribute;
import smile.data.AttributeDataset;
import smile.data.parser.ArffParser;
import smile.data.parser.IOUtils;
import smile.feature.OneHotEncoder;

public class OneHotEncoderTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testAttributes() {
        System.out.println("attributes");
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset weather = arffParser.parse(IOUtils.getTestDataFile("weka/weather.nominal.arff"));
            double[][] x = (double[][])weather.toArray((E[])new double[weather.size()][]);
            OneHotEncoder n2b = new OneHotEncoder(weather.attributes());
            Attribute[] attributes = n2b.attributes();
            Assert.assertEquals(10L, attributes.length);
            for (int i = 0; i < attributes.length; ++i) {
                System.out.println(attributes[i]);
                Assert.assertEquals((Object)Attribute.Type.NUMERIC, (Object)attributes[i].getType());
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    @Test
    public void testFeature() {
        System.out.println("feature");
        double[][] result = new double[][]{{1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0, 1.0, 0.0}};
        ArffParser arffParser = new ArffParser();
        arffParser.setResponseIndex(4);
        try {
            AttributeDataset weather = arffParser.parse(IOUtils.getTestDataFile("weka/weather.nominal.arff"));
            double[][] x = (double[][])weather.toArray((E[])new double[weather.size()][]);
            OneHotEncoder n2b = new OneHotEncoder(weather.attributes());
            for (int i = 0; i < x.length; ++i) {
                double[] y = n2b.feature(x[i]);
                for (int j = 0; j < y.length; ++j) {
                    Assert.assertEquals(result[i][j], y[j], 1.0E-7);
                }
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

